

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.Element;

import java.util.List;


//wrapper for VdmOutpatientMedicationPromiseBuilder
public class OutpatientMedicationPromiseBuilderFactory
    implements
        ClinicalDomainBuilderFactoryInterface
{
    private OutpatientMedicationPromiseBuilder outpatientMedicationPromiseBuilder = null;


    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        // call the appropriate builder and set the clinicaldata.patient.domain with it
        buildOutpatientMedicationPromiseData( clinicalData, cnt, patientIdentifier );
    }


    private void buildOutpatientMedicationPromiseData( Document clinicalData, int count, Element patientIdentifier )
    {
        Element rootElement = clinicalData.getRootElement();

        Element patient = rootElement.element( "patient" );

        List<Element> outpatientMedicationPromises = outpatientMedicationPromiseBuilder.makePharmacies( count, patientIdentifier );

        for ( Element outpatientMedicationPromise : outpatientMedicationPromises )
        {
            patient.add( outpatientMedicationPromise );
        }
    }


    public void setOutpatientMedicationPromiseBuilder( OutpatientMedicationPromiseBuilder outpatientMedicationPromiseBuilder )
    {
        this.outpatientMedicationPromiseBuilder = outpatientMedicationPromiseBuilder;
    }
}
