

package gov.va.med.cds.testharness.vhim400.builders;


import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class HAGoalTrackingBuilder
    extends
        AbstractEntryPointBuilder
{
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";

    private String recordIdentifier;
    private String goalName;
    private String goalEntryDate;
    private int IDX;


    public HAGoalTrackingBuilder( )
    {
        super();
    }


    public HAGoalTrackingBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HAGoalTrackingBuilder( String recordIdentifier, String goalEntryDate )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.goalEntryDate = goalEntryDate;
    }


    public HAGoalTrackingBuilder( String recordIdentifier, String goalName, String goalEntryDate )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.goalName = goalName;
        this.goalEntryDate = goalEntryDate;
    }


    public HAGoalTrackingBuilder( Random random )
    {
        super( random );
    }


    public List<Element> makeGoalsTracking( int number )
    {
        return makeGoalsTracking( number, null );
    }


    public List<Element> makeGoalsTracking( int number, Element patient )
    {
        return makeGoalsTracking( number, patient, true );
    }


    public List<Element> makeGoalsTracking( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> goalsTracking = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            goalsTracking.add( makeGoalTracking( "goalTracking", patient, updateRecordXml ) );
        }

        return goalsTracking;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makeGoalTracking( "goalTracking", personIdentifier );
    }


    public Element makeGoalTracking( String elementName, Element patientIdentifier )
    {
        return makeGoalTracking( elementName, patientIdentifier, false );
    }


    /*
    <xsd:complexType name="GoalTracking">
        <xsd:all>
            <xsd:element name="patient" type="common:PatientLite"/>
            <xsd:element name="recordIdentifier" type="basedatatypes:HL72EntityIdentifier" minOccurs="0"/>
            <xsd:element name="entryDate" type="basedatatypes:PointInTime" minOccurs="0"/>
            <xsd:element name="completionPercent" type="xsd:integer" default="0" minOccurs="0"/>
            <xsd:element name="comments" type="xsd:string" minOccurs="0"/>
            <xsd:element name="dataEnterer" type="xsd:string" minOccurs="0"/>
            <xsd:element name="allowAccessByClinicalStaff" type="xsd:boolean" default="true" minOccurs="0"/>
            <xsd:element name="goalName" type="xsd:string" minOccurs="0"/>
            <xsd:element name="goalType" type="xsd:string" minOccurs="0"/>
            <xsd:element name="goalDetails" type="xsd:string" minOccurs="0"/>
            <xsd:element name="recordVersion" type="xsd:integer" minOccurs="0"/>
        </xsd:all>
    </xsd:complexType>
     */
    public Element makeGoalTracking( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element newGoalTracking = DocumentHelper.createElement( elementName );

        Element newPatient = createPatientLite( "patient" );
        if ( patientIdentifier != null )
        {
            newPatient.element( "identifier" ).element( "identity" ).setText( patientIdentifier.elementText( "identity" ) );
            newPatient.element( "identifier" ).element( "assigningFacility" ).setText( ASSIGNING_FACILITY_HDR );
            newPatient.element( "identifier" ).element( "assigningAuthority" ).setText( ASSIGNINGAUTHORITY_HDR );
        }

        newGoalTracking.add( newPatient );

        Element newGoalTrackingDate = ( this.goalEntryDate != null ) ? createPointInTime( "entryDate", this.goalEntryDate ) : createFixedPointInTime( "entryDate" );
        newGoalTracking.add( newGoalTrackingDate );

        newGoalTracking.addElement( "completionPercent" ).addText( "25" );
        newGoalTracking.addElement( "comments" ).addText( "comments" );
        newGoalTracking.addElement( "dataEnterer" ).addText( "dataEnterer" );
        newGoalTracking.addElement( "allowAccessByClinicalStaff" ).addText( "true" );
        newGoalTracking.addElement( "goalName" ).addText( ( ( this.goalName != null ) ? this.goalName : "goalName" ) );
        newGoalTracking.addElement( "goalType" ).addText( "goalType" );
        newGoalTracking.addElement( "goalDetails" ).addText( "goalDetails" );

        if ( updateRecordXml )
        {
            if ( recordIdentifier != null )
            {
                Element element = DocumentHelper.createElement( "recordIdentifier" );
                element.addElement( "identity" ).addText( recordIdentifier );
                element.addElement( "namespaceId" ).addText( "NamespaceId" );
                element.addElement( "universalId" ).addText( "UniversalId" );
                element.addElement( "universalIdType" ).addText( "UniversalIdType" );
                newGoalTracking.add( element );
            }
            else
            {
                Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", IDX );
                newGoalTracking.add( newRecordIdentifier );
            }
        }

        return newGoalTracking;
    }


    public Element makeGoalTracking( String elementName, String recordIdentifier, String recordStatus )
    {
        Element newGoalsTracking = DocumentHelper.createElement( elementName );
        Element newGoalTracking = DocumentHelper.createElement( "goalTracking" );

        Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", recordIdentifier );
        newGoalTracking.add( newRecordIdentifier );

        newGoalTracking.addElement( "recordStatus" ).addText( recordStatus );
        newGoalsTracking.add( newGoalTracking );

        return newGoalsTracking;
    }


    public Element makeGoalTracking( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        Element newGoalsTracking = DocumentHelper.createElement( "goalsTracking" );
        List<Element> goalTrackingList = makeGoalsTracking( countObservations, patientIdentifier, updateRecordXml );
        for ( Element goalTracking : goalTrackingList )
        {
            newGoalsTracking.add( goalTracking );
        }

        return newGoalsTracking;
    }


    @Override
    public String fillPrintBuffer( Object aObject )
    {
        // TODO Auto-generated method stub
        return null;
    }


    public void setGoalName( String goalName )
    {
        this.goalName = goalName;
    }


    public void setGoalEntryDate( String goalEntryDate )
    {
        this.goalEntryDate = goalEntryDate;
    }
}
