

package gov.va.med.cds.testharness.vhim400.builders;


import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;

import org.apache.commons.logging.Log;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class DBQQuestionnaireResultBuilder
    extends
        AbstractEntryPointBuilder
{
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";

    private int IDX;
    
    private Boolean isCDATA = null;
    
    public DBQQuestionnaireResultBuilder()
    {
    	this(true);
    }

    public DBQQuestionnaireResultBuilder(boolean isCDATA)
    {
    	super();
    	this.isCDATA = isCDATA;
    }

    public DBQQuestionnaireResultBuilder( Random random )
    {
        super( random );
    }
    
    
    public List<Element> makeQuestionnaireResults( int number )
    {
        return makeQuestionnaireResults( number, null );
    }


    public List<Element> makeQuestionnaireResults( int number, Element patient )
    {
        return makeQuestionnaireResults( number, patient, true );
    }


    public List<Element> makeQuestionnaireResults( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> questionnaireResults = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            questionnaireResults.add( makeQuestionnaireResult( "questionnaireResult", patient, updateRecordXml ) );
        }

        return questionnaireResults;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makeQuestionnaireResult( "questionnaireResult", personIdentifier );
    }


    public Element makeQuestionnaireResult( String elementName, Element patientIdentifier )
    {
        return makeQuestionnaireResult( elementName, patientIdentifier, false );
    }


    /*
     	<xsd:schema xmlns:basedatatypes="Basedatatypes" xmlns:common="Common" xmlns:dbq="DBQ" xmlns:xsd="http://www.w3.org/2001/XMLSchema" targetNamespace="DBQ">
			<xsd:import namespace="Basedatatypes" schemaLocation="Basedatatypes.xsd"/>
			<xsd:import namespace="Common" schemaLocation="Common.xsd"/>
			<xsd:complexType name="QuestionnaireResult">
				<xsd:all>
					<xsd:element name="patient" type="common:PatientLite"/>[check]
					<xsd:element name="dateCreated" type="basedatatypes:PointInTime"/> [check]
					<xsd:element name="initiatingSystem" type="xsd:string"/> [check]
					<xsd:element name="dateModified" type="basedatatypes:PointInTime" minOccurs="0"/>[n/a]
					<xsd:element name="dbqDocumentId" type="basedatatypes:HL72EntityIdentifier"/>[check]
					<xsd:element name="facilityIdentifier" type="basedatatypes:HL72OrganizationIdentifier" minOccurs="0"/>[check]
					<xsd:element name="approvedFlag" type="xsd:string" minOccurs="0"/>
					<xsd:element name="approvedBy" type="common:PractitionerParticipationLite" minOccurs="0"/>
					<xsd:element name="author" type="common:PractitionerParticipationLite" minOccurs="0"/>
					<xsd:element name="detailXML" type="xsd:string"/>
					<xsd:element name="claimNumber" type="common:VaClaimId"/>
				</xsd:all>
			</xsd:complexType>
		</xsd:schema>
     */
    public Element makeQuestionnaireResult( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element questionnaireResult = DocumentHelper.createElement( elementName );
        Element patient = null;
        
        if ( patientIdentifier != null )
        {
            patient = createPatientLite( "patient" );
            patient.element( "identifier" ).element( "identity" ).setText( patientIdentifier.elementText( "identity" ) );
            patient.element( "identifier" ).element( "assigningFacility" ).setText( patientIdentifier.elementText( "assigningFacility" ) );
            patient.element( "identifier" ).element( "assigningAuthority" ).setText( patientIdentifier.elementText( "assigningAuthority" ) );
            
            Element dobElement = patientIdentifier.element("dateOfBirth");
            if ( dobElement != null )
            {
                patient.add( patientIdentifier.element( "dateOfBirth" ).detach() );
            }
        }
        
        questionnaireResult.add( patient );
        
        Element dateCreated = createFixedPointInTime("dateCreated");
        questionnaireResult.add(dateCreated);
        
        questionnaireResult.addElement( "documentType" ).addText( "Document Type" );
        
        questionnaireResult.addElement( "initiatingSystem" ).addText( "InitiatingSystem" );
        
        questionnaireResult.add( createHL72EntityIdentifier( "documentIdentifier", IDX ));
  
        questionnaireResult.add( createHL72OrganizationIdentifier( "facilityIdentifier" ) );
       
        questionnaireResult.addElement( "approvedFlag" ).addText( "APPROVED" );
        
        questionnaireResult.add( createPractitionerParticipationLite( "approvedBy", "Approved By Comment", AUTHOR_IDS ) );
        
        questionnaireResult.add( createPractitionerParticipationLite( "author", "Author Comment", AUTHOR_IDS ) );
        
        Element eDetailXml = questionnaireResult.addElement( "detailXML" );
        
        if(isCDATA)
        {
        	eDetailXml.add(DocumentHelper.createCDATA("<xml>HeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8JbzlpaiHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8JbzlpaiHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8JbzlpaiHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8JbzlpaiHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpai01</xml>"));
        }
        else
        {
        	try {
				eDetailXml.add(DocumentHelper.parseText("<xmlData>Hi</xmlData>").getRootElement());
			} catch (DocumentException e) {
				throw new RuntimeException("Error parsing test XML data.", e);
			}
        }
        
        questionnaireResult.addElement("claimNumber").addElement("root").addText(UUID.randomUUID().toString());

        return questionnaireResult;
    }


//    public Element makeQuestionnaireResult( String elementName, String recordIdentifier, String recordStatus )
//    {
//        Element newQuestionnaireResults = DocumentHelper.createElement( elementName );
//        Element newQuestionnaireResult = DocumentHelper.createElement( "calendarEvent" );
//
//        Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", recordIdentifier );
//        newQuestionnaireResult.add( newRecordIdentifier );
//
//        newQuestionnaireResult.addElement( "recordStatus" ).addText( recordStatus );
//        newQuestionnaireResults.add( newQuestionnaireResult );
//
//        return newQuestionnaireResults;
//    }


    public Element makeQuestionnaireResult( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        Element newQuestionnaireResults = DocumentHelper.createElement( "questionnaireResults" );
        List<Element> questionnaireResultList = makeQuestionnaireResults( countObservations, patientIdentifier, updateRecordXml );
        for ( Element questionnaireResult : questionnaireResultList )
        {
            newQuestionnaireResults.add( questionnaireResult );
        }

        return newQuestionnaireResults;
    }


    @Override
    public String fillPrintBuffer( Object aObject )
    {
        // TODO Auto-generated method stub
        return null;
    }


}
