

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.List;


//wrappper for VdmAllergyAssessmentBuilder
public class AllergyAssessmentBuilderFactory
    implements
        ClinicalDomainBuilderFactoryInterface
{
    private AllergyAssessmentBuilder allergyAssessmentBuilder = null;


    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        // call the appropriate builder and set the clinicaldata.patient.domain with it
        buildAllergyAssessmentData( clinicalData, cnt, patientIdentifier );
    }


    private void buildAllergyAssessmentData( Document clinicalData, int count, Element patientIdentifier )
    {
        Element rootElement = clinicalData.getRootElement();

        Element patient = rootElement.element( "patient" );
        
        Element templateId = rootElement.element( "templateId" );
        if(templateId.getText().equals( "AllergyAssessmentCreateOrUpdate40060" ))
        {
            Element requestedNationalId = DocumentHelper.createElement( "requestedNationalId" );
            requestedNationalId.addText("1111111111");
            patient.add( requestedNationalId );
        }
        
        List<Element> allergyAssessments = allergyAssessmentBuilder.makeAllergyAssessments( count, patientIdentifier );

        for ( Element allergyAssessment : allergyAssessments )
        {
            patient.add( allergyAssessment );
        }
    }


    public void setAllergyAssessmentBuilder( AllergyAssessmentBuilder allergyAssessmentBuilder )
    {
        this.allergyAssessmentBuilder = allergyAssessmentBuilder;
    }
}
