

package gov.va.med.tfs.client;


import gov.va.med.cds.registry.JAXRUtility;
import gov.va.med.cds.util.EndpointResolver;
import gov.va.med.tfs.client.webservice.TemplateFilterServiceInterface;
import gov.va.med.tfs.client.webservice.WTFServiceLocator;
import gov.va.med.tfs.exception.WtfServiceCreateException;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Service;


public class TfsServiceFactory
{
    private String serviceBindingId = null;

    private JAXRUtility jaxrHelper = null;

    private EndpointResolver endpointResolver = null;


    public synchronized TemplateFilterServiceInterface create( Integer tfsWebserviceTimeoutSecs )
    {
        try
        {

            return getBusinessDelegate( tfsWebserviceTimeoutSecs );
        }
        catch ( Exception ex )
        {
            throw new WtfServiceCreateException( "Could not create TAFS web service client.", ex );
        }
    }


    private TemplateFilterServiceInterface getBusinessDelegate( Integer tfsWebserviceTimeoutSecs )
        throws Exception
    {
        try
        {
            URL endpoint = new URL( endpointResolver.resolve( serviceBindingId ) );

            String endPointAsString = endpoint.toString();

            if ( null != endPointAsString && !endPointAsString.contains( "?" ) )
            {
                try
                {
                    endpoint = new java.net.URL( endPointAsString + "?wsdl" );

                }
                catch ( MalformedURLException e )
                {
                    throw new Exception( e );
                }
            }

            WTFServiceLocator wtfWsLocator = new WTFServiceLocator( endpoint );

            TemplateFilterServiceInterface port = ( TemplateFilterServiceInterface )wtfWsLocator.getTemplateFilterServicePort();

            if ( tfsWebserviceTimeoutSecs != null )
            {
                Client client = ClientProxy.getClient( port );
                HTTPConduit http = ( HTTPConduit )client.getConduit();

                HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();

                httpClientPolicy.setConnectionTimeout( tfsWebserviceTimeoutSecs );
                httpClientPolicy.setAllowChunking( false );
                httpClientPolicy.setReceiveTimeout( tfsWebserviceTimeoutSecs );

                http.setClient( httpClientPolicy );

            }

            return port;

        }
        catch ( Exception e )
        {
            throw new Exception( "Error finding service in registry.", e );
        }
    }


    public void setEndpointResolver( EndpointResolver endpointResolver )
    {
        this.endpointResolver = endpointResolver;
    }


    public void setServiceBindingId( String serviceBindingId )
    {
        this.serviceBindingId = serviceBindingId;
    }


    public void setJaxrHelper( JAXRUtility jaxrHelper )
    {
        this.jaxrHelper = jaxrHelper;
    }
}
