

package gov.va.med.cds.socket.server.handler;


import static org.junit.Assert.assertEquals;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.StreamUtil;
import gov.va.med.mediator.client.messagemediator.JmsMessageMediatorDelegate;

import java.io.IOException;

import junit.framework.Assert;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.FileSystemResource;


@RunWith( SuiteAwareRunner.class )
public class SimpleVistACommitAckResponseGeneratorTest
{

    private static final String MOCK_RESPONSE_MSG_CONTROL_ID = "1234567-888";
    private static final String MOCK_TIME = "20091110134425.662-0700";


    @Test
    @Suite( groups = "checkintest" )
    public void testCreateAckResponce_Success( )
        throws IOException
    {
        SimpleVistACommitAckResponseGenerator ackResponseGenerator = new SimpleVistACommitAckResponseGenerator()
        {
//            @Override
//            String createMessageControlId( )
//            {
//                return MOCK_RESPONSE_MSG_CONTROL_ID;
//            }


            @Override
            String createMessageDateTime( )
            {
                return MOCK_TIME;
            }
        };

        String hl7Request = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hdrlab_cds_data.rpc" ) );
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );
        String response = "SUCCESS";
        String responce = ackResponseGenerator.createResponse( hl7Support, response, MOCK_RESPONSE_MSG_CONTROL_ID, null );
        String expected = "MSH^~|\\&^LA7HDR^200HD~HDR.MED.DNS   ~DNS^LA7LAB^null~null~DNS^20091110134425.662-0700^^ACK^1234567-888^P^2.4\rMSA^CA^GENERATED-MESSAGE-CONTROL-ID^";

        assertEquals( expected, responce );
    }
    
        @Test
        @Suite(groups = "checkintest")
        public void testCreateAckResponce_Reject( ) throws IOException
        {
            
            SimpleVistACommitAckResponseGenerator ackResponseGenerator = new SimpleVistACommitAckResponseGenerator()
            {
//                @Override
//                String createMessageControlId( )
//                {
//                    return MOCK_RESPONSE_MSG_CONTROL_ID;
//                }


                @Override
                String createMessageDateTime( )
                {
                    return MOCK_TIME;
                }
            };

            // Processing error occurred, message has not been sent to mediator - mediatorResponse is null .
            String hl7Request = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hdrlab_cds_data.rpc" ) );
            HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );
            Exception validationException = new AccessValidatorException( ErrorCodeEnum.HL7_SUPPORT_HAPI_PARSE_EXCEPTION );
            String responce = ackResponseGenerator.createResponse( hl7Support,  null, MOCK_RESPONSE_MSG_CONTROL_ID, validationException );

            String expected = "MSH^~|\\&^LA7HDR^200HD~HDR.MED.DNS   ~DNS^LA7LAB^null~null~DNS^20091110134425.662-0700^^ACK^1234567-888^P^2.4\rMSA^CR^GENERATED-MESSAGE-CONTROL-ID^Error parsing message.";
            assertEquals( expected , responce );
           
        }
        
        @Test
        @Suite(groups = "checkintest")
        public void testCreateAckResponce_Error( ) throws Exception
        {
            SimpleVistACommitAckResponseGenerator ackResponseGenerator = new SimpleVistACommitAckResponseGenerator()
            {
//                @Override
//                String createMessageControlId( )
//                {
//                    return MOCK_RESPONSE_MSG_CONTROL_ID;
//                }


                @Override
                String createMessageDateTime( )
                {
                    return MOCK_TIME;
                }
            };

            // Run time error occurred while mediator processing message.
            String hl7Request = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hdrlab_cds_data.rpc" ) );
            HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );
            Exception runTimeException = new RuntimeException("Some sort of runtime exception");
            String responce = ackResponseGenerator.createResponse( hl7Support, null, MOCK_RESPONSE_MSG_CONTROL_ID, runTimeException );

            String expected = "MSH^~|\\&^LA7HDR^200HD~HDR.MED.DNS   ~DNS^LA7LAB^null~null~DNS^20091110134425.662-0700^^ACK^1234567-888^P^2.4\rMSA^CE^GENERATED-MESSAGE-CONTROL-ID^Some sort of runtime exception";
            assertEquals( expected , responce );
             
        }
        
        @Test
        @Suite(groups = "checkintest")
        public void testStripErrorSection( ) {
            SimpleVistACommitAckResponseGenerator ackResponseGenerator = new SimpleVistACommitAckResponseGenerator();
            String error = "Destination ClinicalModule!LabQueue is paused for new message production; nested exception is weblogic.jms.common.IllegalStateException: Destination ClinicalModule!LabQueue is paused for new message production";
            String response = "<"+ JmsMessageMediatorDelegate.ERROR_SECTION + ">"+ error + "</"+ JmsMessageMediatorDelegate.ERROR_SECTION + ">" ;
            String expected = "Destination ClinicalModule!LabQueue is paused for new message production; nested";
            Assert.assertEquals( expected, ackResponseGenerator.stripErrorSection( response ));
        }

}
