

package gov.va.med.cds.socket.server;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

import javax.annotation.Resource;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/socket/server/socketAdapterServerManagerContext.xml" } )
public class MinaServerManagerTest
    extends
        AbstractBaseTest
{
    private static Log LOGGER = LogFactory.getLog( MinaServerManagerTest.class );

    private static final String PORT = "5001";

    private MinaServerManager minaServerManager;

    @Resource
    public void setMinaServerManager( MinaServerManager minaServerManager )
    {
        this.minaServerManager = minaServerManager;
    }


    @SuppressWarnings( "static-access" )
    @Test
    @Suite( groups = "checkintest", order = 1 )
    public void testServerManagerEchoHello( )
        throws InterruptedException
    {

        MultiThreadedClientConnector multiThreadedClientConnector = new MultiThreadedClientConnector();

        try
        {
        	multiThreadedClientConnector.start();	
            //minaServerManager.init();
        }
        catch ( Exception ioe )
        {
            Assert.fail();
        }

        int taskCount = 200;

        ThreadPoolExecutor executorService = ( ThreadPoolExecutor )Executors.newFixedThreadPool( taskCount );

        executorService.prestartAllCoreThreads();

        for ( int i = 0; i < taskCount; i++ )
        {
            executorService.execute( multiThreadedClientConnector );
        }

        while ( executorService.getCompletedTaskCount() < taskCount )
        {
            // Wait for all tasks to complete.
            LOGGER.debug( "Waiting to complete" );
        }

    }


    //@Test
    @Suite( groups = "checkintest", order = 2 )
    public void testServerManagerStopServersTest( )
        throws Exception
    {
        minaServerManager.stopServers();
    }

}
