

package gov.va.med.cds.ejb;


import gov.va.med.mediator.client.messagemediator.MessageMediatorInterface;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

@WebService(serviceName="MessageMediatorServiceInterface", 
            targetNamespace="http://messagemediator.client.mediator.med.DNS   ", 
            portName="MessageMediatorInterfaceHttpPort",
            endpointInterface = "gov.va.med.mediator.client.messagemediator.MessageMediatorInterface")
@Stateless(name="SynchronousMessageBean", mappedName="ejb/remote/gov/va/med/cds/messagemediator/SynchronousMessageBean")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class SynchronousMessageBean implements MessageMediatorInterface
{

	protected final Log logger = LogFactory.getLog(getClass());
	
	@Autowired
    private MessageMediatorInterface messageMediator;
    
 
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#isAlive()
     */
    @WebMethod(operationName="isAlive")
    public @WebResult(name="out")boolean isAlive( )
    {
        return messageMediator.isAlive();
    }


    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#processMessage(java.lang.String)
     */
    @WebMethod(operationName="processMessage")
    public @WebResult(name="out")String processMessage( @WebParam(name="in0")String hl7MessageRequest )
    {
        return messageMediator.processMessage( hl7MessageRequest );
    }
    
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#processMessage(java.lang.String, java.lang.Boolean)
     */
    @WebMethod(operationName="processMessage1")
    public @WebResult(name="out")String processMessage( @WebParam(name="in0")String hl7MessageRequest, @WebParam(name="in1")Boolean persistOriginalMessage )
    {
        return messageMediator.processMessage( hl7MessageRequest, persistOriginalMessage );
    }

}
