

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.mediator.MessageProcessorInterface;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import java.io.IOException;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.FileSystemResource;
import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:config/test-message-mediator-context.xml",
                "classpath:config/exception-message-mediator-workflow-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class ResponseExceptionWorkFlowTest
    extends
        AbstractBaseTest
{

    private static Log logger = LogFactory.getLog( ResponseExceptionWorkFlowTest.class );

    private MessageProcessorInterface workFlow;
    private static WorkStateInterface workState = new MapBackedWorkState();


    /*
    @BeforeTestsOnce
    public void beforeResponseExceptionWorkFlowTestSetUp( )
        throws Exception
    {
        setupWorkState();
    }
    */


    private void setupWorkState( )
        throws IOException
    {
        String request = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/er7-read-requests/rdi-allergies.txt" ) );

        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( request );
        workState.registerWorkState( "HL7-SUPPORT", hl7Support );
        workState.registerWorkState( "SENDING-APPLICATION", "/MSH-3" );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testProcessorExpectedErrorMessage( )
        throws IOException
    {
        setupWorkState();
        /* At check-in time June 23 (for deadline) this test is inadequate in that
         * it is only testing a small percentage of possible mediator error scenarios
         * each worker will most likely need a separate test.
         * Testing comprehensively as this test attempted to do using a combination
         * of configuration and EasyMocks doesn't seem reasonable or possible.
         * Test should be revisited and expanded as time allows.
         */
        String request = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/er7-read-requests/rdi-allergies.txt" ) );
        String result = workFlow.processMessage( request, false );

        logger.info( result );
        //because of the test configuration there will be runtime workstate exceptions that
        //prohibit processing - the only thing we can send back is an Error String of some type
        //presently it contains text including - C A T A S T R O P H I C
        Assert.assertTrue( result.contains( "CATASTROPHIC" ) );
    }


    @Resource
    public void setWorkFlow( MessageProcessorInterface workFlow )
    {
        this.workFlow = workFlow;
    }
}
