

package gov.va.med.cds.hapi;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.FileSystemResource;
import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:config/test-message-mediator-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class HL7SupportNonHapiTest
    extends
        AbstractBaseTest
{
    private static Log logger = LogFactory.getLog( HL7SupportNonHapiTest.class );


    @Test
    @Suite( groups = { "checkintest" } )
    public void testParseEr7Message( )
        throws IOException
    {
        String request = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/er7-read-requests/chdr-allergies.txt" ) );
        HL7SupportInterface hl7Support = new Hl7SupportHdrLegacy( request );
        List exceptionList = new LinkedList<Exception>();
        exceptionList.add( new Exception( "Test Exception 1" ) );
        exceptionList.add( new Exception( "Test Exception 2" ) );
        String vhimResponse = "SUCCESS";
        logger.debug( hl7Support.getApplicationAcknowledgement( exceptionList, vhimResponse, null ) );

    }

}
