<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:saxon="http://saxon.sf.net/"
	exclude-result-prefixes="fn xs xsi xsl saxon"
	xmlns:clinicaldata="Clinicaldata" xmlns="urn:hl7-org:v2xml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" />
	
	<xsl:param name="global.hl7Support"/>
	<xsl:param name="global.workState"/>
	<xsl:param name="global.hl7Utility"/>
	
	
	<xsl:template match="/clinicaldata:ClinicalData">
		<xsl:variable name="messageDateTime" as="xs:string" 
					select="saxon:create-message-datetime($global.hl7Support)" />
		<QRY_Q01>
			<xsl:call-template name="getBHS" >
				<xsl:with-param name="messageDateTime" select="$messageDateTime"/>
			</xsl:call-template>
			<xsl:call-template name="getERR" />
			<xsl:call-template name="getQPD" >
				<xsl:with-param name="messageDateTime" select="$messageDateTime"/>
			</xsl:call-template>
			<xsl:call-template name="getRCP" />
			<xsl:for-each select="patient">
				<xsl:call-template name="getORU" />
			</xsl:for-each>
			<xsl:call-template name="getBTS" />
		</QRY_Q01>
	</xsl:template>
	
	<xsl:template name="getBHS">
		<xsl:param name="messageDateTime"/>
		<BHS>
			<BHS.1>|</BHS.1>
			<BHS.2>^~\&amp;</BHS.2>
			<BHS.3>VHA_HDR</BHS.3>
			<BHS.4>HDR</BHS.4>
			<BHS.5>CHDR SENDER</BHS.5>
			<BHS.6>CHDR</BHS.6>
			<BHS.7>
				<TS.1><xsl:value-of select="$messageDateTime"/></TS.1>
			</BHS.7>
			<BHS.9><xsl:text>RSP*Z98*QRY_Q01</xsl:text></BHS.9>
		</BHS>
	</xsl:template>
	<xsl:template name="getERR">
		<ERR>
			<xsl:if test="saxon:get-exception-count($global.workState) > 0">
				<ERR.1>
					<ELD.4>
						<CE.1>
							<xsl:text>MEDIATOR-ERROR</xsl:text>
						</CE.1>
						<CE.2>
							<xsl:value-of select="saxon:get-formatted-exception-detail($global.workState)" />
						</CE.2>
						<CE.3>
							<xsl:text>NA</xsl:text>
						</CE.3>
					</ELD.4>
				</ERR.1>
			</xsl:if>
			<xsl:for-each select="errorSection/fatalErrors">
				<ERR.1>
					<ELD.4>
						<CE.1>
							<xsl:value-of select="errorId" />
						</CE.1>
						<CE.2>
							<xsl:value-of select="displayMessage" />
						</CE.2>
						<CE.3>
							<xsl:value-of select="errorCode" />
						</CE.3>
					</ELD.4>
				</ERR.1>
			</xsl:for-each>
			<xsl:for-each select="errorSection/warnings">
				<xsl:if test="(errorCode='READ_REQUEST_DATA_SOURCE_FAILURE') or (errorCode='READ_REQUEST_DATA_SOURCE_ALL_EXCEPTIONS')">
					<ERR.1>
						<ELD.4>
							<CE.1>
								<xsl:value-of select="errorId" />
							</CE.1>
							<CE.2>
								<xsl:value-of select="displayMessage" />
							</CE.2>
							<CE.3>
								<xsl:value-of select="errorCode" />
							</CE.3>
						</ELD.4>
					</ERR.1>
				</xsl:if>
			</xsl:for-each>
		</ERR>
	</xsl:template>
	<xsl:template name="getQPD">
		<xsl:param name="messageDateTime" />
		<QPD>
			<QPD.1>
				<CE.1>OC_CHDR</CE.1>
			</QPD.1>
			<QPD.3>
				<xsl:value-of select="patient/requestedNationalId"/>
			</QPD.3>
			<QPD.4>CHDR_LAB</QPD.4>
			<!-- <QPD.5><xsl:value-of select="saxon:get-message-data($global.hl7Support, '/QPD-5')"/></QPD.5>
			<QPD.6><xsl:value-of select="saxon:get-message-data($global.hl7Support, '/QPD-6')"/></QPD.6> -->
		</QPD>
	</xsl:template>
	<xsl:template name="getRCP">
		<RCP>
			<RCP.1>I</RCP.1>
			<RCP.2>
				<CQ.1>100</CQ.1>
				<CQ.2>
					<CE.1>RD</CE.1>
				</CQ.2>
			</RCP.2>
			<RCP.3>
				<CE.1>B</CE.1>
			</RCP.3>
			<RCP.4>
				<TS.1></TS.1>
			</RCP.4>
		</RCP>
	</xsl:template>
	
	<!-- start main structure of Lab message -->
	<!--  #########################
			getORU
			applies to the entire LAB Message
	-->
	<xsl:template name="getORU">
		<xsl:variable name="labSendingApp">LA7LAB</xsl:variable>
		<ORU_R01>
			<xsl:call-template name="getMSH">
				<xsl:with-param name="sendingApp" select="$labSendingApp"/>
			</xsl:call-template>
			<ORU_R01.PATIENT_RESULT>
				<ORU_R01.PATIENT>
					<xsl:call-template name="getPID"/>
					<PD1/>
					<NK1/>
					<NTE/>
					<ORU_R01.VISIT>
						<xsl:call-template name="getPV1"/>
						<PV2/>
					</ORU_R01.VISIT>
				</ORU_R01.PATIENT>
				<xsl:for-each select="labTestPromises">
					<xsl:for-each select="labTests">
						<ORU_R01.ORDER_OBSERVATION>
							<xsl:call-template name="getORC" />
							<xsl:call-template name="getOBR" />
							<xsl:for-each select="../labCommentEvents">
								<xsl:call-template name="getNTE" />
							</xsl:for-each>
							<CTD/>
							<xsl:for-each select="chemistryResults">
								<ORU_R01.OBSERVATION>
									<xsl:call-template name="getOBX" />
									<xsl:for-each select="labCommentEvents">
										<xsl:call-template name="getNTE" />
									</xsl:for-each>
								</ORU_R01.OBSERVATION>
							</xsl:for-each>
							<FT1/>
							<CT1/>
						</ORU_R01.ORDER_OBSERVATION>
					</xsl:for-each>
				</xsl:for-each>
			</ORU_R01.PATIENT_RESULT>
		</ORU_R01>
	</xsl:template>
	
	<!--###########################
		getORC
		applies to the entire ORC Segment
	-->
	<xsl:template name="getORC">
		<ORC>
			<ORC.1>RE</ORC.1>
			<ORC.2>				
				<xsl:call-template name="getEntityIdentifier">
					<xsl:with-param name="theEntity" select="../placerOrderIdentifier" />
				</xsl:call-template>
			</ORC.2>
			<ORC.3>				
				<xsl:call-template name="getEntityIdentifier">
					<xsl:with-param name="theEntity" select="../recordIdentifier" />
				</xsl:call-template>
			</ORC.3>
			<ORC.12>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver" select="../labTestRequest/author" />
				</xsl:call-template>
			</ORC.12>
			<ORC.13>
				<xsl:call-template name="getLocationIdentifier">
					<xsl:with-param name="theLocation" select="../labTestRequest/requestingLocationIdentifier"/>
				</xsl:call-template>
			</ORC.13>
			<ORC.17>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement" select="../labTestRequest/requestingOrganization"/>
				</xsl:call-template>
			</ORC.17>
			<ORC.21>
				<xsl:call-template name="getOrganizationIdentifier">
					<xsl:with-param name="theOrganization" select="../labTestRequest/orderingFacilityIdentifier"/>
				</xsl:call-template>
			</ORC.21>
			<ORC.22>
				<xsl:call-template name="getAddress">
					<xsl:with-param name="theAddress" select="../labTestRequest/orderingFacilityAddress"/>
				</xsl:call-template>
			</ORC.22>
		</ORC>
	</xsl:template>
	
	<!--##########################
		getOBR
		applies to the entire OBR Segment
	-->
	<xsl:template name="getOBR">
		<OBR>
			<OBR.1>1</OBR.1>
			<OBR.2>				
				<xsl:call-template name="getEntityIdentifier">
					<xsl:with-param name="theEntity" select="../recordIdentifier" />
				</xsl:call-template>
			</OBR.2>
			<OBR.3>				
				<xsl:call-template name="getEntityIdentifier">
					<xsl:with-param name="theEntity" select="../recordIdentifier" />
				</xsl:call-template>
			</OBR.3>
			<OBR.4>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement" select="orderedTestCode"/>
				</xsl:call-template>
				<xsl:call-template name="getCodedElementAlternate">
					<xsl:with-param name="theElement"	select="orderedTestCode" />
				</xsl:call-template>
			</OBR.4>
			<OBR.7>
				<TS.1>
					<xsl:value-of select="../specimen/specimenTakenDate/literal" />
				</TS.1>
			</OBR.7>
			<OBR.14>
				<TS.1>
					<xsl:value-of select="../specimen/specimenReceivedDate/literal" />
				</TS.1>
			</OBR.14>
			<OBR.15>
				<SPS.1>
					<xsl:call-template name="getCodedElementCWE">
						<xsl:with-param name="theElement" select="../specimen/specimenSource"/>
					</xsl:call-template>
				</SPS.1>
			</OBR.15>
			<OBR.16>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver" select="../labTestRequest/author" />
				</xsl:call-template>
			</OBR.16>
			<OBR.19>
				<xsl:value-of select="../placerAccessionReference" />
			</OBR.19>
			<OBR.20>
				<xsl:value-of select="../fillerIenReference" />
			</OBR.20>
			<OBR.21>
				<xsl:value-of select="fillerAccessionReference" />
			</OBR.21>
			<OBR.22>
				<TS.1>
					<xsl:value-of select="../reportCompleteDate/literal" />
				</TS.1>
			</OBR.22>
			<OBR.24>
				<xsl:value-of select="../labSubscript" />
			</OBR.24>
			<OBR.25>
				<xsl:value-of select="../status" />
			</OBR.25>
			<OBR.44>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"	select="procedureCode" />
				</xsl:call-template>
				<xsl:call-template name="getCodedElementAlternate">
					<xsl:with-param name="theElement"	select="procedureCode" />
				</xsl:call-template>
			</OBR.44>
		</OBR>
	</xsl:template>
	
	<!--###########################
		getOBX
		applies to the entire OBX Segment
	-->
	<xsl:template name="getOBX">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2><xsl:value-of select="observationValueType" /></OBX.2>
			<OBX.3>
				<xsl:call-template name="getCodedElementCNE">
					<xsl:with-param name="theElement"	select="testIdentifier" />
				</xsl:call-template>
			</OBX.3>
			<OBX.4></OBX.4>
			<OBX.5>
				<xsl:value-of select="observationValue" />
			</OBX.5>
			<OBX.6>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement" select="observationUnits"/>
				</xsl:call-template>
			</OBX.6>
			<OBX.7>
				<xsl:value-of select="referenceRange" />
			</OBX.7>
			<OBX.8>
				<xsl:value-of select="valueInterpretation" />
			</OBX.8>
			<OBX.11>
				<xsl:value-of select="observationStatus" />
			</OBX.11>
			<OBX.14>
				<TS.1>
					<xsl:value-of select="observationDate/literal" />
				</TS.1>
			</OBX.14>
			<OBX.15>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"	select="producerCode" />
				</xsl:call-template>
				<xsl:call-template name="getCodedElementAlternate">
					<xsl:with-param name="theElement"	select="producerCode" />
				</xsl:call-template>
			</OBX.15>
			<OBX.16>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver" select="verifier" />
				</xsl:call-template>
			</OBX.16>
			<xsl:for-each select="observationMethods">
				<OBX.17>
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement"	select="observationMethodCode" />
					</xsl:call-template>
					<xsl:call-template name="getCodedElementAlternate">
						<xsl:with-param name="theElement"	select="observationMethodCode" />
					</xsl:call-template>
				</OBX.17>
			</xsl:for-each>
			<OBX.18>
				<xsl:call-template name="getEntityIdentifier">
					<xsl:with-param name="theEntity" select="deviceIdentifier" />
				</xsl:call-template>
			</OBX.18>
			<OBX.19>
				<TS.1>
					<xsl:value-of select="analysisDate/literal" />
				</TS.1>
			</OBX.19>
			<OBX.23>
				<xsl:call-template name="getOrganizationIdentifier">
					<xsl:with-param name="theOrganization" select="performingOrganization/identifier"/>
				</xsl:call-template>
			</OBX.23>
			<OBX.24>
				<xsl:call-template name="getAddress">
					<xsl:with-param name="theAddress" select="performingOrganization/address"/>
				</xsl:call-template>
			</OBX.24>
		</OBX>
	</xsl:template>

	<!--##########################
		getNTE
		applies to the entire NTE Segment
	-->
	<xsl:template name="getNTE">
		<NTE>
			<NTE.1>1</NTE.1>
			<NTE.2>L</NTE.2>
			<xsl:for-each select="comments">				
				<NTE.3>				
					<xsl:value-of select="." />
				</NTE.3>
			</xsl:for-each>
			<NTE.4>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement" select="commentTypeCode"/>
				</xsl:call-template>
			</NTE.4>
		</NTE>
	</xsl:template>	

<!--###########################
		getPV1
		applies to the entire PV1 Segment
	-->
	<xsl:template name="getPV1">
		<PV1>
			<PV1.2><xsl:value-of select="labTestPromises/patientVisit/patientClass" /></PV1.2>
			<PV1.3>
				<xsl:call-template name="getLocationIdentifier">
					<xsl:with-param name="theLocation" select="labTestPromises/patientVisit/assignedLocation"/>
				</xsl:call-template>
			</PV1.3>
			<PV1.6>
				<xsl:call-template name="getLocationIdentifier">
					<xsl:with-param name="theLocation" select="labTestPromises/patientVisit/priorLocation"/>
				</xsl:call-template>
			</PV1.6>
			<PV1.7>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver" select="labTestPromises/patientVisit/attendingDoctor"/>
				</xsl:call-template>
			</PV1.7>
			<PV1.10><xsl:value-of select="labTestPromises/patientVisit/hospitalService" /></PV1.10>
			<PV1.18><xsl:value-of select="labTestPromises/patientVisit/patientType" /></PV1.18>
			<PV1.21><xsl:value-of select="labTestPromises/patientVisit/chargePriceIndicator" /></PV1.21>
			<PV1.36><xsl:value-of select="labTestPromises/patientVisit/dischargeDisposition" /></PV1.36>
			<PV1.39><xsl:value-of select="labTestPromises/patientVisit/servicingFacility" /></PV1.39>
			<PV1.44><TS.1><xsl:value-of select="labTestPromises/patientVisit/admissionDate/literal" /></TS.1></PV1.44>
			<PV1.50><CX.1><xsl:value-of select="labTestPromises/patientVisit/alternateVisitId" /></CX.1></PV1.50>
		</PV1>
	</xsl:template>	
	
	<!--
		##########################
		### COMMON TEMPLATES ###
		##########################
	-->
	<!--#########################
		getMSH
		applies to the entire MSH Segment
	-->
	<xsl:template name="getMSH">
		<xsl:param name="sendingApp"/>
		<MSH>
			<MSH.1>|</MSH.1>
			<MSH.2>^~\&amp;</MSH.2>
			<MSH.3>
				<HD.1><xsl:value-of select="$sendingApp" /></HD.1>
			</MSH.3>
			<MSH.4>
				<xsl:variable name="assigningFacility" select="patient/identifier/assigningFacility"/>
				<HD.1><xsl:value-of select="$assigningFacility" /></HD.1>
				<!-- <HD.2><xsl:value-of select="saxon:get-sendingfacility($global.hl7Utility, $assigningFacility)"/></HD.2> -->
				<HD.3>DNS</HD.3>
			</MSH.4>
			<MSH.5>
				<HD.1>LA7HDR</HD.1>
			</MSH.5>
			<MSH.6>
				<HD.1>200HD</HD.1>
				<HD.2>HDR.MED.DNS   </HD.2>
				<HD.3>DNS</HD.3>
			</MSH.6>
			<MSH.7>
				<TS.1>
					<xsl:value-of select="recordUpdateTime/literal" />
				</TS.1>
			</MSH.7>
			<MSH.9>
				<MSG.1>ORU</MSG.1>
				<MSG.2>R01</MSG.2>
				<MSG.3>ORU_R01</MSG.3>
			</MSH.9>
			<MSH.10><xsl:value-of select="saxon:create-message-controlid($global.hl7Support)" /></MSH.10>
			<MSH.11>
				<PT.1>P</PT.1>
			</MSH.11>
			<MSH.12>
				<VID.1>2.4</VID.1>
			</MSH.12>
			<MSH.15>NE</MSH.15>
			<MSH.16>NE</MSH.16>
			<MSH.17>USA</MSH.17>
		</MSH>
	</xsl:template>

	<!--#######################################
		getPID
		applies to the entire PID Segment
	-->
	<xsl:template name="getPID">
		<PID>
			<PID.1>1</PID.1>
			<xsl:variable name="icn" select="/clinicaldata:ClinicalData/patient/requestedNationalId"/>
			<PID.2>
				<CX.1>
					<xsl:value-of select="saxon:add-checksum($icn)"/>
				</CX.1>
			</PID.2>
			<PID.3>
				<CX.1>
					<xsl:value-of select="saxon:add-checksum($icn)"/>
				</CX.1>
				<CX.4>
					<HD.1>USVHA</HD.1>
					<HD.3>0363</HD.3>
				</CX.4>
				<CX.5>NI</CX.5>
				<CX.6>
					<HD.1>VA FACILITY ID</HD.1>
					<HD.2>
						<xsl:value-of
							select="patient/identifier/assigningFacility" />
					</HD.2>
					<HD.3>L</HD.3>
				</CX.6>
			</PID.3>
			<PID.5>
				<XPN.1>
					<FN.1>
						<xsl:value-of select="patient/name/family" />
					</FN.1>
				</XPN.1>
				<XPN.2>
					<xsl:value-of select="patient/name/given" />
				</XPN.2>
				<XPN.3>
					<xsl:value-of select="patient/name/middle" />
				</XPN.3>
				<XPN.7>U</XPN.7>
			</PID.5>
		</PID>
	</xsl:template>
	
<!--##########################
		getBTS template
		applies to BTS Segment
	-->
	<xsl:template name="getBTS">
		<BTS>
			<BTS.1>
				{FINAL_BTS_COUNT}
			</BTS.1>
		</BTS>
	</xsl:template>
		

	<!--###########################################
		getEntityIdentifier (EI)
		applies to the EI HL7 datatype
	-->
	<xsl:template name="getEntityIdentifier">
		<xsl:param name="theEntity" />
		<EI.1>
			<xsl:value-of select="$theEntity/identity" />
		</EI.1>
		<EI.2>
			<xsl:value-of select="$theEntity/namespaceId" />
		</EI.2>
		<EI.3>
			<xsl:value-of select="$theEntity/universalId" />
		</EI.3>
		<EI.4>
			<xsl:value-of select="$theEntity/universalIdType" />
		</EI.4>
	</xsl:template>
	
<!--#######################################
		getCodedElement (CE)
		applies to the CE HL7 datatype
	-->
	<xsl:template name="getCodedElement">
		<xsl:param name="theElement" />
		<CE.1>
			<xsl:value-of select="$theElement/code" />
		</CE.1>
		<CE.2>
			<xsl:value-of select="$theElement/displayText" />
		</CE.2>
		<CE.3>
			<xsl:value-of select="$theElement/codingSystem" />
		</CE.3>
	</xsl:template>
	
	<!--#######################################
		getCodedElementAlternate (CE - alternate values)
		applies to the CE HL7 datatype
	-->
	<xsl:template name="getCodedElementAlternate">
		<xsl:param name="theElement" />
		<CE.4>
			<xsl:value-of select="$theElement/alternateCode" />
		</CE.4>
		<CE.5>
			<xsl:value-of select="$theElement/alternateDisplayText" />
		</CE.5>
		<CE.6>
			<xsl:value-of select="$theElement/alternateCodingSystem" />
		</CE.6>
	</xsl:template>

	<!--##############################
		getCodedElementCWE template 
		applies to CWE HL7 datatypes
	-->
	<xsl:template name="getCodedElementCWE">
		<xsl:param name="theElement"/>
		<CWE.1>
			<xsl:value-of select="$theElement/code"/>
		</CWE.1>
		<CWE.2>
			<xsl:value-of select="$theElement/displayText"/>
		</CWE.2>
		<CWE.3>
			<xsl:value-of select="$theElement/codingSystem"/>
		</CWE.3>
		<CWE.4>
			<xsl:value-of select="$theElement/alternateCode"/>
		</CWE.4>
		<CWE.5>
			<xsl:value-of select="$theElement/alternateDisplayText"/>
		</CWE.5>
		<CWE.6>
			<xsl:value-of select="$theElement/alternateCodingSystem"/>
		</CWE.6>
		<CWE.7>
			<xsl:value-of select="$theElement/codingSystemVersion"/>
		</CWE.7>
		<CWE.8>
			<xsl:value-of select="$theElement/alternateCodingSystemVersion"/>
		</CWE.8>
		<CWE.9>
			<xsl:value-of select="$theElement/originalText"/>
		</CWE.9>
	</xsl:template>

	<!--##############################
		getCodedElementCNE template 
		applies to CNE HL7 datatypes
	-->
	<xsl:template name="getCodedElementCNE">
		<xsl:param name="theElement"/>
		<CNE.1>
			<xsl:value-of select="$theElement/code"/>
		</CNE.1>
		<CNE.2>
			<xsl:value-of select="$theElement/displayText"/>
		</CNE.2>
		<CNE.3>
			<xsl:value-of select="$theElement/codingSystem"/>
		</CNE.3>
		<CNE.4>
			<xsl:value-of select="$theElement/alternateCode"/>
		</CNE.4>
		<CNE.5>
			<xsl:value-of select="$theElement/alternateDisplayText"/>
		</CNE.5>
		<CNE.6>
			<xsl:value-of select="$theElement/alternateCodingSystem"/>
		</CNE.6>
		<CNE.7>
			<xsl:value-of select="$theElement/codingSystemVersion"/>
		</CNE.7>
		<CNE.8>
			<xsl:value-of select="$theElement/alternateCodingSystemVersion"/>
		</CNE.8>
		<CNE.9>
			<xsl:value-of select="$theElement/originalText"/>
		</CNE.9>
	</xsl:template>

	<!--#######################################
		getObservingPractitioner (CM_NDL) - *HAPI sees this as NDL
		applies to the CM_NDL HL7 datatype
	-->
	<xsl:template name="getObservingPractitioner">
		<xsl:param name="thePractitioner" />
		<xsl:param name="theTime" />
		<xsl:param name="theSource"/>
		<NDL.1>
			<CNN.1>
				<xsl:value-of select="$thePractitioner/identifier/identity" />
			</CNN.1>
			<CNN.2>
				<xsl:value-of select="$thePractitioner/name/family" />
			</CNN.2>
			<CNN.3>
				<xsl:value-of select="$thePractitioner/name/given" />
			</CNN.3>
			<CNN.4>
				<xsl:value-of select="$thePractitioner/name/middle" />
			</CNN.4>
			<CNN.5>
				<xsl:value-of select="$thePractitioner/name/suffix" />
			</CNN.5>
			<CNN.6>
				<xsl:value-of select="$thePractitioner/name/prefix" />
			</CNN.6>
			<CNN.7>
				<xsl:value-of select="$thePractitioner/name/title" />
			</CNN.7>
			<CNN.8>
				<xsl:value-of select="$theSource"/>
			</CNN.8>
		</NDL.1>
		<xsl:if test="$theTime != ''">
			<NDL.2>
				<TS.1>
					<xsl:value-of select="$theTime" />
				</TS.1>
			</NDL.2>
		</xsl:if>
	</xsl:template>

	<!--#############################
		getResponsibleObserver (XCN)
		applies to the XCN HL7 datatype
	-->
	<xsl:template name="getResponsibleObserver">
		<xsl:param name="theObserver" />
		<XCN.1>
			<xsl:value-of select="$theObserver/identifier/identity" />
		</XCN.1>
		<XCN.2>
			<FN.1>
				<xsl:value-of select="$theObserver/name/family" />
			</FN.1>
		</XCN.2>
		<XCN.3>
			<xsl:value-of select="$theObserver/name/given" />
		</XCN.3>
		<XCN.4>
			<xsl:value-of select="$theObserver/name/middle" />
		</XCN.4>
		<XCN.5>
			<xsl:value-of select="$theObserver/name/suffix" />
		</XCN.5>
		<XCN.6>
			<xsl:value-of select="$theObserver/name/prefix" />
		</XCN.6>
		<XCN.7>
			<xsl:value-of select="$theObserver/name/title" />
		</XCN.7>
		<XCN.8>
			<xsl:value-of select="$theObserver/idSourceTable" />
		</XCN.8>
	</xsl:template>
	
	<!--############################
		getLocationIdentifier template (PL)
		applies to PL HL7 datatype
	-->
	<xsl:template name="getLocationIdentifier">
		<xsl:param name="theLocation" />
		<PL.1>
			<xsl:value-of select="$theLocation/pointOfCare" />
		</PL.1>
		<PL.4>
			<HD.1>
			<xsl:value-of select="$theLocation/facilityNamespaceId" />
			</HD.1>
			<HD.2>
			<xsl:value-of select="$theLocation/facilityUniversalId" />
			</HD.2>
			<HD.3>
			<xsl:value-of select="$theLocation/facilityUniversalIdType" />
			</HD.3>
		</PL.4>
		<PL.6>
			<xsl:value-of select="$theLocation/personLocationType" />
		</PL.6>
	</xsl:template>
	
	<!--#################################
		getOrganizationIdentifier template (XON)
		applies to XON HL7 datatype
	-->
	<xsl:template name="getOrganizationIdentifier">
		<xsl:param name="theOrganization" />
		<XON.1>
			<xsl:value-of select="$theOrganization/name"/>
		</XON.1>
		<XON.2>
			<xsl:value-of select="$theOrganization/nameTypeCode"/>
		</XON.2>
		<XON.3>
			<xsl:value-of select="$theOrganization/stationNumber"/>
		</XON.3>
		<XON.6>
			<HD.1>
				<xsl:value-of select="$theOrganization/assigningAuthority"/>
			</HD.1>
		</XON.6>
		<XON.7>
			<xsl:value-of select="$theOrganization/identityTypeCode"/>
		</XON.7>
		<XON.9>
			<xsl:value-of select="$theOrganization/nameRepresentation"/>
		</XON.9>
		<XON.10>
			<xsl:value-of select="$theOrganization/identity"/>
		</XON.10>
	</xsl:template>
	
	<!--##########################
		getAddress template (XAD)
		applies to XAD HL7 datatype
	-->
	<xsl:template name="getAddress">
		<xsl:param name="theAddress" />
		<XAD.1>
			<SAD.1>
				<xsl:value-of select="$theAddress/line1"/>
			</SAD.1>
		</XAD.1>
		<XAD.3>
			<xsl:value-of select="$theAddress/city"/>
		</XAD.3>
		<XAD.4>
			<xsl:value-of select="$theAddress/state"/>
		</XAD.4>
		<XAD.5>
			<xsl:value-of select="$theAddress/postalCode"/>
		</XAD.5>
		<XAD.6>
			<xsl:value-of select="$theAddress/country"/>
		</XAD.6>
	</xsl:template>
	
</xsl:stylesheet>
