<?xml version="1.0" encoding="UTF-8"?>
<!-- $Author: DNS   shaha $ -->
<!-- $DateTime: 2014/10/02 14:48:57 $ -->
<!-- $File: //repositories/apps/mediator/branches/rtc/mediator/src/main/resources/xslts/vhim400/HL7ToPharmacy.xsl $ -->
<!-- $Revision: #1 $ -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:pharmacy="Pharmacy" xmlns:b="urn:hl7-org:v2xml" xmlns:common="Common" xmlns:act="Act" xmlns:participation="Participation" xmlns:person="Person" xmlns:exposure="Exposure" xmlns:vhimdatatypes="VHIMDatatypes" xmlns:entity="Entity" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<clinicaldata:ClinicalData xmlns:clinicaldata="Clinicaldata">
			<templateId>PharmacyCreateOrUpdate40060</templateId>
			<patient>
				<xsl:variable name="nationalId" select="(b:RDS_O13/b:RDS_O13.PATIENT | b:RDE_O11/b:RDE_O11.PATIENT)/b:PID/b:PID.3[b:CX.5 = 'NI'][1]/b:CX.1"/>
				<xsl:if test="string-length($nationalId) > 0">
					<requestedNationalId>
						<xsl:value-of select="$nationalId"/>
					</requestedNationalId>
				</xsl:if>
				<xsl:for-each select="(b:RDS_O13/b:RDS_O13.ORDER | b:RDE_O11/b:RDE_O11.ORDER)[b:ORC/b:ORC.1  = 'RE']">
					<outpatientMedicationPromises>
						<xsl:for-each select="b:ORC/b:ORC.3">
							<xsl:call-template name="getRecordIdentifier"/>
						</xsl:for-each>
						<xsl:for-each select="(.| b:RDE_O11.OBSERVATION)/b:OBX[b:OBX.3/b:CE.1  = 'PDTS_PRESCRIPTION_NUMBER']">
							<pdtsPrescriptionId>
								<xsl:value-of select="b:OBX.5"/>
							</pdtsPrescriptionId>
						</xsl:for-each>
						<xsl:for-each select=".">
							<prescriptionId>
								<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.15"/>
							</prescriptionId>
						</xsl:for-each>
						<pharmacyPatientType>
							<xsl:value-of select="(.| b:RDE_O11.OBSERVATION)/b:FT1[b:FT1.6='CG']/b:FT1.18"/>
						</pharmacyPatientType>
						<xsl:if test="(.| b:RDE_O11.OBSERVATION)/b:OBX/b:OBX.3[b:CE.1='CLOZAPINE DOSAGE']">
							<specialDrugTracking>
								<totalDailyDosage>
									<value>
										<xsl:value-of select="(.| b:RDE_O11.OBSERVATION)/b:OBX[b:OBX.3/b:CE.1='CLOZAPINE DOSAGE']/b:OBX.5"/>
									</value>
									<unit>
										<code>
											<xsl:value-of select="(.| b:RDE_O11.OBSERVATION)/b:OBX[b:OBX.3/b:CE.1='CLOZAPINE DOSAGE']/b:OBX.6/b:CE.1"/>
										</code>
									</unit>
								</totalDailyDosage>
								<wbcObservation>
									<count>
										<value>
											<xsl:value-of select="(.| b:RDE_O11.OBSERVATION)/b:OBX[b:OBX.3/b:CE.1='WBC RESULTS']/b:OBX.5"/>
										</value>
									</count>
									<testDate>
										<literal>
											<xsl:value-of select="(.| b:RDE_O11.OBSERVATION)/b:OBX[b:OBX.3/b:CE.1='WBC RESULTS']/b:OBX.14/b:TS.1"/>
										</literal>
									</testDate>
								</wbcObservation>
							</specialDrugTracking>
						</xsl:if>
						<dataEnterer>
							<!-- this time value is processed by the 'loginDate', removing the redundancy. Joey 07/16/2008 >
							<time>
								<literal>
									<xsl:value-of select="b:ORC/b:ORC.9/b:TS.1"/>
								</literal>
							</time -->
							<xsl:call-template name="getPractitioner">
								<xsl:with-param name="thePractitioner" select="b:ORC/b:ORC.10"/>
							</xsl:call-template>
						</dataEnterer>
						<pharmacyRequest>
							<xsl:for-each select="b:ORC/b:ORC.12[b:XCN.8 = 'COSIGNER']">
								<cosigner>
									<xsl:call-template name="getPractitioner">
										<xsl:with-param name="thePractitioner" select="."/>
									</xsl:call-template>
								</cosigner>
							</xsl:for-each>
							<orderedMedication>
								<xsl:for-each select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.31[ b:CE.3/ends-with(., '_50_27')]">
									<cmopDrugCode>
										<xsl:call-template name="getCodedElementLite">
											<xsl:with-param name="theCode" select="."/>
										</xsl:call-template>
									</cmopDrugCode>
								</xsl:for-each>
								<medicationCode>
									<xsl:call-template name="getCodedElementLite">
										<xsl:with-param name="theCode" select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.2"/>
									</xsl:call-template>
									<xsl:for-each select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.31[ b:CE.3/ends-with(., '_50_.01')]">
										<!-- cannot call getCodedElementLite for this element because the 'alternate' tags are needed -->
										<alternateCode>
											<xsl:value-of select="b:CE.1"/>
										</alternateCode>
										<alternateDisplayText>
											<xsl:value-of select="b:CE.2"/>
										</alternateDisplayText>
										<alternateCodingSystem>
											<xsl:value-of select="b:CE.3"/>
										</alternateCodingSystem>
									</xsl:for-each>
								</medicationCode>
								<xsl:for-each select="(.| b:RDE_O11.OBSERVATION)/b:OBX[b:OBX.3/b:CE.1='OTC FLAG']">
									<otcCode>
										<xsl:call-template name="getCodedElementLite">
											<xsl:with-param name="theCode" select="b:OBX.5"/>
										</xsl:call-template>
									</otcCode>
								</xsl:for-each>
								<xsl:for-each select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.31[b:CE.3/ends-with(., '_52_6.5')]">
									<tradeName>
										<xsl:call-template name="getCodedElementLite">
											<xsl:with-param name="theCode" select="."/>
										</xsl:call-template>
									</tradeName>
								</xsl:for-each>
							</orderedMedication>
							<genericRequestIdentifier>
								<identity>
									<xsl:value-of select="b:ORC/b:ORC.2/b:EI.1"/>
								</identity>
								<namespaceId>
									<xsl:value-of select="b:ORC/b:ORC.2/b:EI.2"/>
								</namespaceId>
							</genericRequestIdentifier>
							<orderLocationIdentifier>
								<pointOfCare>
									<xsl:value-of select="b:ORC/b:ORC.13/b:PL.1"/>
								</pointOfCare>
								<room>
									<xsl:value-of select="b:ORC/b:ORC.13/b:PL.2"/>
								</room>
								<bed/>
								<facilityNamespaceId/>
								<facilityUniversalId/>
								<facilityUniversalIdType/>
								<personLocationType/>
								<locationDescription/>
							</orderLocationIdentifier>
							<orderedItem>
								<itemCode>
									<xsl:call-template name="getCodedElementLite">
										<xsl:with-param name="theCode" select="(. | b:RDE_O11.OBSERVATION)/b:FT1[b:FT1.6='CG']/b:FT1.7"/>
									</xsl:call-template>
								</itemCode>
								<dosageFormCode>
									<xsl:call-template name="getCodedElementLite">
										<xsl:with-param name="theCode" select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.6"/>
									</xsl:call-template>
								</dosageFormCode>
							</orderedItem>
							<orderingInstitutionIdentifier>
								<name>
									<xsl:value-of select="b:ORC/b:ORC.21/b:XON.1"/>
								</name>
							</orderingInstitutionIdentifier>
							<xsl:for-each select="b:ORC/b:ORC.7[b:TQ.7  = 'ISSUED' ]">
								<orderDate>
									<literal>
										<xsl:value-of select="b:TQ.5/b:TS.1"/>
									</literal>
								</orderDate>
							</xsl:for-each>
							<status>
								<xsl:value-of select="b:ORC/b:ORC.5"/>
							</status>
							<statusModifier>
								<!-- cannot call getCodedElementLite for this element because it does not use a CE datatype -->
								<code>
									<xsl:value-of select="b:ORC/b:ORC.25/b:CWE.1"/>
								</code>
								<displayText>
									<xsl:value-of select="b:ORC/b:ORC.25/b:CWE.2"/>
								</displayText>
								<codingSystem>
									<xsl:value-of select="b:ORC/b:ORC.25/b:CWE.3"/>
								</codingSystem>
							</statusModifier>
						</pharmacyRequest>
						<xsl:for-each select="../(b:RDS_O13.PATIENT | b:RDE_O11.PATIENT)/b:PID/b:PID.3[b:CX.5 = 'PI']">
							<xsl:call-template name="getPatientLite"/>
						</xsl:for-each>
						<xsl:if test="(b:ORC/b:ORC.7[b:TQ.7/ends-with(., 'EXPIRATION')]/b:TQ.5/b:TS.1 != '')">
							<expirationDate>
								<literal>
									<xsl:value-of select="b:ORC/b:ORC.7[b:TQ.7/ends-with(., 'EXPIRATION')]/b:TQ.5/b:TS.1"/>
								</literal>
							</expirationDate>
						</xsl:if>
						<lastDispenseDate>
							<literal>
								<xsl:value-of select="b:ORC/b:ORC.7[b:TQ.7/ends-with(., 'LAST DISPENSED')]/b:TQ.5/b:TS.1"/>
							</literal>
						</lastDispenseDate>
						<xsl:if test="(string(number((b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.12)) != 'NaN')">
							<numberOfRefillsAuthorized>
								<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.12"/>
							</numberOfRefillsAuthorized>
						</xsl:if>
						<xsl:for-each select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.7[b:CE.3/ends-with(., '_52_114')]">
							<patientInstructions>
								<xsl:value-of select="b:CE.2"/>
							</patientInstructions>
						</xsl:for-each>
						<xsl:for-each select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.7[b:CE.3/ends-with(., '52_114.1')]">
							<otherPatientInstructions>
								<xsl:value-of select="b:CE.2"/>
							</otherPatientInstructions>
						</xsl:for-each>
						<xsl:for-each select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.7[b:CE.3/ends-with(., '_52_115')]">
							<expandedPatientInstructions>
								<xsl:value-of select="b:CE.2"/>
							</expandedPatientInstructions>
						</xsl:for-each>
						<xsl:for-each select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.21">
							<sig>
								<xsl:value-of select="b:CE.1"/>
							</sig>
						</xsl:for-each>
						<xsl:for-each select="(. | b:RDE_O11.OBSERVATION)/b:FT1[b:FT1.6 = 'CO']">
							<copayTransactionType>
								<xsl:call-template name="getCodedElementLite">
									<xsl:with-param name="theCode" select="b:FT1.7"/>
								</xsl:call-template>
							</copayTransactionType>
						</xsl:for-each>
						<xsl:for-each select="(. | b:RDE_O11.OBSERVATION)/b:OBX/b:OBX.5[b:CE.3  = '99VA_52_201']">
							<transitionalRxBenefit>
								<xsl:call-template name="getCodedElementLite">
									<xsl:with-param name="theCode" select="."/>
								</xsl:call-template>
							</transitionalRxBenefit>
						</xsl:for-each>
						<xsl:for-each select="(. | b:RDE_O11.OBSERVATION)/b:OBX[b:OBX.5/b:CE.3 = '99VA_52_116' or b:OBX.5/b:CE.3 = '99VA_52_117' or b:OBX.5/b:CE.3 = '99VA_52_118' or b:OBX.5/b:CE.3 = '99VA_52_119' or b:OBX.5/b:CE.3 = '99VA_52_120' or b:OBX.5/b:CE.3 = '99VA_52_121' ]">
							<treatmentFactor>
								<factor>
									<code>
										<xsl:value-of select="b:OBX.3/b:CE.1"/>
									</code>
								</factor>
								<factorValue>
									<xsl:call-template name="getCodedElementLite">
										<xsl:with-param name="theCode" select="b:OBX.5"/>
									</xsl:call-template>
								</factorValue>
							</treatmentFactor>
						</xsl:for-each>
						<originalDispense>
							<xsl:call-template name="getMedicationDispense"/>
						</originalDispense>
						<xsl:for-each select="/(b:RDS_O13/b:RDS_O13.ORDER | b:RDE_O11/b:RDE_O11.ORDER)[b:ORC/b:ORC.1  = 'RF' and b:ORC/b:ORC.16/b:CE.1 = 'REFILL' ]">
							<refillDispense>
								<xsl:call-template name="getMedicationDispense"/>
							</refillDispense>
						</xsl:for-each>
						<xsl:for-each select="/(b:RDS_O13/b:RDS_O13.ORDER | b:RDE_O11/b:RDE_O11.ORDER)[b:ORC/b:ORC.1  = 'RF' and b:ORC/b:ORC.16/b:CE.1 = 'PARTIAL' ]">
							<partialDispense>
								<xsl:call-template name="getMedicationDispense"/>
							</partialDispense>
						</xsl:for-each>
						<!-- Cancellation/Deletion of an order may not have both date and comment, this check is needed to determine if either is present -->
						<xsl:if test="(b:ORC/b:ORC.7/b:TQ.7  = 'CANCEL') or ((. | b:RDE_O11.OBSERVATION)/b:NTE/b:NTE.4/b:CE.1 = 'DE') or ((b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.1[ b:TQ.7/ends-with(., 'CANCEL')])">
							<cancel>
								<xsl:choose>
									<xsl:when test="b:ORC/b:ORC.7/b:TQ.7  = 'CANCEL'">
										<cancelDate>
											<literal>
												<xsl:value-of select="b:ORC/b:ORC.7[b:TQ.7  = 'CANCEL']/b:TQ.5/b:TS.1"/>
											</literal>
										</cancelDate>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.1[ b:TQ.7/ends-with(., 'CANCEL')]">
											<cancelDate>
												<literal>
													<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.1[ b:TQ.7/ends-with(., 'CANCEL')]/b:TQ.5/b:TS.1"/>
												</literal>
											</cancelDate>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="(. | b:RDE_O11.OBSERVATION)/b:NTE/b:NTE.4/b:CE.1 = 'DE'">
										<xsl:for-each select="(. | b:RDE_O11.OBSERVATION)/b:NTE[b:NTE.4/b:CE.1 = 'DE']/b:NTE.3">
											<comments>
												<xsl:value-of select="."/>
											</comments>
										</xsl:for-each>
									</xsl:when>
								</xsl:choose>
							</cancel>
						</xsl:if>
						<xsl:variable name="InstructionCount" select="count((b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.1/b:TQ.1/b:CQ.2/b:CE.1)"/>
						<xsl:if test="$InstructionCount > 0">
							<xsl:call-template name="getMedicationInstructions">
								<xsl:with-param name="repeat" select="1"/>
								<xsl:with-param name="count" select="$InstructionCount + 1"/>
								<xsl:with-param name="theInstructions" select="(b:RDS_O13.ENCODING | .)/b:RXE"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:for-each select="(. | b:RDE_O11.OBSERVATION)/b:FT1[b:FT1.6 = 'CG']">
							<xsl:variable name="finisher">
								<xsl:call-template name="getPractitioner">
									<xsl:with-param name="thePractitioner" select="b:FT1.20"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="string-length($finisher) > 0">
								<finisher>
									<xsl:call-template name="getPractitioner">
										<xsl:with-param name="thePractitioner" select="b:FT1.20"/>
									</xsl:call-template>
								</finisher>
							</xsl:if>
						</xsl:for-each>
						<xsl:for-each select="../b:MSH">
							<xsl:call-template name="getRecordInformation"/>
						</xsl:for-each>
					</outpatientMedicationPromises>
				</xsl:for-each>
			</patient>
		</clinicaldata:ClinicalData>
	</xsl:template>
	<!--
		##################################################################################################################

		getMedicationDispense template is appled for original, partial and refill segments
		Path starts at /RDS_O13/RDS_O13.ORDER or /RDE_O11/RDE_O11.ORDER

	-->
	<xsl:template name="getMedicationDispense">
		<!-- CHDR/DOD messages may not give any message type definition (no CE.1='RE') to a comment, if so, they're placed here -->
		<xsl:if test="((. | b:RDE_O11.OBSERVATION)/b:NTE/b:NTE.4/b:CE.1 = 'RE') or (../b:MSH/b:MSH.4/b:HD.2/starts-with(.,'VHACHDR'))">
			<!-- CHDR/DOD comments in RDE_O11 messages are not found in the OBSERVATION group, must look to the ORDER_DETAIL group. Joey 07/16/2008 -->
			<xsl:for-each select="(. | b:RDE_O11.OBSERVATION | b:RDE_O11.ORDER_DETAIL)/b:NTE[b:NTE.4/b:CE.1 = 'RE' or b:NTE.4/b:CE.1 = '' or not(b:NTE.4)]/b:NTE.3 ">
				<comments>
					<xsl:value-of select="."/>
				</comments>
			</xsl:for-each>
		</xsl:if>
		<dispenseDate>
			<literal>
				<xsl:value-of select="b:ORC/b:ORC.7[b:TQ.7  = 'DISPENSED/LAST DISPENSED' or b:TQ.7  = 'DISPENSED']/b:TQ.4/b:TS.1"/>
			</literal>
		</dispenseDate>
		<fillDate>
			<literal>
				<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.1/b:TQ.4/b:TS.1"/>
			</literal>
		</fillDate>
		<quantityDispensed>
			<value>
				<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.10"/>
			</value>
		</quantityDispensed>
		<xsl:for-each select="b:ORC/b:ORC.12[b:XCN.8 != 'COSIGNER']">
			<currentProvider>
				<xsl:call-template name="getPractitionerLite">
					<xsl:with-param name="thePractitioner" select="."/>
				</xsl:call-template>
			</currentProvider>
		</xsl:for-each>
		<xsl:for-each select="(. | b:RDE_O11.OBSERVATION)/b:NTE[b:NTE.4/b:CE.1 = 'PR']/b:NTE.3">
			<currentProviderComments>
				<xsl:value-of select="."/>
			</currentProviderComments>
		</xsl:for-each>
		<loginDate>
			<literal>
				<xsl:value-of select="b:ORC/b:ORC.9/b:TS.1"/>
			</literal>
		</loginDate>
		<daysSupply>
			<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.22"/>
		</daysSupply>
		<identifier>
			<identity>
				<xsl:value-of select="b:ORC/b:ORC.3/b:EI.1"/>
			</identity>
			<namespaceId>
				<xsl:value-of select="b:ORC/b:ORC.3/b:EI.2"/>
			</namespaceId>
		</identifier>
		<xsl:for-each select="(. | b:RDE_O11.OBSERVATION)/b:OBX/b:OBX.5[b:CE.3  = '99VA_52_42']">
			<levelOfUnderstanding>
				<xsl:call-template name="getCodedElementLite">
					<xsl:with-param name="theCode" select="."/>
				</xsl:call-template>
			</levelOfUnderstanding>
		</xsl:for-each>
		<mailWindow>
			<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.8/b:LA1.6"/>
		</mailWindow>
		<releaseDate>
			<literal>
				<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.18/b:TS.1"/>
			</literal>
		</releaseDate>
		<xsl:for-each select="(.| b:RDE_O11.OBSERVATION)/b:OBX/b:OBX.5[b:CE.3  = '99VA_52_41']">
			<wasPatientCounseled>
				<xsl:call-template name="getCodedElementLite">
					<xsl:with-param name="theCode" select="."/>
				</xsl:call-template>
			</wasPatientCounseled>
		</xsl:for-each>
		<division>
			<divisionId>
				<xsl:call-template name="getCodedElementLite">
					<xsl:with-param name="theCode" select="b:ORC/b:ORC.17"/>
				</xsl:call-template>
			</divisionId>
			<ncpdpId>
				<!-- cannot call getCodedElementLite for this element because it does not use the first three elements of the CE datatype -->
				<code>
					<xsl:value-of select="b:ORC/b:ORC.17/b:CE.4"/>
				</code>
				<displayText>
					<xsl:value-of select="b:ORC/b:ORC.17/b:CE.5"/>
				</displayText>
				<codingSystem>
					<xsl:value-of select="b:ORC/b:ORC.17/b:CE.6"/>
				</codingSystem>
			</ncpdpId>
		</division>
		<dispensedDrug>
			<drugUnitPrice>
				<value>
					<xsl:value-of select="(. | b:RDE_O11.OBSERVATION)/b:FT1[b:FT1.6='CG']/b:FT1.12/b:CP.1/b:MO.1"/>
				</value>
			</drugUnitPrice>
			<expirationDate>
				<literal>
					<!-- only attempt to process dispensedDrug.expirationDate from ORC.7.5.1 if this is not the origianl fill.  Joey 07/16/2008-->
					<!-- the ORC.7.5.1 value of the original fill is the prescription expiration which was processed earlier in this transform -->
					<xsl:value-of select="b:ORC[b:ORC.1 = 'RF']/b:ORC.7[b:TQ.7/ends-with(., 'EXPIRATION')]/b:TQ.5/b:TS.1"/>
				</literal>
			</expirationDate>
			<ndc>
				<!-- cannot call getCodedElementLite for this element because it does not use the first three elements of the CE datatype -->
				<code>
					<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.2/b:CE.4"/>
				</code>
				<displayText>
					<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.2/b:CE.5"/>
				</displayText>
				<codingSystem>
					<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.2/b:CE.6"/>
				</codingSystem>
			</ndc>
		</dispensedDrug>
		<xsl:for-each select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.14[b:XCN.8 != 'VERIFIER PHARM']">
			<pharmacist>
				<xsl:call-template name="getPractitioner">
					<xsl:with-param name="thePractitioner" select="."/>
				</xsl:call-template>
			</pharmacist>
		</xsl:for-each>
		<cmopEventStatus>
			<!-- cannot call getCodedElementLite for this element because it does not use a CE datatype -->
			<code>
				<xsl:value-of select="b:ORC/b:ORC.25/b:CWE.4"/>
			</code>
			<displayText>
				<xsl:value-of select="b:ORC/b:ORC.25/b:CWE.5"/>
			</displayText>
			<codingSystem>
				<xsl:value-of select="b:ORC/b:ORC.25/b:CWE.6"/>
			</codingSystem>
		</cmopEventStatus>
		<!-- adding numberOfRefillsRemaining to support DoD information (Joey 06/13/2008) -->
		<xsl:if test="(string(number((b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.16)) != 'NaN')">
			<numberOfRefillsRemaining>
				<xsl:value-of select="(b:RDS_O13.ENCODING | .)/b:RXE/b:RXE.16"/>
			</numberOfRefillsRemaining>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getMedicationInstructions template (This template is called recursively to pull in all the repeating medication instructions)
		Path starts at RDS_O13.ENCODING/RXE or RXE

	-->
	<xsl:template name="getMedicationInstructions">
		<xsl:param name="repeat" select="1"/>
		<xsl:param name="count" select="2"/>
		<xsl:param name="theInstructions" select="3"/>
		<xsl:if test="$count > $repeat">
			<medicationInstructions>
				<conjunction>
					<xsl:call-template name="getCodedElementLite">
						<xsl:with-param name="theCode" select="$theInstructions/b:RXE.7[b:CE.3/ends-with(., '_52.0113_5')][$repeat]"/>
					</xsl:call-template>
				</conjunction>
				<dispenseUnitsPerDose>
					<xsl:value-of select="$theInstructions/b:RXE.1[$repeat]/b:TQ.1/b:CQ.1"/>
				</dispenseUnitsPerDose>
				<dosageOrdered>
					<xsl:value-of select="$theInstructions/b:RXE.1[$repeat]/b:TQ.1/b:CQ.2/b:CE.1"/>
				</dosageOrdered>
				<noun>
					<xsl:call-template name="getCodedElementLite">
						<xsl:with-param name="theCode" select="$theInstructions/b:RXE.7[b:CE.3/ends-with(., '_52.0113_3')][$repeat]"/>
					</xsl:call-template>
				</noun>
				<route>
					<xsl:call-template name="getCodedElementLite">
						<xsl:with-param name="theCode" select="(b:RDS_O13.ENCODING | .)/b:RXR/b:RXR.1[$repeat]"/>
					</xsl:call-template>
				</route>
				<schedule>
					<xsl:call-template name="getCodedElementLite">
						<xsl:with-param name="theCode" select="$theInstructions/b:RXE.7[b:CE.3/ends-with(., '_52.0113_7')][$repeat]"/>
					</xsl:call-template>
				</schedule>
				<verb>
					<xsl:call-template name="getCodedElementLite">
						<xsl:with-param name="theCode" select="$theInstructions/b:RXE.7[b:CE.3/ends-with(., '_52.0113_8')][$repeat]"/>
					</xsl:call-template>
				</verb>
				<giveUnits>
					<!-- this is not a repeating field, simply put this value in each occurrance -->
					<xsl:call-template name="getCodedElementLite">
						<xsl:with-param name="theCode" select="$theInstructions/b:RXE.5"/>
					</xsl:call-template>
				</giveUnits>
				<intendedDuration>
					<xsl:value-of select="$theInstructions/b:RXE.1[$repeat]/b:TQ.3"/>
				</intendedDuration>
			</medicationInstructions>
			<xsl:call-template name="getMedicationInstructions">
				<xsl:with-param name="repeat" select="$repeat + 1"/>
				<xsl:with-param name="count" select="$count"/>
				<xsl:with-param name="theInstructions" select="(b:RDS_O13.ENCODING | .)/b:RXE"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################
		############################################### COMMON TEMPLATES ###############################################

		getRecordIdentifier template
		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively

	-->
	<xsl:template name="getRecordIdentifier">
		<!--xsl:if test="((b:EI.1 != '') and (b:EI.2 != ''))"-->
		<!-- need to look to ORC.17.1 if ORC.3.2 is blank, Required to CHDR deficiency -->
		<xsl:if test="((b:EI.1 != '') and ((b:EI.2 != '') or (../b:ORC.17/b:CE.1 != '')))">
			<recordIdentifier>
				<identity>
					<xsl:value-of select="b:EI.1"/>
				</identity>
				<namespaceId>
					<xsl:choose>
						<xsl:when test="b:EI.2 != ''">
							<xsl:value-of select="b:EI.2"/>
						</xsl:when>
						<xsl:otherwise>
							<!--xsl:when test="../b:ORC.17/b:CE.1 != ''"-->
							<xsl:value-of select="../b:ORC.17/b:CE.1"/>
							<!--/xsl:when-->
						</xsl:otherwise>
						<!--xsl:otherwise>
							<xsl:text>UNKNOWN-NAMESPACE</xsl:text>
						</xsl:otherwise-->
					</xsl:choose>
				</namespaceId>
			</recordIdentifier>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getPatientLite template
		applies to PID/b:PID.3[b:CX.5 = 'PI'] path

	-->
	<xsl:template name="getPatientLite">
		<xsl:if test="((b:CX.1 != '') and (b:CX.6/b:HD.2 != '') and (b:CX.4/b:HD.1 != ''))">
			<patient>
				<identifier>
					<identity>
						<xsl:value-of select="b:CX.1"/>
					</identity>
					<assigningFacility>
						<xsl:value-of select="b:CX.6/b:HD.2"/>
					</assigningFacility>
					<assigningAuthority>
						<xsl:value-of select="b:CX.4/b:HD.1"/>
					</assigningAuthority>
				</identifier>
				<!-- get  'L' (legal) name of this patient when possible otherwise take the first occurrence-->
				<xsl:choose>
					<xsl:when test="../b:PID.5[b:XPN.7 = 'L']">
						<name>
							<given>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.2"/>
							</given>
							<middle>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.3"/>
							</middle>
							<family>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.1/b:FN.1"/>
							</family>
							<suffix>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.4"/>
							</suffix>
						</name>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="../b:PID.5[1]/b:XPN.1/b:FN.1">
							<name>
								<given>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.2"/>
								</given>
								<middle>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.3"/>
								</middle>
								<family>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.1/b:FN.1"/>
								</family>
								<suffix>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.4"/>
								</suffix>
							</name>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</patient>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getRecordInformation template
		applies to MSH path

	-->
	<xsl:template name="getRecordInformation">
		<xsl:if test="(b:MSH.4/b:HD.1 != '')">
			<recordSource>
				<namespaceId>
					<xsl:value-of select="b:MSH.4/b:HD.1"/>
				</namespaceId>
				<universalId>
					<xsl:value-of select="b:MSH.4/b:HD.2"/>
				</universalId>
				<universalIdType>
					<xsl:value-of select="b:MSH.4/b:HD.3"/>
				</universalIdType>
			</recordSource>
		</xsl:if>
		<recordVersion>0</recordVersion>
		<xsl:if test="(b:MSH.7/b:TS.1 != '')">
			<recordUpdateTime>
				<literal>
					<xsl:value-of select="b:MSH.7/b:TS.1"/>
				</literal>
			</recordUpdateTime>
		</xsl:if>
	</xsl:template>
	<!--
		#########################################################

		getCodedElementLite template
		applies to any path ending in CE or CNE and transforming CE.1/CNE.1, CE.2/CNE.2, and CE.3/CNE.3 into code, displayText, and codingSystem respectively

	-->
	<xsl:template name="getCodedElementLite">
		<xsl:param name="theCode"/>
		<code>
			<xsl:value-of select="$theCode/(b:CE.1 | b:CNE.1)"/>
		</code>
		<displayText>
			<xsl:value-of select="$theCode/(b:CE.2 | b:CNE.2)"/>
		</displayText>
		<codingSystem>
			<xsl:value-of select="$theCode/(b:CE.3 | b:CNE.3)"/>
		</codingSystem>
	</xsl:template>
	<!--
		##################################################################################################################

		getPractitioner template
		applies to any path ending in XCN and transforming XCN.1 through XCN.8 into the appropriate Pracitioner elements

	-->
	<xsl:template name="getPractitioner">
		<xsl:param name="thePractitioner"/>
		<practitioner>
			<xsl:call-template name="getPractitionerLite">
				<xsl:with-param name="thePractitioner" select="$thePractitioner"/>
			</xsl:call-template>
		</practitioner>
	</xsl:template>
	<!--
		##################################################################################################################

		getPractitionerLite template
		applies to any path ending in XCN and transforming XCN.1 through XCN.8 into the appropriate Pracitioner elements

	-->
	<xsl:template name="getPractitionerLite">
		<xsl:param name="thePractitioner"/>
			<identifier>
				<identity>
					<xsl:value-of select="$thePractitioner/b:XCN.1"/>
				</identity>
				<assigningFacility/>
			</identifier>
			<idSourceTable>
				<xsl:value-of select="$thePractitioner/b:XCN.8"/>
			</idSourceTable>
			<name>
				<prefix>
					<xsl:value-of select="$thePractitioner/b:XCN.6"/>
				</prefix>
				<given>
					<xsl:value-of select="$thePractitioner/b:XCN.3"/>
				</given>
				<middle>
					<xsl:value-of select="$thePractitioner/b:XCN.4"/>
				</middle>
				<family>
					<xsl:value-of select="$thePractitioner/b:XCN.2/b:FN.1"/>
				</family>
				<suffix>
					<xsl:value-of select="$thePractitioner/b:XCN.5"/>
				</suffix>
				<title>
					<xsl:value-of select="$thePractitioner/b:XCN.7"/>
				</title>
			</name>
	</xsl:template>

</xsl:stylesheet>
