<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ns0="urn:hl7-org:v2xml" exclude-result-prefixes="xs fn ns0" xmlns:saxon="http://saxon.sf.net/" xmlns:hthsurvey="HTHSurvey">
<!-- 
	<xsl:include href="SurveyCommonTemplates.xsl"/>
	<xsl:include href="Hl7CommonTemplates.xsl"/>
-->
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- Use Below for Message Mediator -->
	<xsl:variable name="var1_MDM_T02" as="node()?" select="ns0:MDM_T02"/>
	<xsl:variable name="fullSurvey" select="saxon:parse-survey($var1_MDM_T02/ns0:OBX/ns0:OBX.5)"/>
	<xsl:variable name="survey" select="$fullSurvey/hthsurvey:hthSurvey"/>
		 
	<!-- Use below for testing in XMLSpy 
	<xsl:variable name="var1_MDM_T02">
		<ns0:MSH>
			<ns0:MSH.4>
				<ns0:HD.1>ni123</ns0:HD.1>
				<ns0:HD.2>ui456</ns0:HD.2>
				<ns0:HD.3>ut789</ns0:HD.3>
			</ns0:MSH.4>
			<ns0:MSH.7>
				<ns0:TS.1>20130213111213-0500</ns0:TS.1>
			</ns0:MSH.7>
		</ns0:MSH>
		<ns0:PID>
			<ns0:PID.3>
				<ns0:CX.1>ID12345</ns0:CX.1>
				<ns0:CX.2></ns0:CX.2>
				<ns0:CX.3></ns0:CX.3>
				<ns0:CX.4>
					<ns0:HD.1>USVHA</ns0:HD.1>
				</ns0:CX.4>
				<ns0:CX.5>PI</ns0:CX.5>
				<ns0:CX.6>
					<ns0:HD.2>552</ns0:HD.2>
				</ns0:CX.6>
			</ns0:PID.3>
		</ns0:PID>
	</xsl:variable>
	<xsl:variable name="survey" select="hthsurvey:hthSurvey"/>
	-->
	<!--
		####################################################################################################################
		                                                                           START OF MAIN TEMPLATE 
		####################################################################################################################
	-->
	<xsl:template match="/">
		<ClinicalData xmlns="Clinicaldata" xmlns:basedatatypes="Basedatatypes" xmlns:common="Common" xmlns:surveys="Surveys">
			<templateId xmlns="">
				<xsl:sequence select="'PSSurveyCreate40025'"/>
			</templateId>
			
			<patient xmlns="">
				<psSurveyResponse>
				
					<xsl:for-each select="$survey/psSurveyResponse">
						<xsl:call-template name="getSurveyType"/>
					</xsl:for-each>
				
					<surveyPatient>
						<xsl:for-each select="$var1_MDM_T02/ns0:PID/ns0:PID.3[ns0:CX.5 = 'PI']">
							<xsl:call-template name="getPatientLite"/>
						</xsl:for-each>
						<xsl:for-each select="$survey/psSurveyResponse/patient">
							<xsl:call-template name="getSurveyPatient"/>
						</xsl:for-each>
					</surveyPatient>
		
					<xsl:for-each select="$survey/psSurveyResponse">
				 		<xsl:call-template name="getSurveyCommon"/> 
				 		<xsl:for-each select="$var1_MDM_T02//ns0:MSH">
							<xsl:call-template name="getRecordInformation"/>
						</xsl:for-each>
						<xsl:call-template name="getSurveyQuestionsAndAnswers"/>
					</xsl:for-each>
			
				</psSurveyResponse>
			</patient>
		</ClinicalData>
	</xsl:template>
	
	<!--
		#######################################################################################################################
		###########################################SURVEY COMMON TEMPLATES ###############################################
	-->
	<xsl:template name="getName">
		<name>
			<xsl:if test="(given != '')">
				<given>
					<xsl:sequence select="fn:string(given)"/>
				</given>
			</xsl:if>
			<xsl:if test="(middle != '')">
				<middle>
					<xsl:sequence select="fn:string(middle)"/>
				</middle>
			</xsl:if>
			<xsl:if test="(family != '')">
				<family>
					<xsl:sequence select="fn:string(family)"/>
				</family>
			</xsl:if>
		</name>
	</xsl:template>
	<xsl:template name="getSurveyPatient">
		<icn>
			<xsl:sequence select="fn:string(icn)"/>
		</icn>
		<ssn>
			<xsl:sequence select="fn:string(ssn)"/>
		</ssn>
		<xsl:for-each select="name">
			<xsl:call-template name="getName"/>
		</xsl:for-each>
		<birthdate>
			<xsl:sequence select="xs:string(xs:date(fn:string(birthdate)))"/>
		</birthdate>
	</xsl:template>
	<xsl:template name="getSurveyCommon">
		<xsl:for-each select="enrollmentDate">
			<enrollmentDate>
				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
			</enrollmentDate>
		</xsl:for-each>
		<xsl:if test="(disenrollmentDate != '')">
			<xsl:for-each select="disenrollmentDate">
				<disenrollmentDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</disenrollmentDate>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="(activationDate != '')">
			<xsl:for-each select="activationDate">
				<activationDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</activationDate>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="(inactivationDate != '')">
			<xsl:for-each select="inactivationDate">
				<inactivationDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</inactivationDate>
			</xsl:for-each>
		</xsl:if>
		<vendorMRN>
			<xsl:sequence select="fn:string(vendorMRN)"/>
		</vendorMRN>
		<facility>
			<facilityNumber>
				<xsl:sequence select="fn:string(facilityNumber)"/>
			</facilityNumber>
		</facility>
		<vendor>
			<vendorNumber>
				<xsl:sequence select="fn:string(vendorNumber)"/>
			</vendorNumber>
			<vendorName>
				<xsl:sequence select="fn:string(vendorName)"/>
			</vendorName>
		</vendor>
		<careCoordinator>
			<xsl:for-each select="careCoordinator">
				<id>
					<xsl:sequence select="fn:string(id)"/>
				</id>
				<xsl:for-each select="name">
					<xsl:call-template name="getName"/>
				</xsl:for-each>
			</xsl:for-each>
		</careCoordinator>
		<xsl:if test="(scheduledDate != '')">
			<xsl:for-each select="scheduledDate">
				<scheduledDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</scheduledDate>
			</xsl:for-each>
		</xsl:if>
		<completedDate>
			<xsl:sequence select="xs:string(xs:dateTime(fn:string(completedDate)))"/>
		</completedDate>
		<xsl:for-each select="currentDialogueName">
			<currentDialogueName>
				<xsl:sequence select="fn:string(.)"/>
			</currentDialogueName>
		</xsl:for-each>
		<xsl:for-each select="programName">
			<programName>
				<xsl:sequence select="fn:string(.)"/>
			</programName>
		</xsl:for-each>
		<xsl:for-each select="deviceName">
			<deviceName>
				<xsl:sequence select="fn:string(.)"/>
			</deviceName>
		</xsl:for-each>
		<xsl:for-each select="surveyAcceptedStatus">
			<responseStatus>
				<xsl:sequence select="fn:string(.)"/>
			</responseStatus>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="getSurveyType">
		<survey>
			<surveyTitle>
				<xsl:sequence select="fn:string(surveyTitle)"/>
			</surveyTitle>
			<surveyVersion>
				<xsl:sequence select="fn:string(surveyVersion)"/>
			</surveyVersion>
		</survey>
	</xsl:template>
	<xsl:template name="getSurveyQuestionsAndAnswers">
		<surveyQuestionsAndAnswers>
			<xsl:for-each select="surveyQuestionsAndAnswers/surveyQuestionAndAnswer">
				<surveyQuestionAndAnswer>
					<questionNumber>
						<xsl:sequence select="xs:string(xs:integer(fn:string(questionNumber)))"/>
					</questionNumber>
					<answer>
						<xsl:sequence select="xs:string(xs:integer(fn:string(answer)))"/>
					</answer>
				</surveyQuestionAndAnswer>
			</xsl:for-each>
		</surveyQuestionsAndAnswers>
	</xsl:template>
	<xsl:template name="getSurveyScores">
		<surveyScores>
			<xsl:for-each select="surveyScores/mentalScore">
				<mentalScore>
					<xsl:sequence select="xs:string(xs:decimal(fn:string(.)))"/>
				</mentalScore>
			</xsl:for-each>
			<xsl:for-each select="surveyScores/physicalScore">
				<physicalScore>
					<xsl:sequence select="xs:string(xs:decimal(fn:string(.)))"/>
				</physicalScore>
			</xsl:for-each>
		</surveyScores>
	</xsl:template>
	<!--
		#######################################################################################################################
		############################################### HL7 COMMON TEMPLATES ###############################################

		getRecordIdentifier template
		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively

	-->
	<xsl:template name="getRecordIdentifier">
		<xsl:if test="((ns0:EI.1 != '') and (ns0:EI.2 != ''))">
			<recordIdentifier>
				<identity>
					<xsl:value-of select="ns0:EI.1"/>
				</identity>
				<namespaceId>
					<xsl:value-of select="ns0:EI.2"/>
				</namespaceId>
			</recordIdentifier>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getPatientLite template
		applies to PID/ns0:PID.3[ns0:CX.5 = 'PI'] path

	-->
	<xsl:template name="getPatientLite">
		<xsl:if test="((ns0:CX.1 != '') and (ns0:CX.6/ns0:HD.2 != '') and (ns0:CX.4/ns0:HD.1 != ''))">
			<patient>
				<identifier>
					<identity>
						<xsl:value-of select="ns0:CX.1"/>
					</identity>
					<assigningFacility>
						<xsl:value-of select="ns0:CX.6/ns0:HD.2"/>
					</assigningFacility>
					<assigningAuthority>
						<xsl:value-of select="ns0:CX.4/ns0:HD.1"/>
					</assigningAuthority>
				</identifier>
				<!-- get  'L' (legal) name of this patient when possible otherwise take the first occurrence-->
				<xsl:choose>
					<xsl:when test="../ns0:PID.5[ns0:XPN.7 = 'L']">
						<name>
							<prefix>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.5"/>
							</prefix>
							<given>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.2"/>
							</given>
							<middle>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.3"/>
							</middle>
							<family>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.1/ns0:FN.1"/>
							</family>
							<suffix>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.4"/>
							</suffix>
							<title>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.6"/>
							</title>
						</name>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="../ns0:PID.5[1]/ns0:XPN.1/ns0:FN.1">
							<name>
								<prefix>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.5"/>
								</prefix>
								<given>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.2"/>
								</given>
								<middle>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.3"/>
								</middle>
								<family>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.1/ns0:FN.1"/>
								</family>
								<suffix>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.4"/>
								</suffix>
								<title>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.6"/>
								</title>
							</name>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</patient>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getRecordInformation template
		applies to MSH path

	-->
	<xsl:template name="getRecordInformation">
		<xsl:if test="(ns0:MSH.4/ns0:HD.1 != '')">
			<recordSource>
				<namespaceId>
					<xsl:value-of select="ns0:MSH.4/ns0:HD.1"/>
				</namespaceId>
				<universalId>
					<xsl:value-of select="ns0:MSH.4/ns0:HD.2"/>
				</universalId>
				<universalIdType>
					<xsl:value-of select="ns0:MSH.4/ns0:HD.3"/>
				</universalIdType>
			</recordSource>
		</xsl:if>
		<xsl:if test="(ns0:MSH.7/ns0:TS.1 != '')">
			<recordUpdateTime>
				<literal>
					<xsl:value-of select="ns0:MSH.7/ns0:TS.1"/>
				</literal>
			</recordUpdateTime>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
