<?xml version="1.0" encoding="UTF-8"?>
<!-- $Author: DNS   shaha $ -->
<!-- $DateTime: 2014/10/02 14:48:57 $ -->
<!-- $File: //repositories/apps/mediator/branches/rtc/mediator/src/main/resources/xslts/vhim400/HL7ToAllergyIntoleranceCondition.xsl $ -->
<!-- $Revision: #1 $ -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:b="urn:hl7-org:v2xml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<clinicaldata:ClinicalData xmlns:clinicaldata="Clinicaldata">
			<templateId>IntoleranceConditionCreateOrUpdate40060</templateId>
			<patient>
				<xsl:variable name="nationalId" select="b:ORU_R01/b:ORU_R01.PATIENT_RESULT/b:ORU_R01.PATIENT/b:PID/b:PID.3[b:CX.5 = 'NI'][1]/b:CX.1"/>
				<xsl:if test="string-length($nationalId) > 0">
					<requestedNationalId>
						<xsl:value-of select="$nationalId"/>
					</requestedNationalId>
				</xsl:if>		
				<xsl:for-each select="b:ORU_R01/b:ORU_R01.PATIENT_RESULT/b:ORU_R01.ORDER_OBSERVATION">
					<intoleranceConditions>
						<xsl:for-each select="b:OBR/b:OBR.3">
							<xsl:call-template name="getRecordIdentifier"/>
						</xsl:for-each>
						<xsl:for-each select="../b:ORU_R01.PATIENT/b:PID/b:PID.3[b:CX.5 = 'PI']">
							<xsl:call-template name="getPatientLite"/>
						</xsl:for-each>
						<xsl:if test="(b:OBR/b:OBR.7/b:TS.1 != '') ">
							<observationTime>
								<literal>
									<xsl:value-of select="b:OBR/b:OBR.7/b:TS.1"/>
								</literal>
							</observationTime>
						</xsl:if>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'AGENT']">
							<agent>
								<code>
									<xsl:value-of select="b:OBX.5/b:CE.1"/>
								</code>
							</agent>
						</xsl:for-each>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'ALLERGY TYPE']">
							<allergyType>
								<xsl:call-template name="getCodedElementLite">
									<xsl:with-param name="theCode" select="b:OBX.5"/>
								</xsl:call-template>
							</allergyType>
						</xsl:for-each>
						<!--xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'GMR ALLERGY']"-->
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1/starts-with(.,'GMR ALLERGY')]">
							<gmrAllergyAgent>
								<xsl:call-template name="getCodedElementLite">
									<xsl:with-param name="theCode" select="b:OBX.5"/>
								</xsl:call-template>
								<alternateCode>
									<xsl:value-of select="b:OBX.5/b:CE.4"/>
								</alternateCode>
								<alternateDisplayText>
									<xsl:value-of select="b:OBX.5/b:CE.5"/>
								</alternateDisplayText>
								<alternateCodingSystem>
									<xsl:value-of select="b:OBX.5/b:CE.6"/>
								</alternateCodingSystem>
							</gmrAllergyAgent>
						</xsl:for-each>
						<informationSourceCategory>
							<xsl:call-template name="getCodedElementLite">
								<xsl:with-param name="theCode" select="b:OBR/b:OBR.47"/>
							</xsl:call-template>
						</informationSourceCategory>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'MECHANISM' ]">
							<mechanism>
								<xsl:call-template name="getCodedElementLite">
									<xsl:with-param name="theCode" select="b:OBX.5"/>
								</xsl:call-template>
							</mechanism>
						</xsl:for-each>
						<status>
							<xsl:value-of select="b:OBR/b:OBR.25"/>
						</status>
						<xsl:if test="b:OBR/b:OBR.34[b:NDL.1/b:CNN.8 = 'V']">
							<verified>YES</verified>
						</xsl:if>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'REACTION' ]">
							<reaction>
								<observationTime>
									<literal>
										<xsl:value-of select="b:OBX.14/b:TS.1"/>
									</literal>
								</observationTime>
								<reaction>
									<xsl:call-template name="getCodedElementLite">
										<xsl:with-param name="theCode" select="b:OBX.5"/>
									</xsl:call-template>
								</reaction>
								<xsl:variable name="author">
									<xsl:call-template name="getPractitioner">
										<xsl:with-param name="thePractitioner" select="b:OBX.16"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:if test="string-length($author) > 0">
									<!-- Only use author is data is present. -->
									<author>
										<xsl:call-template name="getPractitioner">
											<xsl:with-param name="thePractitioner" select="b:OBX.16"/>
										</xsl:call-template>
									</author>
								</xsl:if>
							</reaction>
						</xsl:for-each>
						<xsl:for-each select="b:OBR/b:OBR.34[b:NDL.1/b:CNN.8 = 'V']">
							<verifier>
								<time>
									<literal>
										<xsl:value-of select="b:NDL.2/b:TS.1"/>
									</literal>
								</time>
								<xsl:call-template name="getPractitioner">
									<xsl:with-param name="thePractitioner" select="b:NDL.1"/>
								</xsl:call-template>
							</verifier>
						</xsl:for-each>
						<author>
							<xsl:call-template name="getPractitioner">
								<xsl:with-param name="thePractitioner" select="b:OBR/b:OBR.32/b:NDL.1"/>
							</xsl:call-template>
						</author>
						<xsl:for-each select="b:OBR/b:OBR.34[b:NDL.1/b:CNN.8 = 'EE']">
							<errorEnterer>
								<time>
									<literal>
										<xsl:value-of select="b:NDL.2/b:TS.1"/>
									</literal>
								</time>
								<xsl:call-template name="getPractitioner">
									<xsl:with-param name="thePractitioner" select="b:NDL.1"/>
								</xsl:call-template>
							</errorEnterer>
						</xsl:for-each>
						<xsl:for-each select="b:OBR/b:OBR.34[b:NDL.1/b:CNN.8 = 'BM']">
							<idBandMarker>
								<time>
									<literal>
										<xsl:value-of select="b:NDL.2/b:TS.1"/>
									</literal>
								</time>
								<xsl:call-template name="getPractitioner">
									<xsl:with-param name="thePractitioner" select="b:NDL.1"/>
								</xsl:call-template>
							</idBandMarker>
						</xsl:for-each>
						<xsl:for-each select="b:OBR/b:OBR.34[b:NDL.1/b:CNN.8 = 'CM']">
							<chartMarker>
								<time>
									<literal>
										<xsl:value-of select="b:NDL.2/b:TS.1"/>
									</literal>
								</time>
								<xsl:call-template name="getPractitioner">
									<xsl:with-param name="thePractitioner" select="b:NDL.1"/>
								</xsl:call-template>
							</chartMarker>
						</xsl:for-each>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'COMMENT' ]">
							<commentEvents>
								<date>
									<literal>
										<xsl:value-of select="b:OBX.19/b:TS.1"/>
									</literal>
								</date>
								<!-- determine if data for 'author' is available -->
								<xsl:variable name="author">
									<xsl:call-template name="getPractitionerLite">
										<xsl:with-param name="thePractitionerLite" select="b:OBX.16"/>
									</xsl:call-template>
								</xsl:variable>
								<!-- Only use 'author' if it's not blank -->
								<xsl:if test="string-length($author) > 0">
									<author>
										<xsl:call-template name="getPractitionerLite">
											<xsl:with-param name="thePractitionerLite" select="b:OBX.16"/>
										</xsl:call-template>
									</author>
								</xsl:if>
								<commentType>
									<xsl:call-template name="getCodedElementLite">
										<xsl:with-param name="theCode" select="b:OBX.17"/>
									</xsl:call-template>
								</commentType>
								<xsl:for-each select="b:OBX.5">
									<comments>
													<xsl:value-of select="."/>
									</comments>
								</xsl:for-each>
							</commentEvents>
						</xsl:for-each>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'DRUG CLASSES' ]">
							<xsl:for-each select="b:OBX.5">
								<drugClass>
									<code>
										<xsl:call-template name="getCodedElementLite">
											<xsl:with-param name="theCode" select="."/>
										</xsl:call-template>
										<alternateCode>
											<xsl:value-of select="b:CE.4"/>
										</alternateCode>
										<alternateDisplayText>
											<xsl:value-of select="b:CE.5"/>
										</alternateDisplayText>
										<alternateCodingSystem>
											<xsl:value-of select="b:CE.6"/>
										</alternateCodingSystem>
									</code>
								</drugClass>
							</xsl:for-each>
						</xsl:for-each>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'DRUG INGREDIENTS']">
							<xsl:for-each select="b:OBX.5">
								<drugIngredient>
									<code>
										<xsl:call-template name="getCodedElementLite">
											<xsl:with-param name="theCode" select="."/>
										</xsl:call-template>
									</code>
								</drugIngredient>
							</xsl:for-each>
						</xsl:for-each>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'AGENT']">
							<facilityIdentifier>
								<identity>
									<xsl:value-of select="b:OBX.15/b:CE.1"/>
								</identity>
								<name>
									<xsl:value-of select="b:OBX.15/b:CE.2"/>
								</name>
								<assigningAuthority>
									<xsl:value-of select="b:OBX.15/b:CE.3"/>
								</assigningAuthority>
							</facilityIdentifier>
						</xsl:for-each>
						<xsl:for-each select="/b:ORU_R01/b:MSH">
							<xsl:call-template name="getRecordInformation"/>
						</xsl:for-each>
					</intoleranceConditions>
				</xsl:for-each>
			</patient>
		</clinicaldata:ClinicalData>
	</xsl:template>
	<!--
		##################################################################################################################
		############################################### COMMON TEMPLATES ###############################################

		getRecordIdentifier template
		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively

	-->
	<xsl:template name="getRecordIdentifier">
		<xsl:if test="((b:EI.1 != '') and (b:EI.2 != ''))">
			<recordIdentifier>
				<identity>
					<xsl:value-of select="b:EI.1"/>
				</identity>
				<namespaceId>
					<xsl:value-of select="b:EI.2"/>
				</namespaceId>
			</recordIdentifier>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getPatientLite template
		applies to PID/b:PID.3[b:CX.5 = 'PI'] path

	-->
	<xsl:template name="getPatientLite">
		<xsl:if test="((b:CX.1 != '') and (b:CX.6/b:HD.2 != '') and (b:CX.4/b:HD.1 != ''))">
			<patient>
				<identifier>
					<identity>
						<xsl:value-of select="b:CX.1"/>
					</identity>
					<assigningFacility>
						<xsl:value-of select="b:CX.6/b:HD.2"/>
					</assigningFacility>
					<assigningAuthority>
						<xsl:value-of select="b:CX.4/b:HD.1"/>
					</assigningAuthority>
				</identifier>
				<!-- get  'L' (legal) name of this patient when possible otherwise take the first occurrence-->
				<xsl:choose>
					<xsl:when test="../b:PID.5[b:XPN.7 = 'L']">
						<name>
							<given>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.2"/>
							</given>
							<middle>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.3"/>
							</middle>
							<family>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.1/b:FN.1"/>
							</family>
							<suffix>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.4"/>
							</suffix>
						</name>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="../b:PID.5[1]/b:XPN.1/b:FN.1">
						<name>
							<given>
								<xsl:value-of select="../b:PID.5[1]/b:XPN.2"/>
							</given>
							<middle>
								<xsl:value-of select="../b:PID.5[1]/b:XPN.3"/>
							</middle>
							<family>
								<xsl:value-of select="../b:PID.5[1]/b:XPN.1/b:FN.1"/>
							</family>
							<suffix>
								<xsl:value-of select="../b:PID.5[1]/b:XPN.4"/>
							</suffix>
						</name>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</patient>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getRecordInformation template
		applies to MSH path

	-->
	<xsl:template name="getRecordInformation">
		<xsl:if test="(b:MSH.4/b:HD.1 != '')">
			<recordSource>
				<namespaceId>
					<xsl:value-of select="b:MSH.4/b:HD.1"/>
				</namespaceId>
				<universalId>
					<xsl:value-of select="b:MSH.4/b:HD.2"/>
				</universalId>
				<universalIdType>
					<xsl:value-of select="b:MSH.4/b:HD.3"/>
				</universalIdType>
			</recordSource>
		</xsl:if>
		<recordVersion>0</recordVersion>
		<xsl:if test="(b:MSH.7/b:TS.1 != '')">
			<recordUpdateTime>
				<literal>
					<xsl:value-of select="b:MSH.7/b:TS.1"/>
				</literal>
			</recordUpdateTime>
		</xsl:if>
	</xsl:template>
	<!--
		#########################################################
		
		getCodedElementLite template 
		applies to any path ending in CE or CNE and transforming CE.1/CNE.1, CE.2/CNE.2, and CE.3/CNE.3 into code, displayText, and codingSystem respectively
		
	-->
	<xsl:template name="getCodedElementLite">
		<xsl:param name="theCode"/>
		<code>
			<xsl:value-of select="$theCode/(b:CE.1 | b:CNE.1)"/>
		</code>
		<displayText>
			<xsl:value-of select="$theCode/(b:CE.2 | b:CNE.2)"/>
		</displayText>
		<codingSystem>
			<xsl:value-of select="$theCode/(b:CE.3 | b:CNE.3)"/>
		</codingSystem>
	</xsl:template>
	<!--
		##################################################################################################################

		getPractitioner template
		applies to any path ending in XCN or NDL and transforming (XCN)NDL.1 through (XCN)NDL.8 into the appropriate Pracitioner elements

	-->
	<xsl:template name="getPractitioner">
		<xsl:param name="thePractitioner"/>
		<practitioner>
			<xsl:call-template name="getPractitionerLite">
				<xsl:with-param name="thePractitionerLite" select="$thePractitioner"/>
			</xsl:call-template>
		</practitioner>
	</xsl:template>
	<!--
		##################################################################################################################

		getPractitionerLite template
		(generally called from getPractitioner but is sometimes called directly to avoid the <practitioner> tags needed only for PractitionerParticipation)
		applies to any path ending in XCN or NDL and transforming (XCN)NDL.1 through (XCN)NDL.8 into the appropriate Pracitioner elements

	-->
	<xsl:template name="getPractitionerLite">
		<xsl:param name="thePractitionerLite"/>
		<identifier>
			<identity>
				<xsl:value-of select="$thePractitionerLite/(b:XCN.1 | b:CNN.1)"/>
			</identity>
			<assigningFacility/>
		</identifier>
		<idSourceTable>
			<xsl:value-of select="$thePractitionerLite/(b:XCN.8 | b:CNN.8)"/>
		</idSourceTable>
		<name>
			<prefix>
				<xsl:value-of select="$thePractitionerLite/(b:XCN.6 | b:CNN.6)"/>
			</prefix>
			<given>
				<xsl:value-of select="$thePractitionerLite/(b:XCN.3 | b:CNN.3)"/>
			</given>
			<middle>
				<xsl:value-of select="$thePractitionerLite/(b:XCN.4 | b:CNN.4)"/>
			</middle>
			<family>
				<xsl:value-of select="$thePractitionerLite/(b:XCN.2/b:FN.1 | b:CNN.2)"/>
			</family>
			<suffix>
				<xsl:value-of select="$thePractitionerLite/(b:XCN.5 | b:CNN.5)"/>
			</suffix>
			<title>
				<xsl:value-of select="$thePractitionerLite/(b:XCN.7 | b:CNN.7)"/>
			</title>
		</name>
	</xsl:template>
</xsl:stylesheet>
