

package gov.va.med.cds.scheduler.persistence;


import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.PersistenceException;


public class ExpiredCensusReportAcknowledgementPersistenceManager
    extends
        AbstractHibernatePersistenceManager
    implements
        ExpiredCensusReportAcknowledgementPersistenceInterface
{

    private static final Log LOGGER = LogFactory.getLog( ExpiredCensusReportAcknowledgementPersistenceManager.class );

    private static final String CENSUSMASTERINGEST_EXPIRED_REPORTS = "censusMasterIngest.list.expiredReports";
    private static final String CENSUSMASTERINGEST_UPDATE_INGESTSTATUS = "censusMasterIngest.update.ingestStatus";
    private static final String CENSUSCOMPLETEWEEK_MASTER_ID = "censusCompleteWeek.list.censusMasterId";
    private static final String CENSUSCOMPLETEWEEK_UPDATE_INGESTSTATUS = "censusCompleteWeek.update.ingestStatus";


    @SuppressWarnings( "unchecked" )
    @Override
    public void sendAckForExpiredCensusReport( )
        throws PersistenceException
    {
        Session session = null;
        long censusMasterId = 0;
        int updatedEntities = 0;
        String vendorFacility = null;
        Date reportStartDt = null;
        CensusCompleteWeek censusCompleteWeek = null;
        CensusCompleteWeek censusCmplWeek = null;

        try
        {
            session = getSessionFactory().getCurrentSession();

            Query expiredReportsQuery = session.getNamedQuery( CENSUSMASTERINGEST_EXPIRED_REPORTS );
            List<CensusMasterIngest> expiredReports = expiredReportsQuery.list();

            for ( CensusMasterIngest censusMasterIngest : expiredReports )
            {
                censusMasterId = censusMasterIngest.getCensusMasterId();
                vendorFacility = censusMasterIngest.getVendorFacility();
                reportStartDt = censusMasterIngest.getReportStartDt();

                Query updateStsQuery = session.getNamedQuery( CENSUSMASTERINGEST_UPDATE_INGESTSTATUS );
                updatedEntities = updateStsQuery.setParameter( "censusMasterId", censusMasterId ).executeUpdate();

                //:vendorFacility and ccw.reportStartDt = :reportStartDt
                censusCompleteWeek = new CensusCompleteWeek();
                censusCompleteWeek.setVendorFacility( censusMasterIngest.getVendorFacility() );
                censusCompleteWeek.setReportStartDt( censusMasterIngest.getReportStartDt() );

                //Query censusCompleteWeekQuery = session.getNamedQuery( CENSUSCOMPLETEWEEK_MASTER_ID );
                //Query censusCompleteWeekQuery = session.createQuery("from censusCompleteWeek ccw where ccw.vendorFacility = :vendorFacility and (day(ccw.reportStartDt) = day(:reportStartDt) and month(ccw.reportStartDt) = month(:reportStartDt) and year(ccw.reportStartDt) = year(:reportStartDt))");
                Query censusCompleteWeekQuery = session.createQuery(
                                "from censusCompleteWeek ccw where ccw.vendorFacility = :vendorFacility and ccw.reportStartDt = :reportStartDt" );
                censusCompleteWeekQuery.setParameter( "vendorFacility", vendorFacility );
                censusCompleteWeekQuery.setDate( "reportStartDt", reportStartDt );
                //censusCompleteWeekQuery.setParameter( "reportStartStr", DateTimeUtil.getDate2String( reportStartDt ) );
                //Query censusCompleteWeekQuery = session.getNamedQuery( CENSUSCOMPLETEWEEK_MASTER_ID ).setProperties( censusCompleteWeek );
                List<CensusCompleteWeek> ccwList = censusCompleteWeekQuery.list();

                censusCmplWeek = ( null != ccwList && ccwList.size() > 0 ) ? ccwList.get( 0 ) : null;

                if ( null != censusCmplWeek )
                {
                    updatedEntities = session.getNamedQuery( CENSUSCOMPLETEWEEK_UPDATE_INGESTSTATUS ).setProperties( censusCmplWeek ).executeUpdate();

                    censusAcknowledgementWork.sendCensusAcknowledgement( censusCmplWeek, censusMasterId );
                }
            }
        }
        catch ( Exception e )
        {
            LOGGER.error( "Error in sendAckForExpiredCensusReport" + e );
            throw new PersistenceException( ErrorCodeEnum.ERROR_IN_PERSISTENCE_LAYER, e );
        }
    }
}
