

package gov.va.med.cds.scheduler;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import gov.va.med.cds.exception.CensusTransformAckException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.scheduler.persistence.ExpiredCensusReportAcknowledgementPersistenceInterface;


public class ExpiredCensusReportsJob
    extends
        AbstractCensusQuartzJobBean
{
    private static Log logger = LogFactory.getLog( ExpiredCensusReportsJob.class );
    private static final String EXPIRED_CENSUS_REP_PM_BEAN = "expiredCensusReportAcknowledgementPersistenceManager";

    private ExpiredCensusReportAcknowledgementPersistenceInterface expiredCensusReportAcknowledgementPersistenceManager;


    @Override
    protected void executeInternal( JobExecutionContext context )
        throws JobExecutionException
    {
        loadApplicationContext( context );

        try
        {
            expiredCensusReportAcknowledgementPersistenceManager = ( ExpiredCensusReportAcknowledgementPersistenceInterface )appCtx
                            .getBean( EXPIRED_CENSUS_REP_PM_BEAN );

            if ( null == expiredCensusReportAcknowledgementPersistenceManager )
            {
                logger.error( ErrorCodeEnum.UNABLE_TO_LOAD_FROM_APP_CONTEXT );
                throw new CensusTransformAckException( ErrorCodeEnum.UNABLE_TO_LOAD_FROM_APP_CONTEXT, EXPIRED_CENSUS_REP_PM_BEAN );
            }

            expiredCensusReportAcknowledgementPersistenceManager.sendAckForExpiredCensusReport();
        }
        catch ( Exception e )
        {
            logger.error( "Error in executeInternal " + e );
            throw new JobExecutionException( e );
        }

    }
}
