package gov.va.med.cds.mediator.xml.transform.saxonextensions;

import gov.va.med.cds.mediator.work.WorkStateInterface;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;


public class WorkStateFormattedExceptionDetailExtFunc extends ExtensionFunctionDefinition {


	private static final long serialVersionUID = -1513660667511623617L;
	private static final StructuredQName qName = new StructuredQName("", NamespaceConstant.SAXON, "get-formatted-exception-detail");
	
	@Override
	public StructuredQName getFunctionQName() {
		
		return qName;
	}

	@Override
	public SequenceType[] getArgumentTypes() {
		
		return new SequenceType[]{SequenceType.SINGLE_ITEM};

	}

	@Override
	public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
		
		return SequenceType.SINGLE_STRING;
	}
	

	@Override
	public ExtensionFunctionCall makeCallExpression() {
		
		return new ExceptionDetailCall();
	}
	
	private static class ExceptionDetailCall extends ExtensionFunctionCall{

		
		private static final long serialVersionUID = -206871408144801144L;

		@Override
		public Sequence call(XPathContext context, Sequence[] arguments)
				throws XPathException {
			
			ObjectValue objV = (ObjectValue)arguments[0];
			WorkStateInterface workstate = (WorkStateInterface)objV.getObject();
			
			
			return StringValue.makeStringValue(workstate.getFormattedExceptionDetail());
		}

	}

}
