

package gov.va.med.cds.mediator.work.hapi;


import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.work.FilterInformation;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.xml.transform.XsltHelper;

import java.util.HashMap;
import java.util.Map;


public class HL7XmlToFilterXmlWork
    extends
        AbstractHl7XmlTransformerWork
{

    private Map<String, FilterInformation> whatCodeToFilterInformationMap;

    private String wsnFilterInformation;


    public void doWork( WorkStateInterface workState )
    {

        try
        {
            HL7SupportInterface hl7Support = ( HL7SupportInterface )workState.locateWorkState( this.wsnHl7Support );
            String hl7Xml = hl7Support.toXml();

            FilterInformation filterInformation = whatCodeToFilterInformationMap.get( hl7Support.getRequestWhatCode() );
            String xsltStylesheet = filterInformation.getHl7ToVhimFilterTransform();

            Map<String, Object> parameters = new HashMap<String, Object>();
            parameters.put( "global.hl7Support", hl7Support );

            String filterXml = xsltHelper.transformMessageAsString( hl7Xml, xsltStylesheet, parameters );

            workState.registerWorkState( wsnFilterInformation, filterInformation );

            workState.registerWorkState( this.wsnVhimRequest, filterXml );
        }
        catch ( Exception e )
        {
            workState.addException( e );
        }

    }


    public void setXsltHelper( XsltHelper xsltHelper )
    {
        this.xsltHelper = xsltHelper;
    }


    public void setWhatCodeToFilterInformationMap( Map<String, FilterInformation> whatCodeToFilterInformationMap )
    {
        this.whatCodeToFilterInformationMap = whatCodeToFilterInformationMap;
    }


    public void setWsnFilterInformation( String wsnFilterInformation )
    {
        this.wsnFilterInformation = wsnFilterInformation;
    }

}
