

package gov.va.med.cds.mediator.work;


public class StringComparisonConditionalForkingWorkFlow
    extends
        AbstractConditionalForkingWorkController
{
    private enum ComparisonType
    {
        STARTS_WITH, ENDS_WITH, CONTAINS, EQUALS
    };

    private ComparisonType comparisonType;

    private String compareWithString;

    private String wsnWorkStateToCompare;


    @Override
    protected boolean evaluateCondition( WorkStateInterface workState )
    {
        String workStateString = ( String )workState.locateWorkState( wsnWorkStateToCompare );

        switch ( comparisonType )
        {
        case STARTS_WITH:
            return workStateString.startsWith( compareWithString );
        case ENDS_WITH:
            return workStateString.endsWith( compareWithString );
        case CONTAINS:
            return workStateString.contains( compareWithString );
        case EQUALS:
        default:
            return workStateString.equals( compareWithString );
        }
    }


    public void setComparisonType( String comparisonType )
    {
        this.comparisonType = ComparisonType.valueOf( comparisonType );
    }


    public void setCompareWithString( String compareWithString )
    {
        this.compareWithString = compareWithString;
    }


    public void setWsnWorkStateToCompare( String wsnWorkStateToCompare )
    {
        this.wsnWorkStateToCompare = wsnWorkStateToCompare;
    }
}
