/**
 * 
 */


package gov.va.med.cds.log4j.persistence.hibernate;


import gov.va.med.cds.log4j.ApplicationLogEvent;
import gov.va.med.cds.log4j.persistence.LoggerPersistenceManagerInterface;

import org.springframework.orm.hibernate4.HibernateTemplate;


/**
 * @author DNS   egberb
 *
 */
public class HibernateLoggerPersistenceManager
    implements
        LoggerPersistenceManagerInterface
{
    private HibernateTemplate cdsLoggerHibernateTemplate;
    private HibernateTemplate pathwaysLoggerHibernateTemplate;
    private String pathwaysAppName;

    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.log4j.persistence.LoggerPersistenceManagerInterface#persistApplicationLogEvent(gov.va.med.cds.log4j.ApplicationLogEvent)
     */
    public void persistApplicationLogEvent( ApplicationLogEvent appLogEvent )
    {
        if ( null != pathwaysAppName && pathwaysAppName.equalsIgnoreCase( appLogEvent.getAppName() ) )
        {
            pathwaysLoggerHibernateTemplate.save( appLogEvent );
        }
        else
        {
            cdsLoggerHibernateTemplate.save( appLogEvent );
        }
    }


    public void setCdsLoggerHibernateTemplate( HibernateTemplate cdsLoggerHibernateTemplate )
    {
        this.cdsLoggerHibernateTemplate = cdsLoggerHibernateTemplate;
    }


    public void setPathwaysLoggerHibernateTemplate( HibernateTemplate pathwaysLoggerHibernateTemplate )
    {
        this.pathwaysLoggerHibernateTemplate = pathwaysLoggerHibernateTemplate;
    }


    public void setPathwaysAppName( String pathwaysAppName )
    {
        this.pathwaysAppName = pathwaysAppName;
    }
  
}