

package gov.va.med.cds.hapi.extension.message;


import org.apache.commons.logging.LogFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.parser.ModelClassFactory;


// Custom class for segment group that contains custom segment groups PATIENT and ORDER_OBSERVATION
// Includes Lab specific ORDER_OBSERVATION class

/**
 * <p>
 * Represents the ORU_R01_PATIENT_RESULT Group. A Group is an ordered collection of message segments that can repeat
 * together or be optionally in/excluded together. This Group contains the following elements:
 * </p>
 * 0: ORU_R01_PATIENT (a Group object) <b>optional </b><br>
 * 1: ORU_R01_ORDER_OBSERVATION (a Group object) <b>repeating</b><br>
 */
public class ORU_R01_PATIENT_RESULT
    extends
        AbstractGroup
{

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	/**
     * Creates a new ORU_R01_PATIENT_RESULT Group.
     */
    public ORU_R01_PATIENT_RESULT( Group parent, ModelClassFactory factory )
    {
        super( parent, factory );
        try
        {
            this.add( ORU_R01_PATIENT.class, false, false );
            this.add( ORU_R01_ORDER_OBSERVATION.class, true, true );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error creating ORU_R01_PATIENT_RESULT - this is probably a bug in the source code generator.", e );
        }
    }


    /**
     * Returns ORU_R01_PATIENT (a Group object) - creates it if necessary
     */
    public ORU_R01_PATIENT getPATIENT( )
    {
        ORU_R01_PATIENT ret = null;
        try
        {
            ret = ( ORU_R01_PATIENT )this.get( "PATIENT" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns first repetition of ORU_R01_ORDER_OBSERVATION (a Group object) - creates it if necessary
     */
    public ORU_R01_ORDER_OBSERVATION getORDER_OBSERVATION( )
    {
        ORU_R01_ORDER_OBSERVATION ret = null;
        try
        {
            ret = ( ORU_R01_ORDER_OBSERVATION )this.get( "ORDER_OBSERVATION" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns a specific repetition of ORU_R01_ORDER_OBSERVATION (a Group object) - creates it if necessary throws
     * HL7Exception if the repetition requested is more than one greater than the number of existing repetitions.
     */
    public ORU_R01_ORDER_OBSERVATION getORDER_OBSERVATION( int rep )
        throws HL7Exception
    {
        return ( ORU_R01_ORDER_OBSERVATION )this.get( "ORDER_OBSERVATION", rep );
    }


    /**
     * Returns the number of existing repetitions of ORU_R01_ORDER_OBSERVATION
     */
    public int getORDER_OBSERVATIONReps( )
    {
        int reps = -1;
        try
        {
            reps = this.getAll( "ORDER_OBSERVATION" ).length;
        }
        catch ( HL7Exception e )
        {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LogFactory.getLog( this.getClass() ).error( message, e );
            throw new RuntimeException( message );
        }
        return reps;
    }
}
