package gov.va.med.cds.hapi.extension;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.validation.Validator;
import ca.uhn.hl7v2.validation.impl.NoValidation;

public class CdsHapiContext extends DefaultHapiContext{
	
	private Validator<?> validator;
	
	public CdsHapiContext(ModelClassFactory modelClassFactory){
		super(modelClassFactory);
		//setValidationRuleBuilder(builder);
		setValidationContext(new NoValidation());
		validator = new CDSCustomValidator(new NoValidation(), false);
	
	}
	
	@Override
	 public ca.uhn.hl7v2.conf.check.Validator getConformanceValidator() {
	      return new ca.uhn.hl7v2.conf.check.DefaultValidator(this);
	 }
	
	@SuppressWarnings("unchecked")
	@Override
	public synchronized <R> Validator<R> getMessageValidator() {
        if (validator == null) {
            validator = new CDSCustomValidator(new NoValidation(), false);
        }
        return (Validator<R>) validator;
    }
	
	
	/*DefaultValidationBuilder builder = new DefaultValidationBuilder() {	  
	
		private static final long serialVersionUID = 1L;

		@Override
		protected void configure() {
			super.configure();
			forAllVersions().message("ADT", "*").terser("BHS", not(empty()));
		} 
	};*/
}
