/**
* 
*/


package gov.va.med.repositories.fpds.validator;


import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.core.MultivaluedMap;


/**
 * The VprCommandRequestValidator applies some default validation logic to the queryParameters
 * and adds custom logic based on the 'command' ValidationArgument which indicates the type of request being validated
 *
 */
public class VprCommandRequestValidator
    extends
        DefaultRequestValidator
{
    public static final String SERVER = "server";
    public static final String SITE_ID = "siteId";
    public static final String LAST = "lastUpdate";
    public static final String MAX = "max";
    public static final String EXTRACT_SCHEMA = "extractSchema";
    private int maxValue;


    @Override
    public List<ValidationError> validateRequestParameters( String command, MultivaluedMap<String, String> queryParameters )
    {
        List<ValidationError> validationErrors = new ArrayList<ValidationError>();
        validationErrors = applyDefaultQueryParameterValidation( queryParameters, validationErrors );

        String server = queryParameters.getFirst( SERVER );
        if ( !StringUtils.hasText( server ) )
        {
            validationErrors.add( new InvalidParameterValidationError( SERVER, String.format( "Request parameter %s was not provided or was empty.",
                            SERVER ) ) );
        }

        if ( isSubscribeOrCancel( command ) )
        {
            String icn = StringUtils.trimTrailingWhitespace( queryParameters.getFirst( ICN ) );

            if ( !StringUtils.hasText( icn ) )
            {
                validateDfnList( queryParameters, command, validationErrors );
            }
        }

        if ( !isSubscribeOrCancel( command ) )
        {
            String last = queryParameters.getFirst( LAST );
            if ( !StringUtils.hasText( last ) )
            {
                validationErrors.add( new InvalidParameterValidationError( LAST, String.format(
                                "Request parameter %s was not provided or was empty.", LAST ) ) );
            }

            String max = queryParameters.getFirst( MAX );
            if ( !StringUtils.hasText( max ) )
            {
                validationErrors.add( new InvalidParameterValidationError( MAX, String.format( "Request parameter %s was not provided or was empty.",
                                MAX ) ) );
            }
            else
            {
                Integer maxInt = new Integer( max );
                if ( maxInt > maxValue )
                {
                    validationErrors.add( new InvalidParameterValidationError( MAX, String.format( "Request parameter %s cannot exceed: " + maxValue,
                                    MAX ) ) );
                }
            }
            String extractSchema = queryParameters.getFirst( EXTRACT_SCHEMA );
            if ( !StringUtils.hasText( extractSchema ) )
            {
                validationErrors.add( new InvalidParameterValidationError( EXTRACT_SCHEMA, String.format(
                                "Request parameter %s was not provided or was empty.", EXTRACT_SCHEMA ) ) );
            }
        }

        return validationErrors;
    }


    public boolean isSubscribeOrCancel( String command )
    {
        boolean patientCentric = true;
        if ( command.toLowerCase().contains( "updates" ) )
        {
            patientCentric = false;
        }
        return patientCentric;
    }


    public void setMaxValue( int maxValue )
    {
        this.maxValue = maxValue;
    }

}
