

package gov.va.med.cds.tools.cleanup.errorq;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/tools/cleanup/errorq/errorQCleanUpContext.xml" } )
public class ClinicalMessageHandlerTest
    extends
        AbstractBaseTest
{
    //injected by Spring
    private ErrorQMessageHandlerInterface clinicalMessageHandler;
    private JdbcTemplate hdrJdbcTemplate;

    private ResourceLoader resourceLoader = new DefaultResourceLoader();


    @Test
    @Suite( groups = { "checkintest" } )
    public void testClinicalMessageHandlerNotNull( )
    {
        assertNotNull( clinicalMessageHandler );
    }


    @Test
    public void testHandleMessage( )
        throws Exception
    {
        Resource resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrvtls.er7" );
        String hl7Message = StreamUtil.resourceToString( resource );

        EntityIdentifier recordIdentifier = new EntityIdentifier();
        recordIdentifier.setIdentity( "3508" );
        recordIdentifier.setNamespaceId( "660_120.5" );

        String messageDateTime = "20070411082611-0700";

        String returnValue = clinicalMessageHandler.handleMessage( hl7Message, "VITAL_V", recordIdentifier, messageDateTime, new ErrorQueueCleanUpLogger() );
        assertTrue( returnValue.contains( "<errorSection/>" ) );
        String requestId = returnValue
                        .substring( returnValue.indexOf( "<requestId>" ) + "<requestId>".length(), returnValue.indexOf( "</requestId>" ) );

        returnValue = clinicalMessageHandler.handleMessage( hl7Message, "VITAL_V", recordIdentifier, messageDateTime, new ErrorQueueCleanUpLogger() );
        assertTrue( returnValue.contains( "Duplicate message" ) );

        messageDateTime = "20090411082611-0700";
        returnValue = clinicalMessageHandler.handleMessage( hl7Message, "VITAL_V", recordIdentifier, messageDateTime, new ErrorQueueCleanUpLogger() );
        assertTrue( returnValue.contains( "HDRII_CONSTRAINT_VIOLATED" ) );

        cleanDB( requestId );
    }


//    @Test
//    public void testHandleBadLabMessage( )  // SJB
//        throws Exception
//    {
//        Resource resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrlabbadobx.er7" );
//        String hl7Message = StreamUtil.resourceToString( resource );
//
//        EntityIdentifier recordIdentifier = new EntityIdentifier();
//        recordIdentifier.setIdentity( "35058" );
//        recordIdentifier.setNamespaceId( "660_120.5" );
//
//        String messageDateTime = "20090411082611-0700";
//
//        String returnValue = clinicalMessageHandler.handleMessage( hl7Message, "LAB_TEST_PRM_V", recordIdentifier, messageDateTime );
//        assertTrue( returnValue.contains( "<errorSection/>" ) );
//        String requestId = returnValue
//                        .substring( returnValue.indexOf( "<requestId>" ) + "<requestId>".length(), returnValue.indexOf( "</requestId>" ) );
//
//        returnValue = clinicalMessageHandler.handleMessage( hl7Message, "LAB_TEST_PRM_V", recordIdentifier, messageDateTime );
//        assertTrue( returnValue.contains( "Duplicate message" ) );
//
//        messageDateTime = "20080411082611-0700";
//        returnValue = clinicalMessageHandler.handleMessage( hl7Message, "LAB_TEST_PRM_V", recordIdentifier, messageDateTime );
//        assertTrue( returnValue.contains( "HDRII_CONSTRAINT_VIOLATED" ) );
//
//        cleanDB( requestId );
//    }


    private void cleanDB( String requestId )
    {
        int noRows = hdrJdbcTemplate.update( "DELETE FROM VITAL_V WHERE REQUEST_ID = ?", new Object[] { requestId } );
        assertTrue( 1 == noRows );
    }


    @javax.annotation.Resource
    public void setClinicalMessageHandler( ErrorQMessageHandlerInterface clinicalMessageHandler )
    {
        this.clinicalMessageHandler = clinicalMessageHandler;
    }


    @javax.annotation.Resource
    public void setHdrJdbcTemplate( JdbcTemplate hdrJdbcTemplate )
    {
        this.hdrJdbcTemplate = hdrJdbcTemplate;
    }
}
