package gov.va.med.cds.tools.cleanup.errorq;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
public class ErrorQueueJMSTimestampUtil {
	private static Log logger = LogFactory.getLog( ErrorQueueJMSTimestampUtil.class);
	final static String formatPattern = "yyyy-MM-dd HH:mm:ss";
	final static SimpleDateFormat sdf = new SimpleDateFormat(formatPattern);
	
	/**
	 * 
	 * @param strTime input as "yyyy-MM-dd HH:mm:ss" format
	 * @return a Date object if parse succeed, otherwise return null
	 */
	public static Date parse(String strTime){
		Date jmsTimestampBegin = null;
		try {
			jmsTimestampBegin = sdf.parse(strTime);
		
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			logger.error(e.getMessage());
		}	
		return jmsTimestampBegin;
	}
	public static Date getCurrentTimeInDate(){
		Calendar c = Calendar.getInstance();
    	return c.getTime();
	}
	/**
	 * 
	 * @param date
	 * @return datetime as String in "yyyy-MM-dd HH:mm:ss" format
	 */
	public static String formatDateToString(Date date){
		return sdf.format(date);
		
	}
}
