

package gov.va.med.cds.util;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.io.IOException;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class StringUtilTest
{
    @Test
    @Suite( groups = "checkintest" )
    public void testStringArrayConcat( )
    {
        final String[] a = new String[] { "abc", "def" };
        final String[] b = new String[] { "ghi", "jkl" };

        String[] concatted = StringUtil.concat( a, b );
        assertEquals( concatted[0], "abc" );
        assertEquals( concatted[1], "def" );
        assertEquals( concatted[2], "ghi" );
        assertEquals( concatted[3], "jkl" );

        concatted = StringUtil.concat( null, b );
        assertEquals( concatted[0], "ghi" );
        assertEquals( concatted[1], "jkl" );

        concatted = StringUtil.concat( a, null );
        assertEquals( concatted[0], "abc" );
        assertEquals( concatted[1], "def" );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testStripNewlines( )
    {
        String source = "abc\ndef\nxyz";
        String expectedResult = "abcdefxyz";

        String result = StringUtil.stripNewlines( source );
        assertEquals( result, expectedResult );

        assertNull( StringUtil.stripNewlines( null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetLastStringAfterTheDelimiter( )
    {
        String source = "abc#def#xyz";
        char searchDelimiter = '#';
        String expectedResult = "xyz";

        String result = StringUtil.getLastStringAfterTheDelimiter( source, searchDelimiter );
        assertEquals( result, expectedResult );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEqualsIgnoreWhiteSpace( )
    {
        String string1 = "abcdef";
        String string2 = "abc de f";

        boolean result = StringUtil.equalsIgnoreWhiteSpace( string1, string2 );
        assertTrue( result );

        assertTrue( StringUtil.equalsIgnoreWhiteSpace( "a   bc", "abc" ) );
        assertFalse( StringUtil.equalsIgnoreWhiteSpace( "abc", "def" ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSplitAndSortsubStrings( )
    {
        String source = "def:abc:xyz:ghi";
        String expectedResult = "abc:def:ghi:xyz";

        String result = StringUtil.splitAndSortsubStrings( source, ":" );
        assertEquals( result, expectedResult );

        source = "def:c#ab:y#z#x:ghi";
        expectedResult = "ab#c:def:ghi:x#y#z";

        result = StringUtil.splitAndSortsubStrings( source, ":", "#" );
        assertEquals( result, expectedResult );
    }
    
    @Test
    @Suite( groups = "prototypetest" )
    public void testEncodeStringinBase64( )
    {
    	String assertionId1="\"Assertion-uuidc27986fc-02c6-4d5b-b7c3-c965f3c3d07f\"";
    	String assertionId2="\"Assertion-uuidc9999XXfc-02c6-4d5b-b7c3-c965f3c3d07f\"";
    	String stringToEncode = "<saml:Assertion ID="+assertionId2+" Version=\"2.0\" IssueInstant=\"2015-10-27T20:33:36Z\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">"+
			"<saml:Issuer Format=\"urn:oasis:names:tc:SAML:2.0:assertion\">https://ssoi.sts.DNS   /Issuer/SAML2</saml:Issuer>"+
			"<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">"+
				"<SignedInfo>"+
					"<CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>"+
					"<SignatureMethod Algorithm=\"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256\"/>"+
					"<Reference URI=\"#Assertion-uuidc27986fc-02c6-4d5b-b7c3-c965f3c3d07f\">"+
						"<Transforms>"+
							"<Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#enveloped-signature\"/>"+
							"<Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>"+
						"</Transforms>"+
						"<DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>"+
						"<DigestValue>zeGnAlXUVGSb2WIVn3Iw3fLertDHcDWrkC375X/DS34=</DigestValue>"+
					"</Reference>"+
				"</SignedInfo>"+
				"<SignatureValue>k+wP7V0XRUvVA55FnszqLIo2ILpWXtZf/6KHLlRnSbJx3kp9v+KalIFMawmb5xHg40ouIZgKdP4IMsj5iOTFzi2gKDojBsh32D4W0yNyzVisyMFe8ytKrAMEGsSXey/2h9DvqOyiIyAKfTUVvpChZR1kd1OxO7B4pTr3JCujRMnxRwd3ezAnNhXEOxXKGoGTkcUXSmw04yygXXI9sRYqbysnQQ8RwdFfuXwF+AN1IgOcHvM9bw76qTFVVbWhdsNKOvsfbRK5z1gvUOx3iQLKg+o5TGlOnZaO/fY7x6BRFDeIi4qxAzCIAbkGFMx/lSvuRpg8R/ZnThdFCcmvuTywtA==</SignatureValue>"+
				"<KeyInfo>"+
					"<X509Data>"+
						"<X509Certificate>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</X509Certificate>"+
						"<X509IssuerSerial>"+
							"<X509IssuerName>CN=VA Internal Subordinate CA 1, DC=va, DC=gov</X509IssuerName>"+
							"<X509SerialNumber>17169982171804267</X509SerialNumber>"+
						"</X509IssuerSerial>"+
					"</X509Data>"+
				"</KeyInfo>"+
			"</Signature>"+
			"<saml:Subject>"+
				"<saml:NameID Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:peristent\">CN=Vessels, Perry L.,OU=Contractors,OU=Remote,OU=Users,OU=Washington DC (ISW),OU=Field Offices,DC=vha,DC=med,DC=va,DC=gov</saml:NameID>"+
				"<saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:sender-vouches\">"+
					"<saml:SubjectConfirmationData Recipient=\"https://ppd.ehmp.DNS   \" Address=\"CN=Perry L. Vessels 145871 (affiliate), UID=perry.vessels@DNS   , OU=people, O=internal, DC=va, DC=gov\"/>"+
				"</saml:SubjectConfirmation>"+
			"</saml:Subject>"+
			"<saml:Conditions NotBefore=\"2015-10-27T20:28:36Z\" NotOnOrAfter=\"2015-10-27T20:48:36Z\">"+
				"<saml:AudienceRestriction>"+
					"<saml:Audience>https://*.DNS   /*</saml:Audience>"+
				"</saml:AudienceRestriction>"+
			"</saml:Conditions>"+
			"<saml:AuthnStatement AuthnInstant=\"2015-10-27T20:33:36Z\">"+
				"<saml:AuthnContext>"+
					"<saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient</saml:AuthnContextClassRef>"+
				"</saml:AuthnContext>"+
			"</saml:AuthnStatement>"+
			"<saml:AttributeStatement>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:transactionid\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>0000000000000000000000008feee30a-0744-562fdf9f-10bc-02641653</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"issueinstant\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>2015-10-27T20:33:35Z</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"authnsystem\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>SSOi</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"authenticationtype\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Indirect</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"proofingauthority\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>VA-PIV</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"assurancelevel\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>3</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"sessionScope\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>B</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:firstname\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Perry</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:lastname\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Vessels</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:secid\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>0000029756</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:ad:samaccountname\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>DNS   vessep</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"upn\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>PII                 </saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"email\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>PII                 </saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:oasis:names:tc:xspa:1.0:subject:subject-id\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Perry Vessels</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:oasis:names:tc:xacml:2.0:subject:role\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>role1</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:oasis:names:tc:xspa:1.0:subject:organization\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Department of Veterans Affairs</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:oasis:names:tc:xspa:1.0:subject:organization-id\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>urn:oid:2.16.840.1.113883.4.349</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:nhin:names:saml:homeCommunityId\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>urn:oid:2.16.840.1.113883.4.349</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"uniqueUserId\">"+
					"<saml:AttributeValue>"+
						"<SECID Name=\"urn:va:vrm:iam:secid\">0000029756</SECID>"+
					"</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:vistaid\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>508-22228439</saml:AttributeValue>"+
					"<saml:AttributeValue>590-11128439</saml:AttributeValue>"+
				"</saml:Attribute>"+
			"</saml:AttributeStatement>"+
		"</saml:Assertion>";
    	String encodedString = StringUtil.encodeStringInBase64(stringToEncode);
    }
    
    @Test
    @Suite( groups = "prototypetest" )
    public void testCompressAndEncodeStringinBase64( ) throws IOException
    {
    	String stringToCompressAndEncode = "<saml:Assertion ID=\"Assertion-uuidc27986fc-02c6-4d5b-b7c3-c965f3c3d07f\" Version=\"2.0\" IssueInstant=\"2015-10-27T20:33:36Z\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">"+
			"<saml:Issuer Format=\"urn:oasis:names:tc:SAML:2.0:assertion\">https://ssoi.sts.DNS   /Issuer/SAML2</saml:Issuer>"+
			"<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">"+
				"<SignedInfo>"+
					"<CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>"+
					"<SignatureMethod Algorithm=\"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256\"/>"+
					"<Reference URI=\"#Assertion-uuidc27986fc-02c6-4d5b-b7c3-c965f3c3d07f\">"+
						"<Transforms>"+
							"<Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#enveloped-signature\"/>"+
							"<Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>"+
						"</Transforms>"+
						"<DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>"+
						"<DigestValue>zeGnAlXUVGSb2WIVn3Iw3fLertDHcDWrkC375X/DS34=</DigestValue>"+
					"</Reference>"+
				"</SignedInfo>"+
				"<SignatureValue>k+wP7V0XRUvVA55FnszqLIo2ILpWXtZf/6KHLlRnSbJx3kp9v+KalIFMawmb5xHg40ouIZgKdP4IMsj5iOTFzi2gKDojBsh32D4W0yNyzVisyMFe8ytKrAMEGsSXey/2h9DvqOyiIyAKfTUVvpChZR1kd1OxO7B4pTr3JCujRMnxRwd3ezAnNhXEOxXKGoGTkcUXSmw04yygXXI9sRYqbysnQQ8RwdFfuXwF+AN1IgOcHvM9bw76qTFVVbWhdsNKOvsfbRK5z1gvUOx3iQLKg+o5TGlOnZaO/fY7x6BRFDeIi4qxAzCIAbkGFMx/lSvuRpg8R/ZnThdFCcmvuTywtA==</SignatureValue>"+
				"<KeyInfo>"+
					"<X509Data>"+
						"<X509Certificate>MIIHqjCCBpKgAwIBAgIHPQACACZyazANBgkqhkiG9w0BAQUFADBQMRMwEQYKCZImiZPyLGQBGRYDZ292MRIwEAYKCZImiZPyLGQBGRYCdmExJTAjBgNVBAMTHFZBIEludGVybmFsIFN1Ym9yZGluYXRlIENBIDEwHhcNMTQxMjA5MTUwMjM4WhcNMTUxMjA5MTUwMjM4WjCBpzELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAlRYMQ8wDQYDVQQHEwZBdXN0aW4xLDAqBgNVBAoTI1UuUy4gRGVwYXJ0bWVudCBvZiBWZXRlcmFucyBBZmZhaXJzMQ4wDAYDVQQLEwVWQUFGSTEZMBcGA1UEAxMQZGV2LmVhdXRoLnZhLmdvdjEhMB8GCSqGSIb3DQEJARYSZWF1dGhhZG1pbnNAdmEuZ292MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1qLPy2TCdCkaNSGs58DgGpSB6EvM9mGFTbNxcdSn+4VlZ0y0xpQtcTWlyz6LYidWP9qFmf6bRq8ah53FHAw2qkb6cwoVRDdOBBeSdsqG1OyZtUwju+XLzsJWG3t5h0J+kYOipge7X7Yp420Xs+oyYL9jboeSoJTehG0+g2CvTqroLiS6YG5u+NOTP+Ut2FCTY4cLvwR7vIrYMb3pm3BRqm4e8Wjz8BVhm/GuMdP3O6ybkcg6r9VmSXD7osq70e3iaza87vaFd9gMikRZu1JjlaUbySmY2S2QQ3IYQcwK/iPdrVIX7IjOZMsXxrK/q+ZBH7FFVdgcvgyXTXFtgmcEjwIDAQABo4IELzCCBCswHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMIICGwYDVR0RBIICEjCCAg6CEGRldi5lYXV0aC52YS5nb3aCEGludC5lYXV0aC52YS5nb3aCFGludC5wa2kuZWF1dGgudmEuZ292ghlpbnQucmVnaXN0ZXIuZWF1dGgudmEuZ292ghlpbnQuc2VydmljZXMuZWF1dGgudmEuZ292ghFpbnQuYWNjZXNzLnZhLmdvdoIRcGludC5lYXV0aC52YS5nb3aCFXBpbnQucGtpLmVhdXRoLnZhLmdvdoIacGludC5yZWdpc3Rlci5lYXV0aC52YS5nb3aCGnBpbnQuc2VydmljZXMuZWF1dGgudmEuZ292ghJwaW50LmFjY2Vzcy52YS5nb3aCEHNxYS5lYXV0aC52YS5nb3aCFHNxYS5wa2kuZWF1dGgudmEuZ292ghlzcWEucmVnaXN0ZXIuZWF1dGgudmEuZ292ghlzcWEuc2VydmljZXMuZWF1dGgudmEuZ292ghFzcWEuYWNjZXNzLnZhLmdvdoIUcHJlcHJvZC5lYXV0aC52YS5nb3aCGHByZXByb2QucGtpLmVhdXRoLnZhLmdvdoIdcHJlcHJvZC5yZWdpc3Rlci5lYXV0aC52YS5nb3aCHXByZXByb2Quc2VydmljZXMuZWF1dGgudmEuZ292gh1wcmVwcm9kLnNlcnZpY2VzLmVhdXRoLnZhLmdvdoIVcHJlcHJvZC5hY2Nlc3MudmEuZ292MB0GA1UdDgQWBBRjU7FmF0WMY8NprEeudQ5ZdurmzjAfBgNVHSMEGDAWgBTeJbRYCv2TJ9qNPR86dkt3UtlbEzCBsQYDVR0fBIGpMIGmMIGjoIGgoIGdhjBodHRwOi8vY3JsLnBraS52YS5nb3YvUEtJL0NSTC9JbnRlcm5hbFN1YkNBMS5jcmyGaWxkYXA6Ly9sZGFwLnBraS52YS5nb3YvQ049SW50ZXJuYWxTdWJDQTEsQ049Q0RQLENOPVBLSSxDTj1TZXJ2aWNlcyxEQz1WQSxEQz1HT1Y/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdDB0BggrBgEFBQcBAQRoMGYwPwYIKwYBBQUHMAKGM2h0dHA6Ly9haWEucGtpLnZhLmdvdi9QS0kvQUlBL1ZBL0ludGVybmFsU3ViQ0ExLmNlcjAjBggrBgEFBQcwAYYXaHR0cDovL29jc3AucGtpLnZhLmdvdi8wDAYDVR0TAQH/BAIwADALBgNVHQ8EBAMCBaAwPQYJKwYBBAGCNxUHBDAwLgYmKwYBBAGCNxUIgcjDM4H58AaBpZ8NhOCBCIXCqksGgduQXIewgE0CAWQCAQgwJwYJKwYBBAGCNxUKBBowGDAKBggrBgEFBQcDATAKBggrBgEFBQcDAjANBgkqhkiG9w0BAQUFAAOCAQEADugTtZgYKdYdmda/hMoFbotGwPb4cfVP8sWpR7LHd/fqTJp/CxG1WmZ3RqJNU2e4DZOyfln/xVz6nxvbrG0EthfiSHuWrUY8nldtGcN4DvAi3ZrEkBBAFUi81+Pgtz8yE5vjpH0E6TrbcZM7O34ZcjhSV+XO+ZBtR+NJfdeEg4Spoot9toaOKWzEUTvZV7DKjG57KyMLWWbqygj29OmuHXNlyBnufKGRZf4gfne87oglqnKdwSf5G1OX/QfET4MIE0o4PEHNucOOuFl9D6xj/PeSfgDqs65uRRmLlnN9Kt94xGCsbM9yyHPDBbWkxYmAKH7WVTXdpIlQ8hbM53gOsQ==</X509Certificate>"+
						"<X509IssuerSerial>"+
							"<X509IssuerName>CN=VA Internal Subordinate CA 1, DC=va, DC=gov</X509IssuerName>"+
							"<X509SerialNumber>17169982171804267</X509SerialNumber>"+
						"</X509IssuerSerial>"+
					"</X509Data>"+
				"</KeyInfo>"+
			"</Signature>"+
			"<saml:Subject>"+
				"<saml:NameID Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:peristent\">CN=Vessels, Perry L.,OU=Contractors,OU=Remote,OU=Users,OU=Washington DC (ISW),OU=Field Offices,DC=vha,DC=med,DC=va,DC=gov</saml:NameID>"+
				"<saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:sender-vouches\">"+
					"<saml:SubjectConfirmationData Recipient=\"https://ppd.ehmp.DNS   \" Address=\"CN=Perry L. Vessels 145871 (affiliate), UID=perry.vessels@DNS   , OU=people, O=internal, DC=va, DC=gov\"/>"+
				"</saml:SubjectConfirmation>"+
			"</saml:Subject>"+
			"<saml:Conditions NotBefore=\"2015-10-27T20:28:36Z\" NotOnOrAfter=\"2015-10-27T20:48:36Z\">"+
				"<saml:AudienceRestriction>"+
					"<saml:Audience>https://*.DNS   /*</saml:Audience>"+
				"</saml:AudienceRestriction>"+
			"</saml:Conditions>"+
			"<saml:AuthnStatement AuthnInstant=\"2015-10-27T20:33:36Z\">"+
				"<saml:AuthnContext>"+
					"<saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient</saml:AuthnContextClassRef>"+
				"</saml:AuthnContext>"+
			"</saml:AuthnStatement>"+
			"<saml:AttributeStatement>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:transactionid\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>0000000000000000000000008feee30a-0744-562fdf9f-10bc-02641653</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"issueinstant\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>2015-10-27T20:33:35Z</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"authnsystem\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>SSOi</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"authenticationtype\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Indirect</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"proofingauthority\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>VA-PIV</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"assurancelevel\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>3</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"sessionScope\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>B</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:firstname\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Perry</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:lastname\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Vessels</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:secid\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>0000029756</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:ad:samaccountname\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>DNS   vessep</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"upn\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>PII                 </saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"email\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>PII                 </saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:oasis:names:tc:xspa:1.0:subject:subject-id\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Perry Vessels</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:oasis:names:tc:xacml:2.0:subject:role\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>role1</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:oasis:names:tc:xspa:1.0:subject:organization\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>Department of Veterans Affairs</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:oasis:names:tc:xspa:1.0:subject:organization-id\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>urn:oid:2.16.840.1.113883.4.349</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:nhin:names:saml:homeCommunityId\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>urn:oid:2.16.840.1.113883.4.349</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"uniqueUserId\">"+
					"<saml:AttributeValue>"+
						"<SECID Name=\"urn:va:vrm:iam:secid\">0000029756</SECID>"+
					"</saml:AttributeValue>"+
				"</saml:Attribute>"+
				"<saml:Attribute Name=\"urn:va:vrm:iam:vistaid\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified\">"+
					"<saml:AttributeValue>508-22228439</saml:AttributeValue>"+
					"<saml:AttributeValue>590-11128439</saml:AttributeValue>"+
				"</saml:Attribute>"+
			"</saml:AttributeStatement>"+
		"</saml:Assertion>";
    	String encodedCompressedString = StringUtil.compressAndEncodeStringInBase64(stringToCompressAndEncode);
    }
}
