package gov.va.med.cds.registry;

import static org.junit.Assert.assertNotNull;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Service;

import junit.framework.Assert;

import org.apache.ws.scout.registry.ConnectionFactoryImpl;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRUtilityTest {
	
	private static final JAXRUtility jaxrUtil = new JAXRUtility();
	
	@BeforeClass
	public static void setupOnce()
	{
		Properties connectionProperties = new Properties();
//		connectionProperties.setProperty("javax.xml.registry.queryManagerURL", "http://islvhdwls06.DNS   .med.DNS   :7101/uddi/uddilistener");
//		connectionProperties.setProperty("javax.xml.registry.lifeCycleManagerURL", "http://islvhdwls06.DNS   .med.DNS   :7101/uddi/uddilistener");
		connectionProperties.setProperty("javax.xml.registry.queryManagerURL", "http://IP              /uddi/uddilistener");
		connectionProperties.setProperty("javax.xml.registry.lifeCycleManagerURL", "http://IP              /uddi/uddilistener");
		
		jaxrUtil.setConnectionProperties(connectionProperties);
		jaxrUtil.setFactoryClass(ConnectionFactoryImpl.class);
		PasswordAuthentication passwdAuth = new PasswordAuthentication("weblogic", "weblogic4dev".toCharArray());
        Set<PasswordAuthentication> creds = new HashSet<PasswordAuthentication>();
        creds.add(passwdAuth);
        jaxrUtil.setCredentials(creds);
	}

	@Test(expected=JAXRException.class)
	public void testFindServiceOrganizationUnknown() throws JAXRException {
		URL endpoint = jaxrUtil.findServiceEndpoint("foo", "bar");
		assertNotNull(endpoint);
	}
	
//	@Test
	public void testFindServiceEndpointDev1CDS() throws JAXRException {
		URL endpoint = jaxrUtil.findServiceEndpoint("HDR", "DEV1_CDSN3 - CDS Java SOAP");
		assertNotNull(endpoint);
	}
	
//	@Test
	public void testFindServiceEndpointDev1TFS() throws JAXRException {
		URL endpoint = jaxrUtil.findServiceEndpoint("HDR", "DEV1_TAFS");
		assertNotNull(endpoint);
	}
	
//	@Test
	public void testFindServiceEndpointDev1PSIM() throws JAXRException {
		URL endpoint = jaxrUtil.findServiceEndpoint("HDR", "DEV_IDM");
		assertNotNull(endpoint);
	}
	
//	@Test
	public void testFindServiceEndpointDev1Mediator() throws JAXRException {
		URL endpoint = jaxrUtil.findServiceEndpoint("HDR Dev1 Env", "MediatorService");
		assertNotNull(endpoint);
	}
	
//	@Test
	public void testFindMediatorServices() throws JAXRException {
		
		Collection<Service> service = jaxrUtil.findServices("HDR Dev1 Env", "MediatorService");
		assertNotNull(service);
		
	}
	
//	@Test
//	public void testFindClassificationSchemeByName() throws JAXRException
//	{
//		Classification classification = jaxrUtil.findClassificationSchemeByName("ObjectType");
//		assertNotNull(classification);
//	}
//	
//	@Test(expected=JAXRException.class)
	public void testFindServiceEndpointDev1Unknown() throws JAXRException {
		jaxrUtil.findServiceEndpoint("HDR", "UnknownService");
		Assert.fail("Shouldn't make it this far for an unknown service.");
	}
	
	//   573ab7e0-a867-11e2-9227-08dd1b009227  570af550-a867-11e2-9227-08dd1b009227
//	@Test
	public void testFindServiceEndpointDev1ByServiceBindingId() throws JAXRException {
		Service service = (Service)jaxrUtil.findByIdAndType("581646fe-c49a-41a6-b6ae-97b4869e8916", LifeCycleManager.SERVICE);
		URL endpoint = jaxrUtil.serviceToServiceEndpointURL(service);
		assertNotNull(endpoint);
	}
	
//	@Test
	public void testRegisterService() throws JAXRException 
	{
		String endpointUrl = "http://IP              /dummy/goDummy?wsdl";
		Service service = jaxrUtil.registerService("HDR Dev1 Env", "DEV1_Dummy", endpointUrl);
		assertNotNull(service);
		
		Service service2 = (Service)jaxrUtil.findByIdAndType(service.getKey().getId(), LifeCycleManager.SERVICE);
		URL serviceBindingUrl = jaxrUtil.serviceToServiceEndpointURL(service2);
		Assert.assertEquals(endpointUrl, serviceBindingUrl.toExternalForm());
	}
	
}
