

package gov.va.med.cds.monitor.util;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.monitor.VdmFilterMethodMetrics;

import org.junit.Test;


import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class VdmFilterMethodMetricsTest
{
    private VdmFilterMethodMetrics vdmFilterMethodMetrics;

    private long methodCount = 0;
    private long methodElapsedTime = 0;
    private long minElapsedTime = Long.MAX_VALUE;
    private long maxElapsedTime = Long.MIN_VALUE;
    private double averageElapsedTime = 0.0d;
    private double transactionsPerSecond = 0.0d;


    @Test
    @Suite( groups = "checkintest" )
    public void testEnableMetrics( )
    {
        vdmFilterMethodMetrics = new VdmFilterMethodMetrics();
        vdmFilterMethodMetrics.enableMetrics();

        assertTrue( vdmFilterMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, vdmFilterMethodMetrics.getVdmFilterTransactions() );
        assertEquals( methodElapsedTime, vdmFilterMethodMetrics.getVdmFilterElapsedTime() );
        assertEquals( transactionsPerSecond, vdmFilterMethodMetrics.getVdmFilterTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, vdmFilterMethodMetrics.getVdmFilterAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, vdmFilterMethodMetrics.getVdmFilterMaxElapsedTime() );
        assertEquals( minElapsedTime, vdmFilterMethodMetrics.getVdmFilterMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetSingleMethodElapsedTime( )
    {
        long elapsedTime = 100L;
        long methodCount = 1;
        long methodElapsedTime = elapsedTime;
        long minElapsedTime = elapsedTime;
        long maxElapsedTime = elapsedTime;
        double averageElapsedTime = elapsedTime;
        double transactionsPerSecond = 10.0d;

        vdmFilterMethodMetrics = new VdmFilterMethodMetrics();
        vdmFilterMethodMetrics.enableMetrics();
        vdmFilterMethodMetrics.setSingleMethodElapsedTime( elapsedTime );

        assertTrue( vdmFilterMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, vdmFilterMethodMetrics.getVdmFilterTransactions() );
        assertEquals( methodElapsedTime, vdmFilterMethodMetrics.getVdmFilterElapsedTime() );
        assertEquals( transactionsPerSecond, vdmFilterMethodMetrics.getVdmFilterTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, vdmFilterMethodMetrics.getVdmFilterAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, vdmFilterMethodMetrics.getVdmFilterMaxElapsedTime() );
        assertEquals( minElapsedTime, vdmFilterMethodMetrics.getVdmFilterMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisableMetrics( )
    {
        vdmFilterMethodMetrics = new VdmFilterMethodMetrics();
        vdmFilterMethodMetrics.enableMetrics();

        assertTrue( vdmFilterMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, vdmFilterMethodMetrics.getVdmFilterTransactions() );
        assertEquals( methodElapsedTime, vdmFilterMethodMetrics.getVdmFilterElapsedTime() );
        assertEquals( transactionsPerSecond, vdmFilterMethodMetrics.getVdmFilterTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, vdmFilterMethodMetrics.getVdmFilterAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, vdmFilterMethodMetrics.getVdmFilterMaxElapsedTime() );
        assertEquals( minElapsedTime, vdmFilterMethodMetrics.getVdmFilterMinElapsedTime() );

        vdmFilterMethodMetrics.disableMetrics();
        assertFalse( vdmFilterMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, vdmFilterMethodMetrics.getVdmFilterTransactions() );
        assertEquals( methodElapsedTime, vdmFilterMethodMetrics.getVdmFilterElapsedTime() );
        assertEquals( transactionsPerSecond, vdmFilterMethodMetrics.getVdmFilterTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, vdmFilterMethodMetrics.getVdmFilterAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, vdmFilterMethodMetrics.getVdmFilterMaxElapsedTime() );
        assertEquals( minElapsedTime, vdmFilterMethodMetrics.getVdmFilterMinElapsedTime() );
    }
}
