

package gov.va.med.cds.template;


import gov.va.med.cds.exception.AbstractCdsBaseException;
import gov.va.med.cds.exception.ErrorCodeEnum;


/**
 * Handles exceptions thrown by template service classes.
 * 
 */
public class TemplateServiceException
    extends
        AbstractCdsBaseException
{
    private static final long serialVersionUID = 4395684980079836441L;


    /**
     * Parent constructor for template service exception
     * 
     * @param errorCode - enum to populate and return to caller.
     * @param cause - exception thrown in hibernate persistence module.
     * @param customMsg - list of messages to be integrated into exception message.
     */
    public TemplateServiceException( ErrorCodeEnum errorCode, Throwable cause, String... customMsg )
    {
        super( errorCode, cause, customMsg );
    }

}
