

package gov.va.med.cds.exceptionframework;


import gov.va.med.cds.exception.ErrorCodeEnum;


/**
 * Holds the exception related information that is needed to population the error section of the response xml.
 *
 */
public class ExceptionInfo
{
    private Throwable exception = null;
    private RuntimeException runtimeException = null;
    private String exceptionMessage = null;
    private ErrorCodeEnum errorCode = null;
    private String clientMessage = null;
    private LoggingSeverity loggingSeverity = null;


    /**
     * Gets the user friendly message created based on the exception message to be shown in the response xml.
     *
     * @return User friendly message.
     */
    public String getClientMessage( )
    {
        return clientMessage;
    }


    /**
     * Sets the user friendly message created based on the exception message to be shown in the response xml.
     *
     * @param clientMessage - user friendly message.
     */
    public void setClientMessage( String clientMessage )
    {
        this.clientMessage = clientMessage;
    }


    /**
     * Gets the error code enum.
     *
     * @return Error code enum.
     */
    public ErrorCodeEnum getErrorCode( )
    {
        return errorCode;
    }


    /**
     * Sets the error code enum.
     *
     * @param errorCode Error code enum.
     */
    public void setErrorCode( ErrorCodeEnum errorCode )
    {
        this.errorCode = errorCode;
    }


    /**
     * Gets the exception.
     *
     * @return Exception that is thrown.
     */
    public Throwable getException( )
    {
        return exception;
    }


    /**
     * Sets the exception.
     *
     * @param exception that is thrown.
     */
    public void setException( Throwable exception )
    {
        this.exception = exception;
    }


    /**
     * Gets the loggingSeverity of the exception that is logged.
     *
     * @return Returns loggingSeverity.
     */
    public LoggingSeverity getLoggingSeverity( )
    {
        return loggingSeverity;
    }


    /**
     * Sets the loggingSeverity of the exception that is logged.
     *
     * @param loggingSeverity logging severity.
     */
    public void setLoggingSeverity( LoggingSeverity loggingSeverity )
    {
        this.loggingSeverity = loggingSeverity;
    }


    /**
     * Gets the exceptionMessage of the exception.
     *
     * @return Exception Message.
     */
    public String getExceptionMessage( )
    {
        return exceptionMessage;
    }


    /**
     * Sets the exceptionMessage of the exception.
     *
     * @param exceptionMessage exception Message.
     */
    public void setExceptionMessage( String exceptionMessage )
    {
        this.exceptionMessage = exceptionMessage;
    }


    public void setRuntimeException( RuntimeException runtimeException )
    {
        this.runtimeException = runtimeException;
    }


    public RuntimeException getRuntimeException( )
    {
        return runtimeException;
    }
}
