

package gov.va.med.cds.client.proxy;


import java.nio.ByteBuffer;
import java.util.Properties;


public class MllpDnsSocketBasedClientProxy
    extends
        AbstractMllpSocketBasedClientProxy

{
    public ByteBuffer sendMessage( ByteBuffer message, Properties properties )
    {
        String dnsName = properties.getProperty( NetworkClientProxyInterface.PROP_DNS_NAME );
        if ( dnsName == null || dnsName.length() == 0 )
        {
            throw new IllegalArgumentException( "DNS name is required by MllpDnsSocketBasedClientProxy." );
        }
        return sendMessage( message, dnsName );
    }
}
