package gov.va.med.cds.audit.persistence;

import gov.va.med.cds.audit.TemplateIdWrapper;

public class HaAuditClobStore
{
    private Long auditId;
    private String requestId;
    private String hl7Clob;
    private String facilityId;
    private String messageDateTime;
    private String messageType;
    private TemplateIdWrapper templateId = new TemplateIdWrapper();
    private String clientIdentifier;
    private String clientRequestInitiationTime;


    public HaAuditClobStore( )
    {
    }


    public HaAuditClobStore( String requestId, String facilityId, String hl7Clob, String messageDateTime, String messageType, String aTemplateId )
    {
        this( requestId, facilityId, hl7Clob, messageDateTime, messageType, aTemplateId, null );
    }


    public HaAuditClobStore( String requestId, String facilityId, String hl7Clob, String messageDateTime, String messageType, String aTemplateId,
                    String aClientId )
    {
        setRequestId( requestId );
        setFacilityId( facilityId );
        setHl7Clob( hl7Clob );
        setMessageDateTime( messageDateTime );
        setMessageType( messageType );
        setTemplateId( aTemplateId );
        setClientIdentifier( aClientId );
    }


    public HaAuditClobStore( String requestId, String facilityId, String hl7Clob, String messageDateTime, String messageType, String aTemplateId,
                    String aClientId, String clientRequestInitiationTime )
    {
        setRequestId( requestId );
        setFacilityId( facilityId );
        setHl7Clob( hl7Clob );
        setMessageDateTime( messageDateTime );
        setMessageType( messageType );
        setTemplateId( aTemplateId );
        setClientIdentifier( aClientId );
        setClientRequestInitiationTime( clientRequestInitiationTime );
    }


    public String getRequestId( )
    {
        return requestId;
    }


    public void setRequestId( String requestId )
    {
        this.requestId = requestId;
    }


    public Long getAuditId( )
    {
        return auditId;
    }


    public String getFacilityId( )
    {
        return facilityId;
    }


    public void setFacilityId( String facilityId )
    {
        this.facilityId = facilityId;
    }


    public void setHl7Clob( String hl7Clob )
    {
        this.hl7Clob = hl7Clob;
    }


    public String getHl7Clob( )
    {
        return hl7Clob;
    }


    public void setMessageDateTime( String messageDateTime )
    {
        this.messageDateTime = messageDateTime;
    }


    public void setMessageType( String messageType )
    {
        this.messageType = messageType;
    }


    public String getMessageDateTime( )
    {
        return messageDateTime;
    }


    public String getMessageType( )
    {
        return messageType;
    }


    public String getClientIdentifier( )
    {
        return clientIdentifier;
    }


    public void setClientIdentifier( String clientIdentifier )
    {
        this.clientIdentifier = clientIdentifier;
    }


    public String getTemplateId( )
    {
        return templateId.getTemplateId();
    }


    public void setTemplateId( String templateId )
    {
        this.templateId.setTemplateId( templateId );
    }


    public TemplateIdWrapper getTemplateIdWrapper( )
    {
        return templateId;
    }


    public void setTemplateIdWrapper( TemplateIdWrapper aTemplateIdWrapper )
    {
        templateId = aTemplateIdWrapper;
    }


    public String getClientRequestInitiationTime( )
    {
        return clientRequestInitiationTime;
    }


    public void setClientRequestInitiationTime( String clientRequestInitiationTime )
    {
        this.clientRequestInitiationTime = clientRequestInitiationTime;
    }
}
