/**
 * 
 */
package gov.va.med.cds.audit;

import java.util.Date;

/**
 * @author DNS   egberb
 *
 */
public class CdsVimReadAuditFactory
    implements
        ReadAuditFactoryInteface
{

    /* (non-Javadoc)
     * @see gov.va.med.cds.audit.ReadAuditFactoryInteface#createAuditLog(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, long, java.lang.String)
     */
    @Override
    public AbstractAuditLog createAuditLog( String clientId, String templateId, String filterRequest, String filterId, String requestId,
                    long startTime, String response )
    {
        VhimReadResponseAuditLog auditLog = new VhimReadResponseAuditLog();
        auditLog.setEndTime( System.currentTimeMillis() );
        auditLog.setLocalTime( new Date() );
        auditLog.setClientId( clientId );
        auditLog.setTemplateId( templateId );
        auditLog.setFilterRequest( filterRequest );
        auditLog.setFilterId( filterId );
        auditLog.setRequestId( requestId );
        auditLog.setResponse( response );
        auditLog.setSendingApplication( "<<SendingApplication>>" );
        auditLog.setStartTime( startTime );
        
        return auditLog;
    }

}
