/******************************************************************************
   NAME:       load_QUESTIONNAIRE_RESULT.sql
   PURPOSE:    This script will create QUESTIONNAIRE_RESULT records
   ADDITIONAL INFORMATION:

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        6/4/2012    J. Markham       Initial release.
   1.1        1/31/2013   M. Jacobsen      hard code facility_identity, facility_name and facility_assigning_authority

******************************************************************************/
TRUNCATE TABLE questionnaire_result;
TRUNCATE TABLE questionnaire_result_hstry;

ALTER TRIGGER questionnaire_result_bur_trg DISABLE;

DECLARE
   v_fixed_date			                     DATE                       := TO_DATE('12-02-08 17:07:06','MM-DD-YY HH24:MI:SS');

BEGIN
   --dbms_output.enable(null);
   --dbms_output.put_line (CHR(10));
   --dbms_output.put_line ('Load QUESTIONNAIRE_RESULT Start Time := '|| TO_CHAR (SYSDATE, 'MM/DD/YY HH:MI:SS'));

   DBMS_RANDOM.SEED(42); -- add seeding for same random numbers.

--loop thru x times
   FOR z IN 1 .. &&1
   LOOP
      INSERT INTO questionnaire_result
         (
            questionnaire_result_id,                                             /* NOT NULL NUMBER                     */
            patient_identity,                                                    /* NOT NULL VARCHAR2(256)              */
            patient_assigning_facility,                                          /*          VARCHAR2(256)              */
            patient_assigning_authority,                                         /*          VARCHAR2(256)              */
            request_id,                                                          /*          VARCHAR2(256)              */
            record_version,                                                      /*          NUMBER                     */
            message_insertion_time,                                              /*          TIMESTAMP(6)               */
            patient_name_prefix,                                                 /*          VARCHAR2(4000)             */
            patient_name_given,                                                  /*          VARCHAR2(4000)             */
            patient_name_middle,                                                 /*          VARCHAR2(4000)             */
            patient_name_family,                                                 /*          VARCHAR2(4000)             */
            patient_name_suffix,                                                 /*          VARCHAR2(4000)             */
            patient_name_title,                                                  /*          VARCHAR2(4000)             */
            initiating_system,                                                   /*          VARCHAR2(4000)             */
            facility_identity,                                                   /*          VARCHAR2(256)              */
            facility_name,                                                       /*          VARCHAR2(256)              */
            facility_assigning_authority,                                        /*          VARCHAR2(256)              */
            approved_flag,                                                       /*          VARCHAR2(256)              */
            aprv_by_practitioner_comments,                                       /*          VARCHAR2(4000)             */
            aprv_by_person_identity,                                             /*          VARCHAR2(256)              */
            aprv_by_person_asgning_fclt,                                         /*          VARCHAR2(256)              */
            aprv_by_person_asgning_auth,                                         /*          VARCHAR2(256)              */
            aprv_by_practitioner_id_s,                                           /*          VARCHAR2(256)              */
            aprv_by_name_prefix,                                                 /*          VARCHAR2(4000)             */
            aprv_by_name_given,                                                  /*          VARCHAR2(4000)             */
            aprv_by_name_middle,                                                 /*          VARCHAR2(4000)             */
            aprv_by_name_family,                                                 /*          VARCHAR2(4000)             */
            aprv_by_name_suffix,                                                 /*          VARCHAR2(4000)             */
            aprv_by_name_title,                                                  /*          VARCHAR2(4000)             */
            auth_practitioner_comments,                                          /*          VARCHAR2(4000)             */
            auth_person_identity,                                                /*          VARCHAR2(256)              */
            auth_person_asgning_facility,                                        /*          VARCHAR2(256)              */
            auth_person_asgning_authority,                                       /*          VARCHAR2(256)              */
            auth_practitioner_id_src_tbl,                                        /*          VARCHAR2(256)              */
            auth_name_prefix,                                                    /*          VARCHAR2(4000)             */
            auth_name_given,                                                     /*          VARCHAR2(4000)             */
            auth_name_middle,                                                    /*          VARCHAR2(4000)             */
            auth_name_family,                                                    /*          VARCHAR2(4000)             */
            auth_name_suffix,                                                    /*          VARCHAR2(4000)             */
            auth_name_title,                                                     /*          VARCHAR2(4000)             */
            detail_xml,                                                          /*          SYS.XMLTYPE                */
            recordidentifier_identity,                                           /*          VARCHAR2(256)              */
            recordidentifier_namespaceid,                                        /*          VARCHAR2(256)              */
            recordidentifier_universalid,                                        /*          VARCHAR2(256)              */
            recordidentifier_universtyp,                                         /*          VARCHAR2(256)              */
            documentidentifier_identity,                                         /*          VARCHAR2(256)              */
            documentidentifier_namespaceid,                                      /*          VARCHAR2(256)              */
            documentidentifier_universalid,                                      /*          VARCHAR2(256)              */
            documentidentifier_universtyp,                                       /*          VARCHAR2(256)              */
            document_type,                                                       /*          VARCHAR2(4000)             */
            record_update_dt,                                                    /* NOT NULL VARCHAR2(256)              */
            record_update_dt_utc,                                                /* NOT NULL TIMESTAMP(6)               */
            date_modified__dt,                                                   /*          VARCHAR2(256)              */
            date_modified__dt_utc,                                               /*          TIMESTAMP(6)               */
            aprv_by_practitioner_dt,                                             /*          VARCHAR2(256)              */
            aprv_by_practitioner_dt_utc,                                         /*          TIMESTAMP(6)               */
            auth_practitioner_dt,                                                /*          VARCHAR2(256)              */
            auth_practitioner_dt_utc                                             /*          TIMESTAMP(6)               */
         )
      VALUES
         (
            questionnaire_result_id_seq.NEXTVAL,                                 /* QUESTIONNAIRE_RESULT_ID                               NOT NULL NUMBER                           */
            'Patient ' || TO_CHAR(TRUNC(dbms_random.value(1,21)), '000'),        /* PATIENT_IDENTITY                                      NOT NULL VARCHAR2(256)                    */
            'Facility ' || TO_CHAR(TRUNC(dbms_random.value(1,21)), '000'),       /* PATIENT_ASSIGNING_FACILITY                                     VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* PATIENT_ASSIGNING_AUTHORITY                                    VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* REQUEST_ID                                                     VARCHAR2(256)                    */
            dbms_random.value,                                                   /* RECORD_VERSION                                                 NUMBER                           */
            TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365)),             /* MESSAGE_INSERTION_TIME                                         TIMESTAMP(6)                     */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* PATIENT_NAME_PREFIX                                            VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* PATIENT_NAME_GIVEN                                             VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* PATIENT_NAME_MIDDLE                                            VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* PATIENT_NAME_FAMILY                                            VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* PATIENT_NAME_SUFFIX                                            VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* PATIENT_NAME_TITLE                                             VARCHAR2(4000)                   */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* INITIATING_SYSTEM                                              VARCHAR2(4000)                   */
--1.1            'Facility ' || TO_CHAR(TRUNC(dbms_random.value(1,21)), '000'),       /* FACILITY_IDENTITY                                              VARCHAR2(256)                    */
            '101',
--1.1            'Facility ' || TO_CHAR(TRUNC(dbms_random.value(1,21)), '000'),       /* FACILITY_NAME                                                  VARCHAR2(256)                    */
            'TEST FACILITY NAME',
--1.1            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* FACILITY_ASSIGNING_AUTHORITY                                   VARCHAR2(256)                    */
            'USVHA',
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* APPROVED_FLAG                                                  VARCHAR2(256)                    */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_PRACTITIONER_COMMENTS                                  VARCHAR2(4000)                   */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_PERSON_IDENTITY                                        VARCHAR2(256)                    */
            'Facility ' || TO_CHAR(TRUNC(dbms_random.value(1,21)), '000'),       /* APRV_BY_PERSON_ASGNING_FCLT                                    VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_PERSON_ASGNING_AUTH                                    VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_PRACTITIONER_ID_S                                      VARCHAR2(256)                    */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_NAME_PREFIX                                            VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_NAME_GIVEN                                             VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_NAME_MIDDLE                                            VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_NAME_FAMILY                                            VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_NAME_SUFFIX                                            VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* APRV_BY_NAME_TITLE                                             VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* AUTH_PRACTITIONER_COMMENTS                                     VARCHAR2(4000)                   */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* AUTH_PERSON_IDENTITY                                           VARCHAR2(256)                    */
            'Facility ' || TO_CHAR(TRUNC(dbms_random.value(1,21)), '000'),       /* AUTH_PERSON_ASGNING_FACILITY                                   VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* AUTH_PERSON_ASGNING_AUTHORITY                                  VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* AUTH_PRACTITIONER_ID_SRC_TBL                                   VARCHAR2(256)                    */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* AUTH_NAME_PREFIX                                               VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* AUTH_NAME_GIVEN                                                VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* AUTH_NAME_MIDDLE                                               VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* AUTH_NAME_FAMILY                                               VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* AUTH_NAME_SUFFIX                                               VARCHAR2(4000)                   */
            dbms_random.string('A',TRUNC(dbms_random.value(1,256))),             /* AUTH_NAME_TITLE                                                VARCHAR2(4000)                   */
            NULL,                                                                /* DETAIL_XML                                                     SYS.XMLTYPE                      */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* RECORDIDENTIFIER_IDENTITY                                      VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* RECORDIDENTIFIER_NAMESPACEID                                   VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* RECORDIDENTIFIER_UNIVERSALID                                   VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* RECORDIDENTIFIER_UNIVERSTYP                                    VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* DOCUMENTIDENTIFIER_IDENTITY                                    VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* DOCUMENTIDENTIFIER_NAMESPACEID                                 VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* DOCUMENTIDENTIFIER_UNIVERSALID                                 VARCHAR2(256)                    */
            dbms_random.string('U',TRUNC(dbms_random.value(1,256))),             /* DOCUMENTIDENTIFIER_UNIVERSTYP                                  VARCHAR2(256)                    */
            --dbms_random.string('U',TRUNC(dbms_random.value(1,256))),           /* DOCUMENT_TYPE                                                  VARCHAR2(4000)                   */
            TRUNC(dbms_random.value(1,10)),                                      /* DOCUMENT_TYPE                                                  VARCHAR2(4000)                   */
            TO_CHAR(TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365))),    /* RECORD_UPDATE_DT                                      NOT NULL VARCHAR2(256)                    */
            TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365)),             /* RECORD_UPDATE_DT_UTC                                  NOT NULL TIMESTAMP(6)                     */
            TO_CHAR(TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365))),    /* DATE_MODIFIED__DT                                              VARCHAR2(256)                    */
            TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365)),             /* DATE_MODIFIED__DT_UTC                                          TIMESTAMP(6)                     */
            TO_CHAR(TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365))),    /* APRV_BY_PRACTITIONER_DT                                        VARCHAR2(256)                    */
            TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365)),             /* APRV_BY_PRACTITIONER_DT_UTC                                    TIMESTAMP(6)                     */
            TO_CHAR(TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365))),    /* AUTH_PRACTITIONER_DT                                           VARCHAR2(256)                    */
            TO_TIMESTAMP(v_fixed_date + dbms_random.value(0,5*365))              /* AUTH_PRACTITIONER_DT_UTC                                       TIMESTAMP(6)                     */
      );

       COMMIT;
   END LOOP;

   --dbms_output.put_line ('Load QUESTIONNAIRE_RESULT Stop Time :=  ' || TO_CHAR (SYSDATE, 'MM/DD/YY HH:MI:SS'));
END;
/

UNDEFINE 1

---------------------------------------------------------------
-- 'Hairy_Cell_(B-Cell)_Leukemia_Medical_Summary'
---------------------------------------------------------------
DECLARE
   v_text                           VARCHAR2(4000);
BEGIN
   --dbms_output.enable(NULL);

   --dbms_output.put_line(CHR(10));
   --dbms_output.put_line('=======================================================================');
   --dbms_output.put_line('Updating DOCUMENT_TYPE 1');
   --dbms_output.put_line('=======================================================================');

   v_text := NULL;
   v_text := v_text || '<gov.va.agentorange.fasttrack.model.dbq.luk.HairyCellLeukemia>'                                               ;
   v_text := v_text || '<id>1650</id>'                                                                                             ;
   v_text := v_text || '<version>0</version>'                                                                                      ;
   v_text := v_text || '<dateCreated>2011-07-19 11:03:53.934 EDT</dateCreated>'                                                    ;
   v_text := v_text || '<dateModified reference="../dateCreated"/>'                                                                ;
   v_text := v_text || '<formType>FORM_TYPE_DBQ_LUK</formType>'                                                                    ;
   v_text := v_text || '<vetSsn>897345783</vetSsn>'                                                                                ;
   v_text := v_text || '<documentStatusType>COMPLETE</documentStatusType>'                                                         ;
   v_text := v_text || '<documentChannelType>VA</documentChannelType>'                                                             ;
   v_text := v_text || '<createdBy>csmyth</createdBy>'                                                                             ;
   v_text := v_text || '<webFormType>LUK_DBQ_MED_SUMMARY</webFormType>'                                                            ;
   v_text := v_text || '<dbqPurpose>MEDICAL_SUMMARY</dbqPurpose>'                                                                  ;
   v_text := v_text || '<sourcesOfInformation>LUK Source</sourcesOfInformation>'                                                   ;
   v_text := v_text || '<veteranFirstName>Delete</veteranFirstName>'                                                               ;
   v_text := v_text || '<veteranLastName>Delete</veteranLastName>'                                                                 ;
   v_text := v_text || '<impactsAbilityToWork>false</impactsAbilityToWork>'                                                        ;
   v_text := v_text || '<remarks></remarks>'                                                                                       ;
   v_text := v_text || '<dateSigned reference="../dateCreated"/>'                                                                  ;
   v_text := v_text || '<diagnoses class="org.hibernate.collection.PersistentBag">'                                                ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                         ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.luk.HairyCellLeukemia" reference="../.."/>'         ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                             ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.diagnoses</role>'                             ;
   v_text := v_text || '  <key class="long">1650</key>'                                                                            ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                    ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                          ;
   v_text := v_text || '  <bag/>'                                                                                                  ;
   v_text := v_text || '</diagnoses>'                                                                                              ;
   v_text := v_text || '<medications class="org.hibernate.collection.PersistentBag">'                                              ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                         ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.luk.HairyCellLeukemia" reference="../.."/>'         ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                             ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.medications</role>'                           ;
   v_text := v_text || '  <key class="long">1650</key>'                                                                            ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                    ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                          ;
   v_text := v_text || '  <bag/>'                                                                                                  ;
   v_text := v_text || '</medications>'                                                                                            ;
   v_text := v_text || '<hasLeukemia>true</hasLeukemia>'                                                                           ;
   v_text := v_text || '<statusOfTreatment>COMPLETED</statusOfTreatment>'                                                          ;
   v_text := v_text || '<dateOfTreatment>2011-07-11 00:00:00.0 EDT</dateOfTreatment>'                                              ;
   v_text := v_text || '<isDiseaseActive>false</isDiseaseActive>'                                                                  ;
   v_text := v_text || '<hasComplicationsFromTreatments>true</hasComplicationsFromTreatments>'                                     ;
   v_text := v_text || '<hasComplicationsFromTransfusion>false</hasComplicationsFromTransfusion>'                                  ;
   v_text := v_text || '<hasComplicationsFromRecurringInfections>false</hasComplicationsFromRecurringInfections>'                  ;
   v_text := v_text || '<hasComplicationsRelatedToAnemia>true</hasComplicationsRelatedToAnemia>'                                   ;
   v_text := v_text || '<hasAsymptomaticAnemia>false</hasAsymptomaticAnemia>'                                                      ;
   v_text := v_text || '<requiresContinuousMeds>true</requiresContinuousMeds>'                                                     ;
   v_text := v_text || '<requiresBoneMarrowTransplant>false</requiresBoneMarrowTransplant>'                                        ;
   v_text := v_text || '<hasSymptomaticAnemia>false</hasSymptomaticAnemia>'                                                        ;
   v_text := v_text || '<hasWeakness>false</hasWeakness>'                                                                          ;
   v_text := v_text || '<hasEasyFatigability>false</hasEasyFatigability>'                                                          ;
   v_text := v_text || '<hasDyspneaOnMildExertion>false</hasDyspneaOnMildExertion>'                                                ;
   v_text := v_text || '<hasLightHeadedness>false</hasLightHeadedness>'                                                            ;
   v_text := v_text || '<hasShortnessOfBreath>false</hasShortnessOfBreath>'                                                        ;
   v_text := v_text || '<hasSyncope>false</hasSyncope>'                                                                            ;
   v_text := v_text || '<hasCardiomegaly>false</hasCardiomegaly>'                                                                  ;
   v_text := v_text || '<hasTachycardia>false</hasTachycardia>'                                                                    ;
   v_text := v_text || '<hasDyspneaAtRest>false</hasDyspneaAtRest>'                                                                ;
   v_text := v_text || '<hasHighOutputCongestiveHeartFailure>false</hasHighOutputCongestiveHeartFailure>'                          ;
   v_text := v_text || '<hasHeadaches>false</hasHeadaches>'                                                                        ;
   v_text := v_text || '<hasOtherSymptoms>false</hasOtherSymptoms>'                                                                ;
   v_text := v_text || '<anyOtherComplications></anyOtherComplications>'                                                           ;
   v_text := v_text || '</gov.va.agentorange.fasttrack.model.dbq.luk.HairyCellLeukemia>'                                              ;

   UPDATE   questionnaire_result
      SET   detail_xml     = v_text,
            document_type  = 'Hairy_Cell_(B-Cell)_Leukemia_Medical_Summary'
    WHERE   document_type  = '1'
   ;
   COMMIT;

---------------------------------------------------------------
-- 'Hematologic_and_Lymphatic_Conditions'
---------------------------------------------------------------
   --dbms_output.put_line(CHR(10));
   --dbms_output.put_line('   =======================================================================');
   --dbms_output.put_line('   Updating DOCUMENT_TYPE 2');
   --dbms_output.put_line('   =======================================================================');

   v_text := NULL;
   v_text := v_text || '<gov.va.agentorange.fasttrack.model.dbq.hem.HematologicLymphatic>'                                                 ;
   v_text := v_text || '<id>6949</id>'                                                                                                  ;
   v_text := v_text || '<version>0</version>'                                                                                           ;
   v_text := v_text || '<dateCreated class="sql-timestamp">2012-01-03 11:57:05.25</dateCreated>'                                        ;
   v_text := v_text || '<dateModified class="sql-timestamp">2012-01-03 11:57:05.25</dateModified>'                                      ;
   v_text := v_text || '<formType>FORM_TYPE_DBQ_HEM</formType>'                                                                         ;
   v_text := v_text || '<vetSsn>190842394</vetSsn>'                                                                                     ;
   v_text := v_text || '<documentStatusType>COMPLETE</documentStatusType>'                                                              ;
   v_text := v_text || '<documentChannelType>ONLINE</documentChannelType>'                                                              ;
   v_text := v_text || '<formFileNetStatus>'                                                                                            ;
   v_text := v_text || '  <id>5180</id>'                                                                                                ;
   v_text := v_text || '  <version>1</version>'                                                                                         ;
   v_text := v_text || '  <dateCreated class="sql-timestamp">2012-01-03 11:57:05.3</dateCreated>'                                       ;
   v_text := v_text || '  <dateModified>2012-01-03 11:57:40.556 EST</dateModified>'                                                     ;
   v_text := v_text || '  <formFnStatusType>PROCESSOR_PROCESSING</formFnStatusType>'                                                    ;
   v_text := v_text || '  <formEntity class="gov.va.agentorange.fasttrack.model.dbq.hem.HematologicLymphatic" reference="../.."/>'      ;
   v_text := v_text || '</formFileNetStatus>'                                                                                           ;
   v_text := v_text || '<webFormType>HEM_DBQ</webFormType>'                                                                             ;
   v_text := v_text || '<veteranFirstName>Delete</veteranFirstName>'                                                                    ;
   v_text := v_text || '<veteranLastName>Delete</veteranLastName>'                                                                      ;
   v_text := v_text || '<physicianFirstName>Doctor</physicianFirstName>'                                                                ;
   v_text := v_text || '<physicianLastName>HEM</physicianLastName>'                                                                     ;
   v_text := v_text || '<medicalLicenseNumber>123</medicalLicenseNumber>'                                                               ;
   v_text := v_text || '<country>US</country>'                                                                                          ;
   v_text := v_text || '<addressLine1>1 Address</addressLine1>'                                                                         ;
   v_text := v_text || '<addressLine2></addressLine2>'                                                                                  ;
   v_text := v_text || '<addressLine3></addressLine3>'                                                                                  ;
   v_text := v_text || '<city>Town</city>'                                                                                              ;
   v_text := v_text || '<state>KANSAS</state>'                                                                                          ;
   v_text := v_text || '<zip>23455</zip>'                                                                                               ;
   v_text := v_text || '<physicianPhoneNumber>3256246436</physicianPhoneNumber>'                                                        ;
   v_text := v_text || '<privacyActAck>true</privacyActAck>'                                                                            ;
   v_text := v_text || '<physicianSignature>true</physicianSignature>'                                                                  ;
   v_text := v_text || '<impactsAbilityToWork>true</impactsAbilityToWork>'                                                              ;
   v_text := v_text || '<impactDescription></impactDescription>'                                                                        ;
   v_text := v_text || '<remarks></remarks>'                                                                                            ;
   v_text := v_text || '<dateSigned class="sql-timestamp">2012-01-03 11:57:05.25</dateSigned>'                                          ;
   v_text := v_text || '<diagnoses class="org.hibernate.collection.PersistentBag">'                                                     ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                              ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.hem.HematologicLymphatic" reference="../.."/>'           ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                  ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.diagnoses</role>'                                  ;
   v_text := v_text || '  <key class="long">6949</key>'                                                                                 ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                         ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                               ;
   v_text := v_text || '  <bag/>'                                                                                                       ;
   v_text := v_text || '</diagnoses>'                                                                                                   ;
   v_text := v_text || '<medications class="org.hibernate.collection.PersistentBag">'                                                   ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                              ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.hem.HematologicLymphatic" reference="../.."/>'           ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                  ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.medications</role>'                                ;
   v_text := v_text || '  <key class="long">6949</key>'                                                                                 ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                         ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                               ;
   v_text := v_text || '  <bag/>'                                                                                                       ;
   v_text := v_text || '</medications>'                                                                                                 ;
   v_text := v_text || '<diagnosticTests class="org.hibernate.collection.PersistentBag">'                                               ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                              ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.hem.HematologicLymphatic" reference="../.."/>'           ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                  ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.diagnosticTests</role>'                            ;
   v_text := v_text || '  <key class="long">6949</key>'                                                                                 ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                         ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                               ;
   v_text := v_text || '  <bag/>'                                                                                                       ;
   v_text := v_text || '</diagnosticTests>'                                                                                             ;
   v_text := v_text || '<hasHemicLymphatic>true</hasHemicLymphatic>'                                                                    ;
   v_text := v_text || '<hasALL>false</hasALL>'                                                                                         ;
   v_text := v_text || '<hasAML>false</hasAML>'                                                                                         ;
   v_text := v_text || '<hasCML>false</hasCML>'                                                                                         ;
   v_text := v_text || '<hasCLL>false</hasCLL>'                                                                                         ;
   v_text := v_text || '<hasHodgkins>false</hasHodgkins>'                                                                               ;
   v_text := v_text || '<hasNonHodgkins>false</hasNonHodgkins>'                                                                         ;
   v_text := v_text || '<hasMyeloma>true</hasMyeloma>'                                                                                  ;
   v_text := v_text || '<myelomaICD></myelomaICD>'                                                                                      ;
   v_text := v_text || '<hasMyeloSyndrome>false</hasMyeloSyndrome>'                                                                     ;
   v_text := v_text || '<hasPlasmacytoma>false</hasPlasmacytoma>'                                                                       ;
   v_text := v_text || '<hasAnemia>false</hasAnemia>'                                                                                   ;
   v_text := v_text || '<hasThrombo>false</hasThrombo>'                                                                                 ;
   v_text := v_text || '<hasPolycythemia>false</hasPolycythemia>'                                                                       ;
   v_text := v_text || '<hasSickleCell>false</hasSickleCell>'                                                                           ;
   v_text := v_text || '<hasSplenectomy>false</hasSplenectomy>'                                                                         ;
   v_text := v_text || '<hasBCellLeukemia>false</hasBCellLeukemia>'                                                                     ;
   v_text := v_text || '<hasOtherDiagnosis>false</hasOtherDiagnosis>'                                                                   ;
   v_text := v_text || '<briefHistory></briefHistory>'                                                                                  ;
   v_text := v_text || '<diseaseStatus>ACTIVE</diseaseStatus>'                                                                          ;
   v_text := v_text || '<continuousMedication>false</continuousMedication>'                                                             ;
   v_text := v_text || '<treatmentStatus>NO_TREATMENT_WATCHFUL_WAITING</treatmentStatus>'                                               ;
   v_text := v_text || '<transfusion>false</transfusion>'                                                                               ;
   v_text := v_text || '<findings>false</findings>'                                                                                     ;
   v_text := v_text || '<recurringInfections>false</recurringInfections>'                                                               ;
   v_text := v_text || '<diagRelatedScar>false</diagRelatedScar>'                                                                       ;
   v_text := v_text || '<otherPertinentFinding>false</otherPertinentFinding>'                                                           ;
   v_text := v_text || '<labTesting>false</labTesting>'                                                                                 ;
   v_text := v_text || '<otherSignificantResults>false</otherSignificantResults>'                                                       ;
   v_text := v_text || '</gov.va.agentorange.fasttrack.model.dbq.hem.HematologicLymphatic>'                                                ;
   COMMIT;

   UPDATE   questionnaire_result
      SET   detail_xml     = v_text,
            document_type = 'Hematologic_and_Lymphatic_Conditions'
    WHERE   document_type = '2'
   ;
   COMMIT;

   ---------------------------------------------------------------
   --  'Ischemic_Heart_Disease'
   ---------------------------------------------------------------
   --dbms_output.put_line(CHR(10));
   --dbms_output.put_line('   =======================================================================');
   --dbms_output.put_line('   Updating DOCUMENT_TYPE 3');
   --dbms_output.put_line('   =======================================================================');

   v_text := NULL;
   v_text := v_text || '<gov.va.agentorange.fasttrack.model.dbq.ihd.IschemicHeartDisease>'                                                     ;
   v_text := v_text || '<id>7553</id>'                                                                                                      ;
   v_text := v_text || '<version>0</version>'                                                                                               ;
   v_text := v_text || '<dateCreated class="sql-timestamp">2012-01-10 09:45:51.397</dateCreated>'                                           ;
   v_text := v_text || '<dateModified class="sql-timestamp">2012-01-10 09:45:51.397</dateModified>'                                         ;
   v_text := v_text || '<formType>FORM_TYPE_DBQ_IHD</formType>'                                                                             ;
   v_text := v_text || '<vetSsn>941288701</vetSsn>'                                                                                         ;
   v_text := v_text || '<documentStatusType>COMPLETE</documentStatusType>'                                                                  ;
   v_text := v_text || '<documentChannelType>ONLINE</documentChannelType>'                                                                  ;
   v_text := v_text || '<formFileNetStatus>'                                                                                                ;
   v_text := v_text || '  <id>5760</id>'                                                                                                    ;
   v_text := v_text || '  <version>1</version>'                                                                                             ;
   v_text := v_text || '  <dateCreated class="sql-timestamp">2012-01-10 09:45:51.437</dateCreated>'                                         ;
   v_text := v_text || '  <dateModified>2012-01-10 09:45:51.507 EST</dateModified>'                                                         ;
   v_text := v_text || '  <formFnStatusType>PROCESSOR_PROCESSING</formFnStatusType>'                                                        ;
   v_text := v_text || '  <formEntity class="gov.va.agentorange.fasttrack.model.dbq.ihd.IschemicHeartDisease" reference="../.."/>'          ;
   v_text := v_text || '</formFileNetStatus>'                                                                                               ;
   v_text := v_text || '<webFormType>IHD_DBQ</webFormType>'                                                                                 ;
   v_text := v_text || '<veteranFirstName>Test</veteranFirstName>'                                                                          ;
   v_text := v_text || '<veteranLastName>Test</veteranLastName>'                                                                            ;
   v_text := v_text || '<physicianFirstName>Dr</physicianFirstName>'                                                                        ;
   v_text := v_text || '<physicianLastName>Test</physicianLastName>'                                                                        ;
   v_text := v_text || '<medicalLicenseNumber>12</medicalLicenseNumber>'                                                                    ;
   v_text := v_text || '<country>US</country>'                                                                                              ;
   v_text := v_text || '<addressLine1>Test</addressLine1>'                                                                                  ;
   v_text := v_text || '<addressLine2></addressLine2>'                                                                                      ;
   v_text := v_text || '<addressLine3></addressLine3>'                                                                                      ;
   v_text := v_text || '<city>Test</city>'                                                                                                  ;
   v_text := v_text || '<state>DELAWARE</state>'                                                                                            ;
   v_text := v_text || '<zip>12345</zip>'                                                                                                   ;
   v_text := v_text || '<physicianPhoneNumber>1231221312</physicianPhoneNumber>'                                                            ;
   v_text := v_text || '<privacyActAck>true</privacyActAck>'                                                                                ;
   v_text := v_text || '<physicianSignature>true</physicianSignature>'                                                                      ;
   v_text := v_text || '<impactsAbilityToWork>false</impactsAbilityToWork>'                                                                 ;
   v_text := v_text || '<remarks></remarks>'                                                                                                ;
   v_text := v_text || '<dateSigned class="sql-timestamp">2012-01-10 09:45:51.397</dateSigned>'                                             ;
   v_text := v_text || '<diagnoses class="org.hibernate.collection.PersistentBag">'                                                         ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                                  ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.ihd.IschemicHeartDisease" reference="../.."/>'               ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                      ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.diagnoses</role>'                                      ;
   v_text := v_text || '  <key class="long">7553</key>'                                                                                     ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                             ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                                   ;
   v_text := v_text || '  <bag/>'                                                                                                           ;
   v_text := v_text || '</diagnoses>'                                                                                                       ;
   v_text := v_text || '<medications class="org.hibernate.collection.PersistentBag">'                                                       ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                                  ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.ihd.IschemicHeartDisease" reference="../.."/>'               ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                      ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.medications</role>'                                    ;
   v_text := v_text || '  <key class="long">7553</key>'                                                                                     ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                             ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                                   ;
   v_text := v_text || '  <bag/>'                                                                                                           ;
   v_text := v_text || '</medications>'                                                                                                     ;
   v_text := v_text || '<diagnosticTests class="org.hibernate.collection.PersistentBag">'                                                   ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                                  ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.ihd.IschemicHeartDisease" reference="../.."/>'               ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                      ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.diagnosticTests</role>'                                ;
   v_text := v_text || '  <key class="long">7553</key>'                                                                                     ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                             ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                                   ;
   v_text := v_text || '  <bag/>'                                                                                                           ;
   v_text := v_text || '</diagnosticTests>'                                                                                                 ;
   v_text := v_text || '<hasIschemicHeartDisease>true</hasIschemicHeartDisease>'                                                            ;
   v_text := v_text || '<takesContinuousMedication>false</takesContinuousMedication>'                                                       ;
   v_text := v_text || '<hasPercutaneousCoronaryIntervention>false</hasPercutaneousCoronaryIntervention>'                                   ;
   v_text := v_text || '<hasMyocardialInfarction>false</hasMyocardialInfarction>'                                                           ;
   v_text := v_text || '<hasCoronaryBypassSurgery>false</hasCoronaryBypassSurgery>'                                                         ;
   v_text := v_text || '<hasHeartTransplant>false</hasHeartTransplant>'                                                                     ;
   v_text := v_text || '<hasImplantedCardiacPacemaker>false</hasImplantedCardiacPacemaker>'                                                 ;
   v_text := v_text || '<hasImplantedAicd>false</hasImplantedAicd>'                                                                         ;
   v_text := v_text || '<doesVeteranHaveCHF>false</doesVeteranHaveCHF>'                                                                     ;
   v_text := v_text || '<hasExerciseTestBeenConducted>false</hasExerciseTestBeenConducted>'                                                 ;
   v_text := v_text || '<metsLevel>metsLevel13</metsLevel>'                                                                                 ;
   v_text := v_text || '<hasDyspnea>false</hasDyspnea>'                                                                                     ;
   v_text := v_text || '<hasFatigue>false</hasFatigue>'                                                                                     ;
   v_text := v_text || '<hasAngina>false</hasAngina>'                                                                                       ;
   v_text := v_text || '<hasDizziness>false</hasDizziness>'                                                                                 ;
   v_text := v_text || '<hasSyncope>true</hasSyncope>'                                                                                      ;
   v_text := v_text || '<isEvidenceOfHypertrophyOrDil>false</isEvidenceOfHypertrophyOrDil>'                                                 ;
   v_text := v_text || '<hasEkg>false</hasEkg>'                                                                                             ;
   v_text := v_text || '<hasChestXRay>false</hasChestXRay>'                                                                                 ;
   v_text := v_text || '<hasEchocardiogram>false</hasEchocardiogram>'                                                                       ;
   v_text := v_text || '<hasOtherTest>false</hasOtherTest>'                                                                                 ;
   v_text := v_text || '<hasLVEF>false</hasLVEF>'                                                                                           ;
   v_text := v_text || '</gov.va.agentorange.fasttrack.model.dbq.ihd.IschemicHeartDisease>'                                                    ;
   COMMIT;

   UPDATE   questionnaire_result
      SET   detail_xml     = v_text,
            document_type = 'Ischemic_Heart_Disease'
    WHERE   document_type = '3'
   ;
   COMMIT;

   ---------------------------------------------------------------
   -- 'Parkinson''s_Disease'
   ---------------------------------------------------------------
   --dbms_output.put_line(CHR(10));
   --dbms_output.put_line('   =======================================================================');
   --dbms_output.put_line('   Updating DOCUMENT_TYPE 4');
   --dbms_output.put_line('   =======================================================================');

      v_text := NULL;
   v_text := v_text || '<gov.va.agentorange.fasttrack.model.dbq.prk.Parkinsons>'                                                                     ;
   v_text := v_text || '<id>7063</id>'                                                                                                               ;
   v_text := v_text || '<version>0</version>'                                                                                                        ;
   v_text := v_text || '<dateCreated class="sql-timestamp">2012-01-04 12:12:04.913</dateCreated>'                                                    ;
   v_text := v_text || '<dateModified class="sql-timestamp">2012-01-04 12:12:04.913</dateModified>'                                                  ;
   v_text := v_text || '<formType>FORM_TYPE_DBQ_PRK</formType>'                                                                                      ;
   v_text := v_text || '<vetSsn>201664600</vetSsn>'                                                                                                  ;
   v_text := v_text || '<documentStatusType>COMPLETE</documentStatusType>'                                                                           ;
   v_text := v_text || '<documentChannelType>ONLINE</documentChannelType>'                                                                           ;
   v_text := v_text || '<formFileNetStatus>'                                                                                                         ;
   v_text := v_text || '  <id>5284</id>'                                                                                                             ;
   v_text := v_text || '  <version>1</version>'                                                                                                      ;
   v_text := v_text || '  <dateCreated class="sql-timestamp">2012-01-04 12:12:04.973</dateCreated>'                                                  ;
   v_text := v_text || '  <dateModified>2012-01-04 12:12:05.191 EST</dateModified>'                                                                  ;
   v_text := v_text || '  <formFnStatusType>PROCESSOR_PROCESSING</formFnStatusType>'                                                                 ;
   v_text := v_text || '  <formEntity class="gov.va.agentorange.fasttrack.model.dbq.prk.Parkinsons" reference="../.."/>'                             ;
   v_text := v_text || '</formFileNetStatus>'                                                                                                        ;
   v_text := v_text || '<webFormType>PRK_DBQ</webFormType>'                                                                                          ;
   v_text := v_text || '<veteranFirstName></veteranFirstName>'                                                                                       ;
   v_text := v_text || '<veteranLastName>asfdas</veteranLastName>'                                                                                   ;
   v_text := v_text || '<physicianFirstName></physicianFirstName>'                                                                                   ;
   v_text := v_text || '<physicianLastName>asfdfds</physicianLastName>'                                                                              ;
   v_text := v_text || '<medicalLicenseNumber>12</medicalLicenseNumber>'                                                                             ;
   v_text := v_text || '<country>US</country>'                                                                                                       ;
   v_text := v_text || '<addressLine1>asfdsdf</addressLine1>'                                                                                        ;
   v_text := v_text || '<addressLine2></addressLine2>'                                                                                               ;
   v_text := v_text || '<addressLine3></addressLine3>'                                                                                               ;
   v_text := v_text || '<city>asdfds</city>'                                                                                                         ;
   v_text := v_text || '<state>MINNESOTA</state>'                                                                                                    ;
   v_text := v_text || '<zip>12345</zip>'                                                                                                            ;
   v_text := v_text || '<physicianPhoneNumber>1221313132</physicianPhoneNumber>'                                                                     ;
   v_text := v_text || '<privacyActAck>true</privacyActAck>'                                                                                         ;
   v_text := v_text || '<physicianSignature>true</physicianSignature>'                                                                               ;
   v_text := v_text || '<impactsAbilityToWork>false</impactsAbilityToWork>'                                                                          ;
   v_text := v_text || '<remarks></remarks>'                                                                                                         ;
   v_text := v_text || '<dateSigned class="sql-timestamp">2012-01-04 12:12:04.913</dateSigned>'                                                      ;
   v_text := v_text || '<diagnoses class="org.hibernate.collection.PersistentBag">'                                                                  ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                                           ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.prk.Parkinsons" reference="../.."/>'                                  ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                               ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.diagnoses</role>'                                               ;
   v_text := v_text || '  <key class="long">7063</key>'                                                                                              ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                                      ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                                            ;
   v_text := v_text || '  <bag/>'                                                                                                                    ;
   v_text := v_text || '</diagnoses>'                                                                                                                ;
   v_text := v_text || '<medications class="org.hibernate.collection.PersistentBag">'                                                                ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                                           ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.prk.Parkinsons" reference="../.."/>'                                  ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                               ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.medications</role>'                                             ;
   v_text := v_text || '  <key class="long">7063</key>'                                                                                              ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                                      ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                                            ;
   v_text := v_text || '  <bag/>'                                                                                                                    ;
   v_text := v_text || '</medications>'                                                                                                              ;
   v_text := v_text || '<diagnosticTests class="org.hibernate.collection.PersistentBag">'                                                            ;
   v_text := v_text || '  <initialized>true</initialized>'                                                                                           ;
   v_text := v_text || '  <owner class="gov.va.agentorange.fasttrack.model.dbq.prk.Parkinsons" reference="../.."/>'                                  ;
   v_text := v_text || '  <cachedSize>-1</cachedSize>'                                                                                               ;
   v_text := v_text || '  <role>gov.va.agentorange.fasttrack.model.dbq.DbqFormEntity.diagnosticTests</role>'                                         ;
   v_text := v_text || '  <key class="long">7063</key>'                                                                                              ;
   v_text := v_text || '  <dirty>false</dirty>'                                                                                                      ;
   v_text := v_text || '  <storedSnapshot class="list"/>'                                                                                            ;
   v_text := v_text || '  <bag/>'                                                                                                                    ;
   v_text := v_text || '</diagnosticTests>'                                                                                                          ;
   v_text := v_text || '<hasParkinsons>true</hasParkinsons>'                                                                                         ;
   v_text := v_text || '<stoopedPosture>SEVERE</stoopedPosture>'                                                                                     ;
   v_text := v_text || '<balanceImpairment>SEVERE</balanceImpairment>'                                                                               ;
   v_text := v_text || '<bradyKinesia>SEVERE</bradyKinesia>'                                                                                         ;
   v_text := v_text || '<lossAutomaticMovements>SEVERE</lossAutomaticMovements>'                                                                     ;
   v_text := v_text || '<speechChanges>SEVERE</speechChanges>'                                                                                       ;
   v_text := v_text || '<dominantHand>AMBIDEXTROUS</dominantHand>'                                                                                   ;
   v_text := v_text || '<hasTremors>false</hasTremors>'                                                                                              ;
   v_text := v_text || '<hasMuscleRigidityAndStiffness>false</hasMuscleRigidityAndStiffness>'                                                        ;
   v_text := v_text || '<depression>SEVERE</depression>'                                                                                             ;
   v_text := v_text || '<dementia>SEVERE</dementia>'                                                                                                 ;
   v_text := v_text || '<sleepDisturbance>SEVERE</sleepDisturbance>'                                                                                 ;
   v_text := v_text || '<difficultySwallowing>SEVERE</difficultySwallowing>'                                                                         ;
   v_text := v_text || '<constipation>SEVERE</constipation>'                                                                                         ;
   v_text := v_text || '<sexualDysfunction>SEVERE</sexualDysfunction>'                                                                               ;
   v_text := v_text || '<lossOfSmell>PARTIAL</lossOfSmell>'                                                                                          ;
   v_text := v_text || '<urinaryProblems>TWO_4PADS_DAY</urinaryProblems>'                                                                            ;
   v_text := v_text || '<otherManifestationsDesc></otherManifestationsDesc>'                                                                         ;
   v_text := v_text || '<otherManifestationsDesc2></otherManifestationsDesc2>'                                                                       ;
   v_text := v_text || '<financialResponsibilty>false</financialResponsibilty>'                                                                      ;
   v_text := v_text || '</gov.va.agentorange.fasttrack.model.dbq.prk.Parkinsons>'                                                                    ;
   COMMIT;

   UPDATE   questionnaire_result
      SET   detail_xml     = v_text,
            document_type = 'Parkinson''s_Disease'
    WHERE   document_type = '4'
   ;
   COMMIT;

   ---------------------------------------------------------------
   -- 'Prostate_Cancer_Medical_Summary'
   ---------------------------------------------------------------
   --dbms_output.put_line(CHR(10));
   --dbms_output.put_line('   =======================================================================');
   --dbms_output.put_line('   Updating DOCUMENT_TYPE 5');
   --dbms_output.put_line('   =======================================================================');

      v_text := NULL;
   v_text := v_text || '<gov.va.agentorange.fasttrack.model.dbq.prc.ProstateCancer>'                                      ;
   v_text := v_text || '<id>7125</id>'                                                                                    ;
   v_text := v_text || '<version>0</version>'                                                                             ;
   v_text := v_text || '<dateCreated>2012-01-04 20:02:09.28 EST</dateCreated>'                                            ;
   v_text := v_text || '<dateModified reference="../dateCreated"/>'                                                       ;
   v_text := v_text || '<formType>FORM_TYPE_DBQ_PRC</formType>'                                                           ;
   v_text := v_text || '<vetSsn>091098299</vetSsn>'                                                                       ;
   v_text := v_text || '<documentStatusType>COMPLETE</documentStatusType>'                                                ;
   v_text := v_text || '<documentChannelType>VA</documentChannelType>'                                                    ;
   v_text := v_text || '<createdBy>csmyth</createdBy>'                                                                    ;
   v_text := v_text || '<webFormType>PRC_DBQ_MED_SUMMARY</webFormType>'                                                   ;
   v_text := v_text || '<dbqPurpose>MEDICAL_SUMMARY</dbqPurpose>'                                                         ;
   v_text := v_text || '<sourcesOfInformation>add</sourcesOfInformation>'                                                 ;
   v_text := v_text || '<veteranFirstName>delete</veteranFirstName>'                                                      ;
   v_text := v_text || '<veteranLastName>delete</veteranLastName>'                                                        ;
   v_text := v_text || '<impactsAbilityToWork>false</impactsAbilityToWork>'                                               ;
   v_text := v_text || '<dateSigned reference="../dateCreated"/>'                                                         ;
   v_text := v_text || '<hasProstateCancer>true</hasProstateCancer>'                                                      ;
   v_text := v_text || '<statusOfDisease>REMISSION</statusOfDisease>'                                                     ;
   v_text := v_text || '<statusOfTreatment>WATCHFUL_WAITING</statusOfTreatment>'                                          ;
   v_text := v_text || '<hasResiduals>true</hasResiduals>'                                                                ;
   v_text := v_text || '<hasVoidingDysfunction>false</hasVoidingDysfunction>'                                             ;
   v_text := v_text || '<hasUrinaryFrequencyProblems>true</hasUrinaryFrequencyProblems>'                                  ;
   v_text := v_text || '<hasObstructedVoidingProblems>false</hasObstructedVoidingProblems>'                               ;
   v_text := v_text || '<hasUrinaryTractInfections>false</hasUrinaryTractInfections>'                                     ;
   v_text := v_text || '<hasErectileDysfunctionProblems>false</hasErectileDysfunctionProblems>'                           ;
   v_text := v_text || '<hasRenalDysfunctionProblems>false</hasRenalDysfunctionProblems>'                                 ;
   v_text := v_text || '<hasOtherComplications>false</hasOtherComplications>'                                             ;
   v_text := v_text || '<daytimeFrequency>GREATER_THAN_THREE</daytimeFrequency>'                                          ;
   v_text := v_text || '<nighttimeFrequency>AWAKENING_VOID_2</nighttimeFrequency>'                                        ;
   v_text := v_text || '</gov.va.agentorange.fasttrack.model.dbq.prc.ProstateCancer>'                                     ;
   COMMIT;

   UPDATE   questionnaire_result
      SET   detail_xml     = v_text,
            document_type = 'Prostate_Cancer_Medical_Summary'
    WHERE   document_type = '5'
   ;
   COMMIT;

END;
/

ALTER TRIGGER questionnaire_result_bur_trg ENABLE;
