

package gov.va.med.cds.client.functional.logging;


import gov.va.med.cds.client.functional.AbstractDataGeneratorValidatorTest;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.sql.OracleSqlPlusConnectionStringBuilder;
import gov.va.med.cds.testharness.sql.SqlPlusRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.repositories.Pathways;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/client/functional/vhim400/rpcSoapClientTestContext.xml",
                "classpath:gov/va/med/cds/client/functional/testRpcDataGeneratorContext.xml",
                "classpath:gov/va/med/cds/config/nonWeblogicHdr2DataSourceContext.xml",
                "classpath:gov/va/med/cds/client/functional/logging/testAuditLoggerContext.xml" } )
public class PathwaysApplicatoinLoggingTest
    extends
        AbstractDataGeneratorValidatorTest
{
    private static final String INVALID_ASSIGNING_FACILITY_IN_FILTER_REQUEST_X1 = "X1";

    @Autowired
    private JdbcTemplate hdrJdbcTemplate;

    @Resource
    private Pathways rpcClinicalDataService;

    @Autowired
    private OracleSqlPlusConnectionStringBuilder loggerSchemaOracleSqlPlusConnectionStringBuilder;

    @Autowired
    private SqlPlusRunner sqlPlusRunner;

    @Autowired
    private String hdrSchemaName;


    @BeforeTestsOnce
    @Suite( groups = { "smoketest" } )
    public void beforePathwaysApplicatoinLoggingTestSetUp( )
        throws Exception
    {
        sqlPlusRunner.execute( loggerSchemaOracleSqlPlusConnectionStringBuilder.getConnectionString(),
                        "src/test/resources/sql/grant_insert_permission_pathways_audit_log_to_hdr.sql", hdrSchemaName );

        clearPathwaysAuditLogTable();
        clearPathwaysApplicationLogTable();
    }


    @Test
    @Suite( groups = "brokentest" )
    public void testExamRequests_withNullFilter( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;

        clearPathwaysApplicationLogTable();
        rpcClinicalDataService.readData( readTemplateId, null, filterId, requestId );
        Thread.sleep( 3000 );
        verifyPathwaysApplicationLogData( requestId );
    }


    @Test
    @Suite( groups = "brokentest" )
    public void testExams_withNullFilter( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;

        clearPathwaysApplicationLogTable();
        rpcClinicalDataService.readData( readTemplateId, null, filterId, requestId );
        Thread.sleep( 3000 );
        verifyPathwaysApplicationLogData( requestId );
    }


    @Test
    @Suite( groups = "brokentest" )
    public void testExamsAndExamRequests_withNullFilter( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;

        clearPathwaysApplicationLogTable();
        rpcClinicalDataService.readData( readTemplateId, null, filterId, requestId );
        Thread.sleep( 3000 );
        verifyPathwaysApplicationLogData( requestId );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    public void testAppointmentsPathwaysApplicationLog_withNullFilter( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        clearPathwaysApplicationLogTable();
        rpcClinicalDataService.readData( readTemplateId, null, filterId, requestId );
        Thread.sleep( 3000 );
        verifyPathwaysApplicationLogData( requestId );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    public void testAppointmentsPathwaysApplicationLog_withNullTemplateId( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = null;

        String patientIdentity = "100600";
        String assigningFacility = "580";
        String assigningAuthority = "USVHA";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        // Make a read request with single patient filter - no status
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, assigningFacility );
        resolvedPatient.put( FilterBuilder.IDENTITY, patientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( resolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        clearPathwaysApplicationLogTable();
        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );
        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        Thread.sleep( 3000 );
        verifyPathwaysApplicationLogData( requestId );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    public void testAppointmentsPathwaysApplicationLogWithInvalidFilterXml( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String patientIdentity = "100600";
        String assigningFacility = "580";
        String assigningAuthority = "USVHA";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        // Make a read request with single patient filter - no status
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, assigningFacility );
        resolvedPatient.put( FilterBuilder.IDENTITY, patientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( resolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        // clean up PATHWAYS_AUDIT_LOG table
        clearPathwaysApplicationLogTable();

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );
        readFilter = readFilter.replaceAll( ">", "*" );

        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );

        Thread.sleep( 3000 );

        verifyPathwaysApplicationLogData( requestId, "Error parsing filter XML" );
    }


    @Test
    @Suite( groups = { "smoketest" } )
    public void testAppointmentsReadWithNoAuditLog( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String patientIdentity = "100600";
        String assigningFacility = "580";
        String assigningAuthority = "USVHA";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        // Make a read request with single patient filter - no status
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, assigningFacility );
        resolvedPatient.put( FilterBuilder.IDENTITY, patientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( resolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );

        // grant insert permission on PATHWAYS_AUDIT_LOG to HDR
        sqlPlusRunner.execute( loggerSchemaOracleSqlPlusConnectionStringBuilder.getConnectionString(),
                        "src/test/resources/sql/grant_insert_permission_pathways_audit_log_to_hdr.sql", hdrSchemaName );

        clearPathwaysAuditLogTable();
        clearCdsApplicationLogTable();
        clearPathwaysApplicationLogTable();
        Assert.assertEquals( 0, getPathwaysAuditLog() );
        Assert.assertEquals( 0, getCdsApllicationLogTableCount() );
        Assert.assertEquals( 0, getPathwaysApplicationLogTableCount() );

        // revoke insert permission on PATHWAYS_AUDIT_LOG from HDR
        sqlPlusRunner.execute( loggerSchemaOracleSqlPlusConnectionStringBuilder.getConnectionString(),
                        "src/test/resources/sql/revoke_insert_permission_pathways_audit_log_from_hdr.sql", hdrSchemaName );

        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );

        Thread.sleep( 3000 );

        // grant insert permission on PATHWAYS_AUDIT_LOG to HDR2
        sqlPlusRunner.execute( loggerSchemaOracleSqlPlusConnectionStringBuilder.getConnectionString(),
                        "src/test/resources/sql/grant_insert_permission_pathways_audit_log_to_hdr.sql", hdrSchemaName );

        Assert.assertEquals( 0, getPathwaysAuditLog() );
        Assert.assertEquals( 0, getCdsApllicationLogTableCount() );
        verifyPathwaysApllicationLogMessageData( "Error auditing READ message", "org.hibernate.exception.SQLGrammarException" );
    }


    @Test
    @Suite( groups = { "smoketest" } )
    public void testPathwaysWithInvalidNValidVistaSites( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String patientIdentity = "100600";
        String invalidAssigningFacility = INVALID_ASSIGNING_FACILITY_IN_FILTER_REQUEST_X1;
        String assigningAuthority = "USVHA";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        Map<String, String> invalidResolvedPatient = new HashMap<String, String>();
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, invalidAssigningFacility );
        invalidResolvedPatient.put( FilterBuilder.IDENTITY, patientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( invalidResolvedPatient );

        String assigningFacility = "580";
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, assigningFacility );
        resolvedPatient.put( FilterBuilder.IDENTITY, patientIdentity );
        resolvedPatientList.add( resolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        // clean up PATHWAYS_AUDIT_LOG table
        clearPathwaysApplicationLogTable();

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );
        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
       
        Thread.sleep( 3000 );
        verifyCdsApplicationLogForNoData( requestId, "Invalid Assigning Facilities mentioned in the Filter and they are " );
        verifyPathwaysApplicationLogData( requestId, "Invalid Assigning Facilities mentioned in the Filter and they are " );
 
    }

    @Test
    @Suite( groups = { "smoketest" } )
    public void testPathwaysWithInvalidVistaSite( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String patientIdentity = "100600";
        String invalidAssigningFacility = INVALID_ASSIGNING_FACILITY_IN_FILTER_REQUEST_X1;
        String assigningAuthority = "USVHA";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        Map<String, String> invalidResolvedPatient = new HashMap<String, String>();
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, invalidAssigningFacility );
        invalidResolvedPatient.put( FilterBuilder.IDENTITY, patientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( invalidResolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        // clean up PATHWAYS_AUDIT_LOG table
        clearPathwaysApplicationLogTable();

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );
        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
       
        Thread.sleep( 3000 );
        verifyCdsApplicationLogForNoData( requestId, "All the Assigning Facilities mentioned in the Filter are invalid and they are " );
        verifyPathwaysApplicationLogData( requestId, "All the Assigning Facilities mentioned in the Filter are invalid and they are " );
 
    }  

    @Test
    @Suite( groups = { "smoketest" } )
    public void testPathwaysWithInvalidVistaSiteNDFN( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String patientIdentity = "123456";
        String invalidAssigningFacility = INVALID_ASSIGNING_FACILITY_IN_FILTER_REQUEST_X1;
        String assigningAuthority = "USVHA";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        Map<String, String> invalidResolvedPatient = new HashMap<String, String>();
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, invalidAssigningFacility );
        invalidResolvedPatient.put( FilterBuilder.IDENTITY, patientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( invalidResolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        // clean up PATHWAYS_AUDIT_LOG table
        clearPathwaysApplicationLogTable();

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );
        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
       
        Thread.sleep( 3000 );
        verifyCdsApplicationLogForNoData( requestId, "All the Assigning Facilities mentioned in the Filter are invalid and they are " );
        verifyPathwaysApplicationLogData( requestId, "All the Assigning Facilities mentioned in the Filter are invalid and they are " );
 
    }  

    @Test
    @Suite( groups = { "smoketest" } )
    public void testPathwaysWithInvalidDFN( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String invalidPatientIdentity = "123456";
        String assigningFacility = "580";
        String assigningAuthority = "USVHA";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        Map<String, String> invalidResolvedPatient = new HashMap<String, String>();
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, assigningFacility );
        invalidResolvedPatient.put( FilterBuilder.IDENTITY, invalidPatientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( invalidResolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        // clean up PATHWAYS_AUDIT_LOG table
        clearPathwaysApplicationLogTable();

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );

        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        
        Thread.sleep( 3000 );

        verifyPathwaysApplicationLogData( requestId, "All datasources failed.  Unable to get data from applicable datasource(s) due to the following reason" );
        verifyCdsApplicationLogForNoData( requestId, "All datasources failed.  Unable to get data from applicable datasource(s) due to the following reason" );
    }

    @Test
    @Suite( groups = { "smoketest" } )
    public void testPathwaysWithInvalidTemplateId( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.ALLERGIES_READ_TEMPLATE_ID;

        String invalidPatientIdentity = "123456";
        String assigningFacility = "580";
        String assigningAuthority = "USVHA";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        Map<String, String> invalidResolvedPatient = new HashMap<String, String>();
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, assigningFacility );
        invalidResolvedPatient.put( FilterBuilder.IDENTITY, invalidPatientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( invalidResolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        // clean up PATHWAYS_AUDIT_LOG table
        clearPathwaysApplicationLogTable();

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );

        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
    
        Thread.sleep( 3000 );

        verifyCdsApplicationLogForData( requestId );//since invalid template id, applicationName will default to CDS
        verifyPathwaysApplicationLogNoData( requestId );
       
    }
    
    //@Test
    //@Suite( groups = { "smoketest" } )
    public void testPathwaysWithInvalidAssigningAuthority( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String patientIdentity = "100600";
        String assigningFacility = "580";
        String assigningAuthority = "UXX";
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        Map<String, String> invalidResolvedPatient = new HashMap<String, String>();
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, assigningAuthority );
        invalidResolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, assigningFacility );
        invalidResolvedPatient.put( FilterBuilder.IDENTITY, patientIdentity );
        List<Map<String, String>> resolvedPatientList = new ArrayList<Map<String, String>>();
        resolvedPatientList.add( invalidResolvedPatient );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        // clean up PATHWAYS_AUDIT_LOG table
        clearPathwaysApplicationLogTable();

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );

        rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
     
        Thread.sleep( 3000 );

        verifyPathwaysApplicationLogNoData( requestId );
        verifyCdsApplicationLogForNoData( requestId );
    }

    protected void verifyPathwaysApplicationLogData( String requestId, String errorMsg )
    {

        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append( "SELECT COUNT(*) FROM PATHWAYS_APPLICATION_LOG " );
        sqlBuilder.append( "WHERE DBMS_LOB.INSTR(MESSAGE, '" );
        sqlBuilder.append( errorMsg );
        sqlBuilder.append( "', 1, 1) > 0" );
        sqlBuilder.append( " AND REQUEST_ID = '" );
        sqlBuilder.append( requestId );
        sqlBuilder.append( "'" );

        int retVal = hdrJdbcTemplate.queryForObject( sqlBuilder.toString(), Integer.class );

        Assert.assertTrue( retVal > 0 );
    }


    protected void verifyPathwaysApplicationLogForNoData( String requestId, String errorMsg )
    {

        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append( "SELECT COUNT(*) FROM PATHWAYS_APPLICATION_LOG " );
        sqlBuilder.append( "WHERE DBMS_LOB.INSTR(MESSAGE, '" );
        sqlBuilder.append( errorMsg );
        sqlBuilder.append( "', 1, 1) > 0" );
        sqlBuilder.append( " AND REQUEST_ID = '" );
        sqlBuilder.append( requestId );
        sqlBuilder.append( "'" );

        int retVal = hdrJdbcTemplate.queryForObject( sqlBuilder.toString(), Integer.class );

        Assert.assertTrue( retVal == 0 );
    }


    private void clearCdsApplicationLogTable( )
    {
        this.hdrJdbcTemplate.update( "DELETE FROM CDS_APPLICATION_LOG" );
    }


    private void clearPathwaysApplicationLogTable( )
    {
        this.hdrJdbcTemplate.update( "DELETE FROM PATHWAYS_APPLICATION_LOG" );
    }


    private void clearPathwaysAuditLogTable( )
    {
        this.hdrJdbcTemplate.update( "DELETE FROM PATHWAYS_AUDIT_LOG" );
    }


    private int getPathwaysAuditLog( )
    {
        return hdrJdbcTemplate.queryForObject( "SELECT COUNT(*) FROM PATHWAYS_AUDIT_LOG", Integer.class );
    }


    private int getCdsApllicationLogTableCount( )
    {
        return hdrJdbcTemplate.queryForObject( "SELECT COUNT(*) FROM CDS_APPLICATION_LOG", Integer.class );
    }


    private int getPathwaysApplicationLogTableCount( )
    {
        return hdrJdbcTemplate.queryForObject( "SELECT COUNT(*) FROM PATHWAYS_APPLICATION_LOG", Integer.class );
    }


    private void verifyPathwaysApplicationLogData( String requestId )
    {
        String jmsQueueAppender = "JmsQueueAppender";
        StringBuilder sqlBuilder = new StringBuilder();

        sqlBuilder.append( "SELECT COUNT(*) FROM PATHWAYS_APPLICATION_LOG " );
        sqlBuilder.append( " WHERE DBMS_LOB.INSTR(MESSAGE, '" );
        sqlBuilder.append( requestId );
        sqlBuilder.append( "', 1, 1) > 0" );
        sqlBuilder.append( " AND DBMS_LOB.INSTR(MESSAGE, '" );
        sqlBuilder.append( jmsQueueAppender );
        sqlBuilder.append( "', 1, 1) = 0" );
        sqlBuilder.append( " AND REQUEST_ID = '" );
        sqlBuilder.append( requestId );
        sqlBuilder.append( "'" );
        sqlBuilder.append( " AND APP_NAME = '" );
        sqlBuilder.append( pathwaysAppName );
        sqlBuilder.append( "'" );

        int retVal = hdrJdbcTemplate.queryForObject( sqlBuilder.toString(), Integer.class );

        Assert.assertTrue( retVal == 1 );
    }

    private void verifyPathwaysApplicationLogNoData( String requestId )
    {
        String jmsQueueAppender = "JmsQueueAppender";
        StringBuilder sqlBuilder = new StringBuilder();

        sqlBuilder.append( "SELECT COUNT(*) FROM PATHWAYS_APPLICATION_LOG " );
        sqlBuilder.append( " WHERE REQUEST_ID = '" );
        sqlBuilder.append( requestId );
        sqlBuilder.append( "'" );
        sqlBuilder.append( " AND APP_NAME = '" );
        sqlBuilder.append( pathwaysAppName );
        sqlBuilder.append( "'" );

        int retVal = hdrJdbcTemplate.queryForObject( sqlBuilder.toString(), Integer.class );

        Assert.assertTrue( retVal == 0 );
    }


    private void verifyCdsApplicationLogForNoData( String requestId, String errorMsg )
    {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append( "SELECT COUNT(*) FROM CDS_APPLICATION_LOG " );
        sqlBuilder.append( "WHERE DBMS_LOB.INSTR(MESSAGE, '" );
        sqlBuilder.append( errorMsg );
        sqlBuilder.append( "', 1, 1) > 0" );
        sqlBuilder.append( " AND REQUEST_ID = '" );
        sqlBuilder.append( requestId );
        sqlBuilder.append( "'" );

        int retVal = hdrJdbcTemplate.queryForObject( sqlBuilder.toString(), Integer.class );

        Assert.assertTrue( retVal == 0 );
    }

    private void verifyCdsApplicationLogForNoData( String requestId )
    {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append( "SELECT COUNT(*) FROM CDS_APPLICATION_LOG " );
        sqlBuilder.append( "WHERE REQUEST_ID = '" );
        sqlBuilder.append( requestId );
        sqlBuilder.append( "'" );

        int retVal = hdrJdbcTemplate.queryForObject( sqlBuilder.toString(), Integer.class );

        Assert.assertTrue( retVal == 0 );
    }

    private void verifyCdsApplicationLogForData( String requestId )
    {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append( "SELECT COUNT(*) FROM CDS_APPLICATION_LOG " );
        sqlBuilder.append( "WHERE REQUEST_ID = '" );
        sqlBuilder.append( requestId );
        sqlBuilder.append( "'" );

        int retVal = hdrJdbcTemplate.queryForObject( sqlBuilder.toString(), Integer.class );

        Assert.assertTrue( retVal == 1 );
    }
    
    private void verifyPathwaysApllicationLogMessageData( String searchString1, String searchString2 )
    {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append( "select count(*) from pathways_application_log where dbms_lob.instr(message,'" );
        sqlBuilder.append( searchString1 );
        sqlBuilder.append( "', 1, 1) = 0" );
        sqlBuilder.append( " and dbms_lob.instr(message,'" );
        sqlBuilder.append( searchString2 );
        sqlBuilder.append( "', 1, 1) > 0" );

        int retVal = hdrJdbcTemplate.queryForObject( sqlBuilder.toString(), Integer.class );

        Assert.assertEquals( 1, retVal );
    }


    @After
    @Suite( groups = "smoketest" )
    public void AfterPathwaysApplicatoinLoggingTestMethodTearDown( )
        throws Exception
    {
        sqlPlusRunner.execute( loggerSchemaOracleSqlPlusConnectionStringBuilder.getConnectionString(),
                        "src/test/resources/sql/grant_insert_permission_pathways_audit_log_to_hdr.sql", hdrSchemaName );

        clearPathwaysApplicationLogTable();
        clearPathwaysAuditLogTable();
    }
}
