

package gov.va.med.cds.ejb;


import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface;
import gov.va.med.cds.config.BeanConstantsInterface;
import gov.va.med.cds.ejb.interceptor.CdsAutowiredInterceptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;

import gov.va.med.cds.saml.SamlAssertionThreadLocal;


/**
 * XDoclet-based session bean. The class must be declared public according to the EJB specification.
 * 
 * To generate the EJB related files to this EJB: - Add Standard EJB module to XDoclet project properties - Customize
 * XDoclet configuration for your appserver - Run XDoclet
 * 
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="ClinicalDataServiceSynchronousBean" display-name="Clinical Data Source Synchronous Session Bean"
 *           description="Provides an EJB stateless session front end to the Clinical Data Source POJOs"
 *           jndi-name="ejb/remote/gov/va/med/cds/ClinicalDataServiceSynchronousSession" type="Stateless"
 *           view-type="remote"
 */
@WebService( serviceName = "ClinicalDataServiceSynchronousInterface", portName = "ClinicalDataServiceSynchronousInterfaceHttpPort", endpointInterface = "gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface", targetNamespace = "http://client.cds.med.DNS   " )
@Stateless( name = "ClinicalDataServiceSynchronous", mappedName = "ejb/remote/gov/va/med/cds/ClinicalDataServiceSynchronousSession" )
@Interceptors( CdsAutowiredInterceptor.class )
public class ClinicalDataServiceSynchronousSession
    implements
    ClinicalDataServiceSynchronousInterface
{

    protected final Log logger = LogFactory.getLog( getClass() );

    @Autowired
    private ClinicalDataServiceInterface clinicalDataSourceSynchronous;

    @Autowired
    @Qualifier( BeanConstantsInterface.VHIM_REQUEST_AUDIT_LOGGER )
    private VhimRequestAuditLoggerInterface vhimRequestAuditLogger;

    @Autowired
    private String cdsAppName;


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#appendClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String appendClinicalData( String appendRequest, String templateId, String requestId )
    {
        if ( appendRequest != null )
        {
            appendRequest = appendRequest.trim();
        }
        vhimRequestAuditLogger.auditWriteRequest( templateId, appendRequest, requestId );
        return clinicalDataSourceSynchronous.appendClinicalData( appendRequest, templateId, requestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#createClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String createClinicalData( String createRequest, String templateId, String requestId )
    {
        if ( createRequest != null )
        {
            createRequest = createRequest.trim();
        }
        vhimRequestAuditLogger.auditWriteRequest( templateId, createRequest, requestId );
        return clinicalDataSourceSynchronous.createClinicalData( createRequest, templateId, requestId );
    }


    public String createClinicalData( String createRequest, String templateId, String requestId, boolean auditVhimRequest )
    {
        if ( createRequest != null )
        {
            createRequest = createRequest.trim();
        }

        if ( auditVhimRequest )
        {
            vhimRequestAuditLogger.auditWriteRequest( templateId, createRequest, requestId );
        }

        return clinicalDataSourceSynchronous.createClinicalData( createRequest, templateId, requestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#deleteClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String deleteClinicalData( String deleteRequest, String templateId, String requestId )
    {
        if ( deleteRequest != null )
        {
            deleteRequest = deleteRequest.trim();
        }
        vhimRequestAuditLogger.auditWriteRequest( templateId, deleteRequest, requestId );
        return clinicalDataSourceSynchronous.deleteClinicalData( deleteRequest, templateId, requestId );
    }


    @Override
    public String readClinicalData( String templateId, String filterId, String requestId )
    {
        throw new UnsupportedOperationException();
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#readClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String)
     */
    public String readClinicalData( String templateId, String filterRequest, String filterId, String requestId )
    {
        //long startTime = System.currentTimeMillis();

        if ( filterRequest != null )
        {
            filterRequest = filterRequest.trim();
        }

        return this.readClinicalData( templateId, filterRequest, filterId, requestId, true );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceExtendedInterface#readClinicalData(java.lang.String, 
     *      java.lang.String, java.lang.String, java.lang.String, boolean)
     */
    public String readClinicalData( String templateId, String filterRequest, String filterId, String requestId, boolean audit )
    {
        long startTime = System.currentTimeMillis();

        if ( filterRequest != null )
        {
            filterRequest = filterRequest.trim();
        }

        String response = clinicalDataSourceSynchronous.readClinicalData( templateId, filterRequest, filterId, requestId );

        // Audit the read request details
        if ( audit )
        {
            vhimRequestAuditLogger.auditReadRequest( templateId, filterRequest, filterId, requestId, startTime, response );
        }

        return response;
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#updateClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String updateClinicalData( String updateRequest, String templateId, String requestId )
    {
        if ( updateRequest != null )
        {
            updateRequest = updateRequest.trim();
        }
        vhimRequestAuditLogger.auditWriteRequest( templateId, updateRequest, requestId );
        return clinicalDataSourceSynchronous.updateClinicalData( updateRequest, templateId, requestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#isAlive()
     */
    public boolean isAlive( )
    {
        if ( logger.isDebugEnabled() )
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, cdsAppName,
                            "About to call the POMO isAlive() method from inside the SLSB" ) );

        boolean result = clinicalDataSourceSynchronous.isAlive();

        if ( logger.isDebugEnabled() )
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, cdsAppName,
                            "Finished calling the POMO isAlive() method from inside the SLSB" ) );

        return result;
    }


    //    @WebMethod(exclude=true)
    public void setClinicalDataServiceSynchronous( ClinicalDataServiceInterface clinicalDataSourceSynchronous )
    {
        this.clinicalDataSourceSynchronous = clinicalDataSourceSynchronous;
    }


    //    @WebMethod(exclude=true)
    public void setVhimRequestAuditLogger( VhimRequestAuditLoggerInterface vhimRequestAuditLogger )
    {
        this.vhimRequestAuditLogger = vhimRequestAuditLogger;
    }

}
