

package gov.va.med.cds.util;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.persistence.QueryAssociationMetaData;

import org.easymock.EasyMock;
import org.hibernate.Query;
import org.junit.Test;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Assert;


public class AssociationQueryMetaDataTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testAssociationQueryMetaData( )
    {
        QueryAssociationMetaData aqmd = new QueryAssociationMetaData();

        String filterModelName = "clinicalDocumentEvents";
        String associationName = "patient";
        String key = "id";
        String parentKey = "clinicalDocumentId";
        List<String> keyList = new ArrayList<String>();
        keyList.add( "id" );
        List resultList = new ArrayList();
        Query query = EasyMock.createNiceMock( Query.class );
        EasyMock.replay( query );
        resultList.add( query.list() );

        aqmd.setFilterModelName( filterModelName );
        aqmd.setAssociationName( associationName );
        aqmd.setKey( key );
        aqmd.setParentKey( parentKey );
//        aqmd.setNonCompliantFieldList( keyList );
//        aqmd.setResultList( resultList );
//        aqmd.setQuery( query );
//        aqmd.setResultList( resultList );

        Assert.assertEquals( aqmd.getFilterModelName(), filterModelName );
        Assert.assertEquals( aqmd.getAssociationName(), associationName );
        Assert.assertEquals( aqmd.getKey(), key );
        Assert.assertEquals( aqmd.getParentKey(), parentKey );
//        Assert.assertEquals( aqmd.getNonCompliantFieldList(), keyList );
//        Assert.assertEquals( aqmd.getResultList(), resultList );
//        Assert.assertEquals( aqmd.getQuery(), query );
//        Assert.assertEquals( aqmd.getResultList(), resultList );
    }
}
