

package gov.va.med.cds.template;


import static org.easymock.EasyMock.expect;
import static org.easymock.EasyMock.*;

import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.xml.schema.SchemaHelperInterface;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.Calendar;


@RunWith( SuiteAwareRunner.class )
public class TemplateCacheModelDataTest
{

    private SchemaHelperInterface schemaHelper = null;
    private TemplateMetaDataInterface templateMetaData = null;


    private void initMocks( )
    {
        schemaHelper = createMock( SchemaHelperInterface.class );
        templateMetaData = createMock( TemplateMetaDataInterface.class );

        expect( templateMetaData.getTemplateId() ).andReturn( TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID );
    }


    @Before
    public void setUp( )
    {
        initMocks();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void templateCacheModelDataTest( )
    {
        TemplateCacheModelData templateCacheModelData = new TemplateCacheModelData();

        templateCacheModelData.setSchemaHelper( schemaHelper );
        templateCacheModelData.setTemplateMetaData( templateMetaData );
        templateCacheModelData.setLoadedIntoCache( Calendar.getInstance().getTimeInMillis() );

        templateCacheModelData.getLoadedIntoCache();
        templateCacheModelData.getSchemaHelper();
        templateCacheModelData.getTemplateId();
        templateCacheModelData.getTemplateMetaData();
        templateCacheModelData.getTimeInCache();
    }

}
