package gov.va.med.cds.request;

import junit.framework.Assert;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * 
 * @author DNS   roberk
 *
 */
@RunWith( SuiteAwareRunner.class )
public class ExceptionTest {

    @Test
    @Suite( groups = { "checkintest" } )
    public void testValidationExceptionErrorCode()
    {
    	ErrorCodeEnum errorCode = ErrorCodeEnum.CANT_CREATE_IDENTITY;
    	ValidationException ex = new ValidationException(errorCode);
    	Assert.assertTrue("Illegal Error Code",ex.getErrorCode().equals(ErrorCodeEnum.CANT_CREATE_IDENTITY));
    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testValidationExceptionMessages()
    {
    	ErrorCodeEnum errorCode = ErrorCodeEnum.CANT_CREATE_IDENTITY;
    	ValidationException ex = new ValidationException(errorCode,"Message1","Message2","MessageN");
    	Assert.assertTrue("Illegal message1",ex.getCustomMsgValues()[0].equals("Message1"));
    	Assert.assertTrue("Illegal message2",ex.getCustomMsgValues()[1].equals("Message2"));
    	Assert.assertTrue("Illegal message3",ex.getCustomMsgValues()[2].equals("MessageN"));
    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testValidationExceptionCause()
    {
    	ErrorCodeEnum errorCode = ErrorCodeEnum.CANT_CREATE_IDENTITY;
    	String causeMsg = "This is the true cause";
    	Exception cause = new Exception(causeMsg);
       	ValidationException ex = new ValidationException(errorCode,cause,"Message1","Message2","MessageN");
    	Assert.assertTrue("Illegal cause message",ex.getCause().getMessage().equals(causeMsg));
    }

}
