

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class MethodNotImplementedExceptionTest
{
    @Test( expected = MethodNotImplementedException.class )
    @Suite( groups = "checkintest" )
    public void testMethodNotImplementedExceptionTest( )
    {
        throw new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED );
    }


    @Test( expected = MethodNotImplementedException.class )
    @Suite( groups = "checkintest" )
    public void testMethodNotImplementedExceptionTestWithCustomMessage( )
    {
        throw new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, "method not implemented" );
    }


    @Test( expected = MethodNotImplementedException.class )
    @Suite( groups = "checkintest" )
    public void testMethodNotImplementedExceptionTestWithWrappedException( )
    {
        throw new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, new Exception() );
    }


    @Test( expected = MethodNotImplementedException.class )
    @Suite( groups = "checkintest" )
    public void testMethodNotImplementedExceptionTestWithWrappedExceptionAndCustomerMessage( )
    {
        throw new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, new Exception(), "method not implemented" );
    }
}
