/**
 * 
 */


package gov.va.med.cds.persistence.hibernate;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.List;


/**
 * @author DNS   egberb
 *
 * Test class for Unit Testing the logic contained in the <code>HibernateDomModelAssembler</code>
 * class.
 *
 */
@RunWith( SuiteAwareRunner.class )
public class HibernateDomModelAssemblerTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAssembleModelSingleWork( )
        throws Exception
    {
        List<Element> resultsList = new ArrayList<Element>();
        List<Element> resultIdList = new ArrayList<Element>();

        // initialize mocks for test
        ClinicalDataResponseInterface clinicalDataResponse = EasyMock.createMock( ClinicalDataResponseInterface.class );
        EntryFilterInterface entryFilter = EasyMock.createMock( EntryFilterInterface.class );
        QueryAssociationInterface queryAssociation = EasyMock.createMock( QueryAssociationInterface.class );
        QueryWorkInterface queryWork = EasyMock.createMock( QueryWorkInterface.class );
        Document clinicalDataDocument = EasyMock.createMock( Document.class );
        Element clinicalDataElement = EasyMock.createMock( Element.class );
        //Element clinicalDataPatientElement = EasyMock.createMock( Element.class );
        Element clinicalDataPatientElement = EasyMock.createNiceMock( Element.class );
        Element queryWorkResultsElement = EasyMock.createMock( Element.class );

        Element result1 = EasyMock.createMock( Element.class );
        Element result2 = EasyMock.createMock( Element.class );
        Element result3 = EasyMock.createMock( Element.class );
        resultsList.add( result1 );
        resultsList.add( result2 );
        resultsList.add( result3 );

        Element result1Id = EasyMock.createMock( Element.class );
        Element result2Id = EasyMock.createMock( Element.class );
        Element result3Id = EasyMock.createMock( Element.class );
        resultIdList.add( result1Id );
        resultIdList.add( result2Id );
        resultIdList.add( result3Id );

        // set the expectations on the mocks.
        EasyMock.expect( entryFilter.getTemplateId() ).andReturn( "templateId" );
        EasyMock.expect( entryFilter.getRequestId() ).andReturn( "requestId" );
        EasyMock.expect( clinicalDataResponse.buildEmptyClinicalDocumentWithPatient( "templateId", "requestId" ) ).andReturn( clinicalDataDocument );
        EasyMock.expect( clinicalDataResponse.getClinicalRoot( clinicalDataDocument )).andReturn( clinicalDataPatientElement );
        EasyMock.expect( clinicalDataPatientElement.getUniquePath()).andReturn( "//patient" ).anyTimes();
        
        // patient level processing
        EasyMock.expect( queryWork.getQueryAssociation() ).andReturn( queryAssociation );
        EasyMock.expect( queryAssociation.getParentKey() ).andReturn( null );
        EasyMock.expect( queryWork.getResults() ).andReturn( queryWorkResultsElement );
        EasyMock.expect( queryWorkResultsElement.hasContent() ).andReturn( Boolean.TRUE );
        EasyMock.expect( queryWorkResultsElement.elements() ).andReturn( resultsList );

        List clinicalDataPatientElementList = new ArrayList();
        clinicalDataPatientElementList.add( clinicalDataPatientElement );

        // reslult1 processing
//        EasyMock.expect( queryAssociation.getAssociationParent() ).andReturn( "patient" );
        EasyMock.expect( clinicalDataPatientElement.selectNodes( "//patient" ) ).andReturn( clinicalDataPatientElementList );
        EasyMock.expect( queryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( result1.detach() ).andReturn( result1 );
        clinicalDataPatientElement.add( ( Element )result1 );

        // result2 processing
//        EasyMock.expect( queryAssociation.getAssociationParent() ).andReturn( "patient" );
        EasyMock.expect( clinicalDataPatientElement.selectNodes( "//patient" ) ).andReturn( clinicalDataPatientElementList );
        EasyMock.expect( queryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( result2.detach() ).andReturn( result2 );
        clinicalDataPatientElement.add( (Element)result2 );
        
        // result3 processing
//        EasyMock.expect( queryAssociation.getAssociationParent() ).andReturn( "patient" );
        EasyMock.expect( clinicalDataPatientElement.selectNodes( "//patient" ) ).andReturn( clinicalDataPatientElementList );
        EasyMock.expect( queryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( result3.detach() ).andReturn( result3 );
        clinicalDataPatientElement.add( ( Element )result3 );

        // id removal processing
        EasyMock.expect( clinicalDataPatientElement.selectNodes( "//id" ) ).andReturn( resultIdList );
        EasyMock.expect( result1Id.detach() ).andReturn( ( Node )result1Id );
        EasyMock.expect( result2Id.detach() ).andReturn( ( Node )result2Id );
        EasyMock.expect( result3Id.detach() ).andReturn( ( Node )result3Id );

        // get ready to execute the test.
        EasyMock.replay( clinicalDataResponse, entryFilter, queryAssociation, queryWork, clinicalDataDocument, clinicalDataElement,
                        clinicalDataPatientElement, queryWorkResultsElement, result1, result2, result3, result1Id, result2Id, result3Id );

        List<QueryWorkInterface> work = new ArrayList<QueryWorkInterface>();
        work.add( queryWork );

        List<String> removes = new ArrayList<String>();
        removes.add( "//id" );
        
        List<String>emptyElementList = new ArrayList<String>();
        emptyElementList.add("//allergyAssessments/observationTime");
        emptyElementList.add("//allergyAssessments/author");


        HibernateDomModelAssembler modelAssembler = new HibernateDomModelAssembler();
        modelAssembler.setRemoves( removes );
        modelAssembler.setEmptyElementList(emptyElementList);
        modelAssembler.setClinicalDataResponse( clinicalDataResponse );
        modelAssembler.assembleModel( entryFilter, work );
        
        EasyMock.verify( clinicalDataResponse, entryFilter, queryAssociation, queryWork, clinicalDataDocument, clinicalDataElement,
                        clinicalDataPatientElement, queryWorkResultsElement, result1, result2, result3, result1Id, result2Id, result3Id );
    }
    
    

    @SuppressWarnings( "unchecked" )
    @Test( expected = ModelAssemblerException.class )
    @Suite( groups = { "checkintest" } )
    public void testAssembleModelSingleWorkPartialAssemblyError( )
        throws Exception
    {
        List<Element> resultsList = new ArrayList<Element>();

        // initialize mocks for test
        ClinicalDataResponseInterface clinicalDataResponse = EasyMock.createMock( ClinicalDataResponseInterface.class );
        EntryFilterInterface entryFilter = EasyMock.createMock( EntryFilterInterface.class );
        QueryAssociationInterface queryAssociation = EasyMock.createMock( QueryAssociationInterface.class );
        QueryWorkInterface queryWork = EasyMock.createMock( QueryWorkInterface.class );
        Document clinicalDataDocument = EasyMock.createMock( Document.class );
        Element clinicalDataElement = EasyMock.createMock( Element.class );
        Element clinicalDataPatientElement = EasyMock.createMock( Element.class );
        Element queryWorkResultsElement = EasyMock.createMock( Element.class );

        Element result1 = EasyMock.createMock( Element.class );
        resultsList.add( result1 );
        
        EasyMock.expect( entryFilter.getTemplateId() ).andReturn( "templateId" );
        EasyMock.expect( entryFilter.getRequestId() ).andReturn( "requestId" );
        EasyMock.expect( clinicalDataResponse.buildEmptyClinicalDocumentWithPatient( "templateId", "requestId" ) ).andReturn( clinicalDataDocument );
        EasyMock.expect(clinicalDataResponse.getClinicalRoot( clinicalDataDocument )).andReturn( clinicalDataPatientElement );
        EasyMock.expect( clinicalDataPatientElement.getUniquePath()).andReturn( "//patient" ).anyTimes();
        
        
        // patient level processing
        EasyMock.expect( queryWork.getQueryAssociation() ).andReturn( queryAssociation );
        EasyMock.expect( queryAssociation.getParentKey() ).andReturn( null );
        EasyMock.expect( queryWork.getResults() ).andReturn( queryWorkResultsElement );
        EasyMock.expect( queryWorkResultsElement.hasContent() ).andReturn( Boolean.TRUE );
        EasyMock.expect( queryWorkResultsElement.elements() ).andReturn( resultsList );

        // reslult1 processing
//        EasyMock.expect( queryAssociation.getAssociationParent() ).andReturn( "patient" );
        EasyMock.expect( clinicalDataPatientElement.selectNodes( "//patient" ) ).andReturn( null );

        // throw exception processing
        EasyMock.expect( entryFilter.getDomainEntryPoint() ).andReturn( DomainEntryPoint.AllergyAssessment.toString() );
        EasyMock.expect( queryWork.getQueryAssociation() ).andReturn( queryAssociation );
        EasyMock.expect( queryAssociation.getAssociationParent() ).andReturn( "patient" );
        
        
        // get ready to execute the test.
        EasyMock.replay( clinicalDataResponse, entryFilter, queryAssociation, queryWork, clinicalDataDocument, clinicalDataElement,
                        clinicalDataPatientElement, queryWorkResultsElement, result1 );

        List<QueryWorkInterface> work = new ArrayList<QueryWorkInterface>();
        work.add( queryWork );

        HibernateDomModelAssembler modelAssembler = new HibernateDomModelAssembler();
        modelAssembler.setClinicalDataResponse( clinicalDataResponse );
        modelAssembler.assembleModel( entryFilter, work );
        
        EasyMock.verify( clinicalDataResponse, entryFilter, queryAssociation, queryWork, clinicalDataDocument, clinicalDataElement,
                        clinicalDataPatientElement, queryWorkResultsElement, result1 );
    }


    /**
     * This test class mimics what is being done in the TIU 
     * clinical domain. This domain utilizes a multi-query 
     * approach for populating the logical model.
     * @throws Exception
     */
    @SuppressWarnings( "unchecked" )
    //@Test
    //@Suite( groups = { "brokentest" } )
    public void testAssembleModelMultiWork( )
        throws Exception
    {
        ////////////////////////////////////////////////////////////////////////
        // START MOCK CREATION
        ClinicalDataResponseInterface clinicalDataResponse = EasyMock.createMock( ClinicalDataResponseInterface.class );
        EntryFilterInterface entryFilter = EasyMock.createMock( EntryFilterInterface.class );

        // Create the Query Work and Query Associations mocks
        //  1) Create the patient QueryWork and QueryAssociation mocks
        QueryWorkInterface patientQueryWork = EasyMock.createMock( QueryWorkInterface.class );
        QueryAssociationInterface patientQueryAssociation = EasyMock.createMock( QueryAssociationInterface.class );

        //  2) Mock up some results for the patient QueryWork (3 results)
        Element patientQueryWorkResultsElement = EasyMock.createMock( Element.class );
        Element patientResult1 = EasyMock.createMock( Element.class );
        Element patientResult2 = EasyMock.createMock( Element.class );
        Element patientResult3 = EasyMock.createMock( Element.class );
        List<Element> patientResultsList = new ArrayList<Element>();
        patientResultsList.add( patientResult1 );
        patientResultsList.add( patientResult2 );
        patientResultsList.add( patientResult3 );

        //  3) Create the other expected cosigners QueryWork and QueryAssociation mocks.
        QueryWorkInterface otherExpectedCosignersQueryWork = EasyMock.createMock( QueryWorkInterface.class );
        QueryAssociationInterface otherExpectedCosignersQueryAssociation = EasyMock.createMock( QueryAssociationInterface.class );

        //  4) Mock up some results for the other expected cosigners QueryWork
        //     (one other expected cosigner per patient result)
        Element otherExpectedCosignersQueryWorkResultsElement = EasyMock.createMock( Element.class );
        Element otherExpectedCosignersResult1 = EasyMock.createMock( Element.class );
        Element otherExpectedCosignersResult2 = EasyMock.createMock( Element.class );
        Element otherExpectedCosignersResult3 = EasyMock.createMock( Element.class );
        List<Element> otherExpectedCosignersResultList = new ArrayList<Element>();
        otherExpectedCosignersResultList.add( otherExpectedCosignersResult1 );
        otherExpectedCosignersResultList.add( otherExpectedCosignersResult2 );
        otherExpectedCosignersResultList.add( otherExpectedCosignersResult3 );

        //  5) Create the other cosigners QueryWork and QueryAssociations mocks.
        QueryWorkInterface otherCosignersQueryWork = EasyMock.createMock( QueryWorkInterface.class );
        QueryAssociationInterface otherCosignersQueryAssociation = EasyMock.createMock( QueryAssociationInterface.class );

        //  6) Mock up some results for the other cosigners QueryWork
        //     (one other expected cosigner per patient result)
        Element otherCosignersQueryWorkResultsElement = EasyMock.createMock( Element.class );
        Element otherCosignersResult1 = EasyMock.createMock( Element.class );
        Element otherCosignersResult2 = EasyMock.createMock( Element.class );
        Element otherCosignersResult3 = EasyMock.createMock( Element.class );
        List<Element> otherCosignersResultList = new ArrayList<Element>();
        otherCosignersResultList.add( otherCosignersResult1 );
        otherCosignersResultList.add( otherCosignersResult2 );
        otherCosignersResultList.add( otherCosignersResult3 );

        //  7) Create the images QueryWork and QueryAssociation mocks.
        QueryWorkInterface imagesQueryWork = EasyMock.createMock( QueryWorkInterface.class );
        QueryAssociationInterface imagesQueryAssociation = EasyMock.createMock( QueryAssociationInterface.class );

        //  8) Mock up some results for the images QueryWork (in this case there
        //     will be only one patient result that has an images [patient2])
        Element imagesQueryWorkResultsElement = EasyMock.createMock( Element.class );
        Element imagesResult2 = EasyMock.createMock( Element.class );
        List<Element> imagesResultList = new ArrayList<Element>();
        imagesResultList.add( imagesResult2 );

        //  9) Create the document update events QueryWork and QueryAssociation mocks.
        QueryWorkInterface documentUpdateEventsQueryWork = EasyMock.createMock( QueryWorkInterface.class );
        QueryAssociationInterface documentUpdateEventsQueryAssociation = EasyMock.createMock( QueryAssociationInterface.class );

        // 10) Mock up the results for the document update events QueryWork (in this
        //     case there will be two document update events for each patient result).
        Element documentUpdateEventsQueryWorkResultsElement = EasyMock.createMock( Element.class );
        Element documentUpdateEventsResult1a = EasyMock.createMock( Element.class );
        Element documentUpdateEventsResult1b = EasyMock.createMock( Element.class );
        Element documentUpdateEventsResult2a = EasyMock.createMock( Element.class );
        Element documentUpdateEventsResult2b = EasyMock.createMock( Element.class );
        Element documentUpdateEventsResult3a = EasyMock.createMock( Element.class );
        Element documentUpdateEventsResult3b = EasyMock.createMock( Element.class );
        List<Element> documentUpdateEventsResultList = new ArrayList<Element>();
        documentUpdateEventsResultList.add( documentUpdateEventsResult1a );
        documentUpdateEventsResultList.add( documentUpdateEventsResult1b );
        documentUpdateEventsResultList.add( documentUpdateEventsResult2a );
        documentUpdateEventsResultList.add( documentUpdateEventsResult2b );
        documentUpdateEventsResultList.add( documentUpdateEventsResult3a );
        documentUpdateEventsResultList.add( documentUpdateEventsResult3b );

        // 11) Create the base for the aggregated document.
        Document clinicalDataDocument = EasyMock.createMock( Document.class );
        Element clinicalDataElement = EasyMock.createMock( Element.class );
        Element clinicalDataPatientElement = EasyMock.createMock( Element.class );

        // 12) Create an empty list mock that will be used to test that all 
        //     results were aggregated.
        List emptyQueryResults = EasyMock.createMock( List.class );

        // STOP MOCK CREATION
        ////////////////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////////////////
        // START MOCK EXPECTS

        // set the expectations on the mocks.
        EasyMock.expect( entryFilter.getTemplateId() ).andReturn( "templateId" );
        EasyMock.expect( entryFilter.getRequestId() ).andReturn( "requestId" );
        EasyMock.expect( clinicalDataResponse.buildEmptyClinicalDocumentWithPatient( "templateId", "requestId" ) ).andReturn( clinicalDataDocument );
        //EasyMock.expect( clinicalDataDocument.).andReturn( clinicalDataElement );
        //EasyMock.expect( clinicalDataElement.element( "patient" ) ).andReturn( clinicalDataPatientElement );
        EasyMock.expect( clinicalDataResponse.getClinicalRoot( clinicalDataDocument )).andReturn( clinicalDataPatientElement );
        EasyMock.expect( clinicalDataPatientElement.getUniquePath()).andReturn( "//patient" ).anyTimes();
        
        // patient level processing
        EasyMock.expect( clinicalDataPatientElement.getName() ).andReturn( "patient" );
        EasyMock.expect( clinicalDataPatientElement.selectNodes( "//id" ) ).andReturn( null ).anyTimes();
        EasyMock.expect( patientQueryWork.getQueryAssociation() ).andReturn( patientQueryAssociation );
        EasyMock.expect( patientQueryAssociation.getAssociationParent() ).andReturn( "patient" );
        EasyMock.expect( patientQueryWork.getResults() ).andReturn( patientQueryWorkResultsElement );
        EasyMock.expect( patientQueryWorkResultsElement.hasContent() ).andReturn( true );
        EasyMock.expect( patientQueryWorkResultsElement.elements() ).andReturn( patientResultsList );

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Patient Result 1 Assembling
        EasyMock.expect( patientQueryAssociation.getParentKey() ).andReturn( null );
        EasyMock.expect( patientQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( patientResult1.detach() ).andReturn( patientResult1 );
        clinicalDataPatientElement.add( patientResult1 );
        EasyMock.expect( patientQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( patientResult1.elementText( "id" ) ).andReturn( "1" );

        // patient result1 recursion
        EasyMock.expect( patientResult1.getName() ).andReturn( "patientResultsName" );
        //   patient work - association name no matchie
        EasyMock.expect( patientQueryWork.getQueryAssociation() ).andReturn( patientQueryAssociation );
        EasyMock.expect( patientQueryAssociation.getAssociationParent() ).andReturn( "patient" );
        //   other expected cosigners work - association name matches

        // other expected cosigners result1 assembling
        EasyMock.expect( otherExpectedCosignersQueryWork.getQueryAssociation() ).andReturn( otherExpectedCosignersQueryAssociation );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName" );
        EasyMock.expect( otherExpectedCosignersQueryWork.getResults() ).andReturn( otherExpectedCosignersQueryWorkResultsElement );
        EasyMock.expect( otherExpectedCosignersQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( otherExpectedCosignersQueryWorkResultsElement.elements() ).andReturn( otherExpectedCosignersResultList );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult1.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( otherExpectedCosignersResult1.detach() ).andReturn( otherExpectedCosignersResult1 );
        patientResult1.add( otherExpectedCosignersResult1 );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( otherExpectedCosignersResult1.elementText( "id" ) ).andReturn( "11" );
        expectQueryWorkCheck( otherExpectedCosignersResult1, "otherExpectedCosigners", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( otherExpectedCosignersResult1, "otherExpectedCosigners", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult1, "otherExpectedCosigners", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult1, "otherExpectedCosigners", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult1, "otherExpectedCosigners", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult2.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult3.elementText( "patientResultId" ) ).andReturn( "3" );

        //  other cosigners work - association name matches
        EasyMock.expect( otherCosignersQueryWork.getQueryAssociation() ).andReturn( otherCosignersQueryAssociation );
        EasyMock.expect( otherCosignersQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName" );
        EasyMock.expect( otherCosignersQueryWork.getResults() ).andReturn( otherCosignersQueryWorkResultsElement );
        EasyMock.expect( otherCosignersQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( otherCosignersQueryWorkResultsElement.elements() ).andReturn( otherCosignersResultList );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult1.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( otherCosignersResult1.detach() ).andReturn( otherCosignersResult1 );
        patientResult1.add( otherCosignersResult1 );
        EasyMock.expect( otherCosignersQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( otherCosignersResult1.elementText( "id" ) ).andReturn( "12" );
        expectQueryWorkCheck( otherCosignersResult1, "otherCosigners", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( otherCosignersResult1, "otherCosigners", otherExpectedCosignersQueryWork, otherExpectedCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( otherCosignersResult1, "otherCosigners", otherCosignersQueryWork, otherCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( otherCosignersResult1, "otherCosigners", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( otherCosignersResult1, "otherCosigners", documentUpdateEventsQueryWork, documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult2.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult3.elementText( "patientResultId" ) ).andReturn( "3" );

        //  images work - association name matches
        EasyMock.expect( imagesQueryWork.getQueryAssociation() ).andReturn( imagesQueryAssociation );
        EasyMock.expect( imagesQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName" );
        EasyMock.expect( imagesQueryWork.getResults() ).andReturn( imagesQueryWorkResultsElement );
        EasyMock.expect( imagesQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( imagesQueryWorkResultsElement.elements() ).andReturn( imagesResultList );
        EasyMock.expect( imagesQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( imagesQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( imagesResult2.elementText( "patientResultId" ) ).andReturn( "2" );

        //  document update events - association name matches
        EasyMock.expect( documentUpdateEventsQueryWork.getQueryAssociation() ).andReturn( documentUpdateEventsQueryAssociation );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName" );
        EasyMock.expect( documentUpdateEventsQueryWork.getResults() ).andReturn( documentUpdateEventsQueryWorkResultsElement );
        EasyMock.expect( documentUpdateEventsQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( documentUpdateEventsQueryWorkResultsElement.elements() ).andReturn( documentUpdateEventsResultList );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult1a.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( documentUpdateEventsResult1a.detach() ).andReturn( documentUpdateEventsResult1a );
        patientResult1.add( documentUpdateEventsResult1a );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( documentUpdateEventsResult1a.elementText( "id" ) ).andReturn( "13" );

        expectQueryWorkCheck( documentUpdateEventsResult1a, "documentUpdateEvents", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( documentUpdateEventsResult1a, "documentUpdateEvents", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult1a, "documentUpdateEvents", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult1a, "documentUpdateEvents", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult1a, "documentUpdateEvents", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult1b.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( documentUpdateEventsResult1b.detach() ).andReturn( documentUpdateEventsResult1b );
        patientResult1.add( documentUpdateEventsResult1b );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( documentUpdateEventsResult1b.elementText( "id" ) ).andReturn( "14" );
        expectQueryWorkCheck( documentUpdateEventsResult1b, "documentUpdateEvents", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( documentUpdateEventsResult1b, "documentUpdateEvents", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult1b, "documentUpdateEvents", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult1b, "documentUpdateEvents", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult1b, "documentUpdateEvents", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult2a.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult2b.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult3a.elementText( "patientResultId" ) ).andReturn( "3" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult3b.elementText( "patientResultId" ) ).andReturn( "3" );
        // End Patient Result 1 Assembling
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Patient Result 2 Assembling
        EasyMock.expect( patientQueryAssociation.getParentKey() ).andReturn( null );
        EasyMock.expect( patientQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( patientResult2.detach() ).andReturn( patientResult2 );
        clinicalDataPatientElement.add( patientResult2 );
        EasyMock.expect( patientQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( patientResult2.elementText( "id" ) ).andReturn( "2" );

        // patient result2 recursion
        EasyMock.expect( patientResult2.getName() ).andReturn( "patientResultsName2" );
        //   patient work - association name no match
        EasyMock.expect( patientQueryWork.getQueryAssociation() ).andReturn( patientQueryAssociation );
        EasyMock.expect( patientQueryAssociation.getAssociationParent() ).andReturn( "patient" );

        // other expected cosigners result2 assembling
        EasyMock.expect( otherExpectedCosignersQueryWork.getQueryAssociation() ).andReturn( otherExpectedCosignersQueryAssociation );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName2" );
        EasyMock.expect( otherExpectedCosignersQueryWork.getResults() ).andReturn( otherExpectedCosignersQueryWorkResultsElement );
        EasyMock.expect( otherExpectedCosignersQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( otherExpectedCosignersQueryWorkResultsElement.elements() ).andReturn( otherExpectedCosignersResultList );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult1.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult2.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( otherExpectedCosignersResult2.detach() ).andReturn( otherExpectedCosignersResult2 );
        patientResult2.add( otherExpectedCosignersResult2 );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( otherExpectedCosignersResult2.elementText( "id" ) ).andReturn( "21" );
        expectQueryWorkCheck( otherExpectedCosignersResult2, "otherExpectedCosigners", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( otherExpectedCosignersResult2, "otherExpectedCosigners", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult2, "otherExpectedCosigners", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult2, "otherExpectedCosigners", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult2, "otherExpectedCosigners", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult3.elementText( "patientResultId" ) ).andReturn( "3" );

        //  other cosigners work - association name matches
        EasyMock.expect( otherCosignersQueryWork.getQueryAssociation() ).andReturn( otherCosignersQueryAssociation );
        EasyMock.expect( otherCosignersQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName2" );
        EasyMock.expect( otherCosignersQueryWork.getResults() ).andReturn( otherCosignersQueryWorkResultsElement );
        EasyMock.expect( otherCosignersQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( otherCosignersQueryWorkResultsElement.elements() ).andReturn( otherCosignersResultList );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult1.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult2.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( otherCosignersResult2.detach() ).andReturn( otherCosignersResult2 );
        patientResult2.add( otherCosignersResult2 );
        EasyMock.expect( otherCosignersQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( otherCosignersResult2.elementText( "id" ) ).andReturn( "22" );
        expectQueryWorkCheck( otherCosignersResult2, "otherCosigners", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( otherCosignersResult2, "otherCosigners", otherExpectedCosignersQueryWork, otherExpectedCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( otherCosignersResult2, "otherCosigners", otherCosignersQueryWork, otherCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( otherCosignersResult2, "otherCosigners", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( otherCosignersResult2, "otherCosigners", documentUpdateEventsQueryWork, documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult3.elementText( "patientResultId" ) ).andReturn( "3" );

        //  images work - association name matches
        EasyMock.expect( imagesQueryWork.getQueryAssociation() ).andReturn( imagesQueryAssociation );
        EasyMock.expect( imagesQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName2" );
        EasyMock.expect( imagesQueryWork.getResults() ).andReturn( imagesQueryWorkResultsElement );
        EasyMock.expect( imagesQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( imagesQueryWorkResultsElement.elements() ).andReturn( imagesResultList );
        EasyMock.expect( imagesQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( imagesQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( imagesResult2.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( imagesResult2.detach() ).andReturn( imagesResult2 );
        patientResult2.add( imagesResult2 );
        EasyMock.expect( imagesQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( imagesResult2.elementText( "id" ) ).andReturn( "23" );
        expectQueryWorkCheck( imagesResult2, "images", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( imagesResult2, "images", otherExpectedCosignersQueryWork, otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( imagesResult2, "images", otherCosignersQueryWork, otherCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( imagesResult2, "images", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( imagesResult2, "images", documentUpdateEventsQueryWork, documentUpdateEventsQueryAssociation, "patient" );

        //  document update events - association name matches
        EasyMock.expect( documentUpdateEventsQueryWork.getQueryAssociation() ).andReturn( documentUpdateEventsQueryAssociation );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName2" );
        EasyMock.expect( documentUpdateEventsQueryWork.getResults() ).andReturn( documentUpdateEventsQueryWorkResultsElement );
        EasyMock.expect( documentUpdateEventsQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( documentUpdateEventsQueryWorkResultsElement.elements() ).andReturn( documentUpdateEventsResultList );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult1a.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult1b.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult2a.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( documentUpdateEventsResult2a.detach() ).andReturn( documentUpdateEventsResult2a );
        patientResult2.add( documentUpdateEventsResult2a );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( documentUpdateEventsResult2a.elementText( "id" ) ).andReturn( "24" );
        expectQueryWorkCheck( documentUpdateEventsResult2a, "documentUpdateEvents", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( documentUpdateEventsResult2a, "documentUpdateEvents", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult2a, "documentUpdateEvents", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult2a, "documentUpdateEvents", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult2a, "documentUpdateEvents", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult2b.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( documentUpdateEventsResult2b.detach() ).andReturn( documentUpdateEventsResult2b );
        patientResult2.add( documentUpdateEventsResult2b );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( documentUpdateEventsResult2b.elementText( "id" ) ).andReturn( "25" );
        expectQueryWorkCheck( documentUpdateEventsResult2b, "documentUpdateEvents", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( documentUpdateEventsResult2b, "documentUpdateEvents", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult2b, "documentUpdateEvents", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult2b, "documentUpdateEvents", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult2b, "documentUpdateEvents", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult3a.elementText( "patientResultId" ) ).andReturn( "3" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult3b.elementText( "patientResultId" ) ).andReturn( "3" );
        // Stop Patient Result 2 ASsembling
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Patient Result 3 Assembling
        EasyMock.expect( patientQueryAssociation.getParentKey() ).andReturn( null );
        EasyMock.expect( patientQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( patientResult3.detach() ).andReturn( patientResult3 );
        clinicalDataPatientElement.add( patientResult3 );
        EasyMock.expect( patientQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( patientResult3.elementText( "id" ) ).andReturn( "3" );

        // patient result3 recursion
        EasyMock.expect( patientResult3.getName() ).andReturn( "patientResultsName3" );
        //   patient work - association name no matchie
        EasyMock.expect( patientQueryWork.getQueryAssociation() ).andReturn( patientQueryAssociation );
        EasyMock.expect( patientQueryAssociation.getAssociationParent() ).andReturn( "patient" );
        //   other expected cosigners work - association name matches

        // other expected cosigners result3 assembling
        EasyMock.expect( otherExpectedCosignersQueryWork.getQueryAssociation() ).andReturn( otherExpectedCosignersQueryAssociation );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName3" );
        EasyMock.expect( otherExpectedCosignersQueryWork.getResults() ).andReturn( otherExpectedCosignersQueryWorkResultsElement );
        EasyMock.expect( otherExpectedCosignersQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( otherExpectedCosignersQueryWorkResultsElement.elements() ).andReturn( otherExpectedCosignersResultList );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult1.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult2.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherExpectedCosignersResult3.elementText( "patientResultId" ) ).andReturn( "3" );
        EasyMock.expect( otherExpectedCosignersResult3.detach() ).andReturn( otherExpectedCosignersResult3 );
        patientResult3.add( otherExpectedCosignersResult3 );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( otherExpectedCosignersResult3.elementText( "id" ) ).andReturn( "31" );
        expectQueryWorkCheck( otherExpectedCosignersResult3, "otherExpectedCosigners", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( otherExpectedCosignersResult3, "otherExpectedCosigners", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult3, "otherExpectedCosigners", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult3, "otherExpectedCosigners", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( otherExpectedCosignersResult3, "otherExpectedCosigners", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );

        //  other cosigners work - association name matches
        EasyMock.expect( otherCosignersQueryWork.getQueryAssociation() ).andReturn( otherCosignersQueryAssociation );
        EasyMock.expect( otherCosignersQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName3" );
        EasyMock.expect( otherCosignersQueryWork.getResults() ).andReturn( otherCosignersQueryWorkResultsElement );
        EasyMock.expect( otherCosignersQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( otherCosignersQueryWorkResultsElement.elements() ).andReturn( otherCosignersResultList );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult1.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult2.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( otherCosignersQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( otherCosignersQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( otherCosignersResult3.elementText( "patientResultId" ) ).andReturn( "3" );
        EasyMock.expect( otherCosignersResult3.detach() ).andReturn( otherCosignersResult3 );
        patientResult3.add( otherCosignersResult3 );
        EasyMock.expect( otherCosignersQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( otherCosignersResult3.elementText( "id" ) ).andReturn( "32" );
        expectQueryWorkCheck( otherCosignersResult3, "otherCosigners", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( otherCosignersResult3, "otherCosigners", otherExpectedCosignersQueryWork, otherExpectedCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( otherCosignersResult3, "otherCosigners", otherCosignersQueryWork, otherCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( otherCosignersResult3, "otherCosigners", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( otherCosignersResult3, "otherCosigners", documentUpdateEventsQueryWork, documentUpdateEventsQueryAssociation, "patient" );

        //  images work - association name matches
        EasyMock.expect( imagesQueryWork.getQueryAssociation() ).andReturn( imagesQueryAssociation );
        EasyMock.expect( imagesQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName3" );
        EasyMock.expect( imagesQueryWork.getResults() ).andReturn( imagesQueryWorkResultsElement );
        EasyMock.expect( imagesQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( imagesQueryWorkResultsElement.elements() ).andReturn( imagesResultList );
        EasyMock.expect( imagesQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( imagesQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( imagesResult2.elementText( "patientResultId" ) ).andReturn( "2" );

        //  document update events - association name matches
        EasyMock.expect( documentUpdateEventsQueryWork.getQueryAssociation() ).andReturn( documentUpdateEventsQueryAssociation );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getAssociationParent() ).andReturn( "patientResultsName3" );
        EasyMock.expect( documentUpdateEventsQueryWork.getResults() ).andReturn( documentUpdateEventsQueryWorkResultsElement );
        EasyMock.expect( documentUpdateEventsQueryWorkResultsElement.hasContent() ).andReturn( Boolean.valueOf( true ) );
        EasyMock.expect( documentUpdateEventsQueryWorkResultsElement.elements() ).andReturn( documentUpdateEventsResultList );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult1a.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult1b.elementText( "patientResultId" ) ).andReturn( "1" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult2a.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult2b.elementText( "patientResultId" ) ).andReturn( "2" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult3a.elementText( "patientResultId" ) ).andReturn( "3" );
        EasyMock.expect( documentUpdateEventsResult3a.detach() ).andReturn( documentUpdateEventsResult3a );
        patientResult3.add( documentUpdateEventsResult3a );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( documentUpdateEventsResult3a.elementText( "id" ) ).andReturn( "33" );
        expectQueryWorkCheck( documentUpdateEventsResult3a, "documentUpdateEvents", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( documentUpdateEventsResult3a, "documentUpdateEvents", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult3a, "documentUpdateEvents", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult3a, "documentUpdateEvents", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult3a, "documentUpdateEvents", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getParentKey() ).andReturn( "patientResultId" );
        EasyMock.expect( documentUpdateEventsQueryAssociation.isCollapsable() ).andReturn( false );
        EasyMock.expect( documentUpdateEventsResult3b.elementText( "patientResultId" ) ).andReturn( "3" );
        EasyMock.expect( documentUpdateEventsResult3b.detach() ).andReturn( documentUpdateEventsResult3b );
        patientResult3.add( documentUpdateEventsResult3b );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getKey() ).andReturn( "id" );
        EasyMock.expect( documentUpdateEventsResult3b.elementText( "id" ) ).andReturn( "34" );
        expectQueryWorkCheck( documentUpdateEventsResult3b, "documentUpdateEvents", patientQueryWork, patientQueryAssociation, null );
        expectQueryWorkCheck( documentUpdateEventsResult3b, "documentUpdateEvents", otherExpectedCosignersQueryWork,
                        otherExpectedCosignersQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult3b, "documentUpdateEvents", otherCosignersQueryWork, otherCosignersQueryAssociation,
                        "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult3b, "documentUpdateEvents", imagesQueryWork, imagesQueryAssociation, "patient" );
        expectQueryWorkCheck( documentUpdateEventsResult3b, "documentUpdateEvents", documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, "patient" );
        // End Patient Result 3 Assembling
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        EasyMock.expect( otherExpectedCosignersQueryWork.getQueryAssociation() ).andReturn( otherExpectedCosignersQueryAssociation );
        EasyMock.expect( otherExpectedCosignersQueryAssociation.getAssociationParent() ).andReturn( "otherExpectedCosigners" );

        EasyMock.expect( otherCosignersQueryWork.getQueryAssociation() ).andReturn( otherCosignersQueryAssociation );
        EasyMock.expect( otherCosignersQueryAssociation.getAssociationParent() ).andReturn( "otherCosigners" );

        EasyMock.expect( imagesQueryWork.getQueryAssociation() ).andReturn( imagesQueryAssociation );
        EasyMock.expect( imagesQueryAssociation.getAssociationParent() ).andReturn( "images" );

        EasyMock.expect( documentUpdateEventsQueryWork.getQueryAssociation() ).andReturn( documentUpdateEventsQueryAssociation );
        EasyMock.expect( documentUpdateEventsQueryAssociation.getAssociationParent() ).andReturn( "documentUpdateEvents" );

        // Iterate over the work checking to see that all query work results elements 
        // have no child elements.
        EasyMock.expect( patientQueryWork.getResults() ).andReturn( patientQueryWorkResultsElement );
        EasyMock.expect( patientQueryWorkResultsElement.elements() ).andReturn( emptyQueryResults );
        EasyMock.expect( emptyQueryResults.size() ).andReturn( Integer.valueOf( 0 ) );

        EasyMock.expect( otherExpectedCosignersQueryWork.getResults() ).andReturn( otherExpectedCosignersQueryWorkResultsElement );
        EasyMock.expect( otherExpectedCosignersQueryWorkResultsElement.elements() ).andReturn( emptyQueryResults );
        EasyMock.expect( emptyQueryResults.size() ).andReturn( Integer.valueOf( 0 ) );

        EasyMock.expect( otherCosignersQueryWork.getResults() ).andReturn( otherCosignersQueryWorkResultsElement );
        EasyMock.expect( otherCosignersQueryWorkResultsElement.elements() ).andReturn( emptyQueryResults );
        EasyMock.expect( emptyQueryResults.size() ).andReturn( Integer.valueOf( 0 ) );

        EasyMock.expect( imagesQueryWork.getResults() ).andReturn( imagesQueryWorkResultsElement );
        EasyMock.expect( imagesQueryWorkResultsElement.elements() ).andReturn( emptyQueryResults );
        EasyMock.expect( emptyQueryResults.size() ).andReturn( Integer.valueOf( 0 ) );

        EasyMock.expect( documentUpdateEventsQueryWork.getResults() ).andReturn( documentUpdateEventsQueryWorkResultsElement );
        EasyMock.expect( documentUpdateEventsQueryWorkResultsElement.elements() ).andReturn( emptyQueryResults );
        EasyMock.expect( emptyQueryResults.size() ).andReturn( Integer.valueOf( 0 ) );

        // STOP MOCK EXPECTS
        ////////////////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////////////////
        // REPLAY THE MOCKS
        EasyMock.replay( clinicalDataResponse, entryFilter, patientQueryWork, patientQueryAssociation, patientQueryWorkResultsElement,
                        patientResult1, patientResult2, patientResult3, otherExpectedCosignersQueryWork, otherExpectedCosignersQueryAssociation,
                        otherExpectedCosignersQueryWorkResultsElement, otherExpectedCosignersResult1, otherExpectedCosignersResult2,
                        otherExpectedCosignersResult3, otherCosignersQueryWork, otherCosignersQueryAssociation,
                        otherCosignersQueryWorkResultsElement, otherCosignersResult1, otherCosignersResult2, otherCosignersResult3, imagesQueryWork,
                        imagesQueryAssociation, imagesQueryWorkResultsElement, imagesResult2, documentUpdateEventsQueryWork,
                        documentUpdateEventsQueryAssociation, documentUpdateEventsQueryWorkResultsElement, documentUpdateEventsResult1a,
                        documentUpdateEventsResult1b, documentUpdateEventsResult2a, documentUpdateEventsResult2b, documentUpdateEventsResult3a,
                        documentUpdateEventsResult3b, clinicalDataDocument, clinicalDataElement, clinicalDataPatientElement, emptyQueryResults );
        // REPLAY MOCKS - STOP
        ////////////////////////////////////////////////////////////////////////

        List<QueryWorkInterface> work = new ArrayList<QueryWorkInterface>();
        work.add( patientQueryWork );
        work.add( otherExpectedCosignersQueryWork );
        work.add( otherCosignersQueryWork );
        work.add( imagesQueryWork );
        work.add( documentUpdateEventsQueryWork );

        HibernateDomModelAssembler modelAssembler = new HibernateDomModelAssembler();
        modelAssembler.setClinicalDataResponse( clinicalDataResponse );
        modelAssembler.assembleModel( entryFilter, work );
    }


    private void expectQueryWorkCheck( Element parent, String parentName, QueryWorkInterface queryWork, QueryAssociationInterface queryAssociation,
                    String associationName )
    {
        EasyMock.expect( parent.getName() ).andReturn( parentName );
        EasyMock.expect( queryWork.getQueryAssociation() ).andReturn( queryAssociation );
        EasyMock.expect( queryAssociation.getAssociationParent() ).andReturn( associationName );
    }
}
