package gov.va.med.cds.persistence;

import static org.easymock.EasyMock.expect;
import static org.junit.Assert.assertNotNull;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.persistence.hibernate.ModelAssemblerInterface;
import gov.va.med.cds.persistence.hibernate.common.VistaPointInTimeUserType;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshaller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.easymock.EasyMock;
import org.hibernate.SessionFactory;
import org.hibernate.Session;
import org.junit.Test;

public class DefaultAssociationBasedQueryStrategyTest
{

    @Test
    @Suite( groups = { "checkintest" } )
    public void testCreateQueryWork()
    {
  
        DefaultAssociationBasedQueryStrategy associationBasedQueryStrategy = new DefaultAssociationBasedQueryStrategy();
        QueryAssociationInterface queryAssociation = EasyMock.createMock(QueryAssociationInterface.class);
        Map<String, QueryAssociationInterface> templateAssociationMap = new HashMap<String, QueryAssociationInterface>();
        templateAssociationMap.put( "key", queryAssociation );
        ModelAssemblerInterface modelAssembler = EasyMock.createMock( ModelAssemblerInterface.class );
        
        associationBasedQueryStrategy.setQueryPlanMap( templateAssociationMap );
        associationBasedQueryStrategy.setModelAssembler( modelAssembler );
        
        SessionFactory sessionFactory = EasyMock.createMock( SessionFactory.class );
        EntryFilterInterface entryFilter = EasyMock.createMock( EntryFilterInterface.class );
        List<String> personIdentifiers = new ArrayList<String>();
        
        Session session = EasyMock.createMock( Session.class );
        expect(sessionFactory.openSession()).andReturn( session );
        
        EasyMock.replay( entryFilter, sessionFactory, session);   
        
        //TODO get a meaningful value
        String siteId=null;
        
        List<QueryWorkInterface> queryWork = associationBasedQueryStrategy.createQueryWork( sessionFactory, entryFilter, personIdentifiers, VistaPointInTimeUserType.class, siteId, new JaxBMarshallerUnmarshaller() );
        assertNotNull(queryWork);
        //for coverage only
        assertNotNull(associationBasedQueryStrategy.getModelAssembler());
        
        EasyMock.verify( entryFilter, sessionFactory, session);   
    }
}
