

package gov.va.med.cds.integration.vim.ha;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAContactLogBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAPatientJournalEntryContactLogBuilderFactory;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndPatientContactLogJournalEntryTest
    extends
        AbstractHealthAdapterEndToEndTest
{
    private static String DOMAINENTRYPOINT_XPATH = "//PatientEnteredContactLogJournalEntry";
    private static String TEST_READ_JOURNAL_ENTRY_XPATH = "//genericJournalEntryDetails/patient";


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testCreateAndDeletePatientContactLogJournalEntrySingle( )
        throws Exception
    {
        // Create journal entry
        String createRequestXml = createHACreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, null,
                        "personContacted", 1 );
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );

        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() == 1 );
        String recordIdentifier = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        // Physical delete journal entry
        String deleteRequestXML = deleteHACreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier, false );
        Document clinicalDataDocumentDelete = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteRequestXML, "CONTACT_LOG_JOURNAL", "CONTACT_LOG_JOURNAL_ID", false );
        assertNotNull( clinicalDataDocumentDelete );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testContactLogJournalDetailsCRUD( )
        throws Exception
    {
    	String basePatientId = "contact_log_integration_test_patient_";
    	String patientId = basePatientId + (int)(Math.random()*100000000);
    	
        /// clear out any mood journal test records 
        hdrJdbcTemplate.update( "delete from contact_log_journal where patient_identity like '"+basePatientId+"%'" );

        /// CREATE
        String createRequestXml = createHACreateXml( patientId, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, null,
                        "personContacted", 1, true );
        Document createRequest = DocumentHelper.parseText(createRequestXml);
        String hexBinaryAttachmentName = createRequest.selectSingleNode("//hexBinaryAttachment").getParent().elementText("name");
        int hexBinaryLengthIn=createRequest.selectSingleNode("//hexBinaryAttachment").getText().length();
        String base64BinaryAttachmentName = createRequest.selectSingleNode("//base64BinaryAttachment").getParent().elementText("name");
        
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );
        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() == 1 );
        String recordIdentifier = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        /// DETAIL READ for HexBinaryAttachment
        Map<String,String> otherQueryParameters = new HashMap<String,String>();
        otherQueryParameters.put("attachmentName", hexBinaryAttachmentName);
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();
        String filterXml = FilterBuilder.buildHealthAdapterJournalDetailsFilter("PatientEnteredContactLogJournalEntry", recordIdentifier, otherQueryParameters);
        Document readResponseWithHex = readAndAssertDomainData( assigningAuthorityAndFacilityMap,
                        TemplateIdHelper.HEALTH_ADAPTER_JOURNAL_DETAIL_READ1_TEMPLATE_ID, filterXml, TemplateIdHelper.HEALTH_ADAPTER_JOURNAL_DETAIL_FILTER,
                        "//genericJournalEntryDetails/patient", 1 );
        List<Element> dataList = readResponseWithHex.selectNodes( "//patients/patient/patientJournalEntries" );
        assertTrue( dataList.size() > 0 );
        List<Element> attachmentList = readResponseWithHex.selectNodes("//binaryAttachments/binaryAttachment/hexBinaryAttachment");
        assertTrue( attachmentList.size()==1);
        int hexBinaryLengthOut = readResponseWithHex.selectSingleNode("//hexBinaryAttachment").getText().length();
        String failureMessage = "The hex binary attachment from the create request does not have the same length as the hex binary attachment from the detail read request";
        assertTrue( failureMessage, hexBinaryLengthIn==hexBinaryLengthOut);
        
        
        /// DETAIL READ for Base64BinaryAttachment
        otherQueryParameters.put("attachmentName", base64BinaryAttachmentName);
        filterXml = FilterBuilder.buildHealthAdapterJournalDetailsFilter("PatientEnteredContactLogJournalEntry", recordIdentifier, otherQueryParameters);
        Document readResponseWithBase64BinaryAttachment = readAndAssertDomainData( assigningAuthorityAndFacilityMap,
                        TemplateIdHelper.HEALTH_ADAPTER_JOURNAL_DETAIL_READ1_TEMPLATE_ID, filterXml, TemplateIdHelper.HEALTH_ADAPTER_JOURNAL_DETAIL_FILTER,
                        "//genericJournalEntryDetails/patient", 1 );
        dataList = readResponseWithBase64BinaryAttachment.selectNodes( "//patients/patient/patientJournalEntries" );
        assertTrue( dataList.size() > 0 );
        attachmentList = readResponseWithBase64BinaryAttachment.selectNodes("//binaryAttachments/binaryAttachment/base64BinaryAttachment");
        assertTrue( attachmentList.size()==1);

        
        
        /// UPDATE 
        String updateRequestXml = createHACreateXml( patientId, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_UPDATE1_TEMPLATE_ID, recordIdentifier,
                        "personContactedUpdated", 1 );
        Document updateRequest = DocumentHelper.parseText(updateRequestXml);
        String attachmentName2 = updateRequest.selectSingleNode("//binaryAttachments/binaryAttachment/name").getText();
        otherQueryParameters.put("attachmentName", attachmentName2);
        Document clinicalDataDocumentUpdate = updateAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_UPDATE1_TEMPLATE_ID, updateRequestXml, "CONTACT_LOG_JOURNAL", "CONTACT_LOG_JOURNAL_ID" );
        assertNotNull( clinicalDataDocumentUpdate );
        
        /// set the attachment name based on the updated hexBinaryAttachmentName
        hexBinaryAttachmentName = updateRequest.selectSingleNode("//hexBinaryAttachment").getParent().elementText("name");
        otherQueryParameters.put("attachmentName", hexBinaryAttachmentName);
        updateRequest=null;
        
        /// DETAIL READ after update - just read the update hex binary attachment and ignore the other three
        Map<String, String> assigningAuthorityAndFacilityMap2 = new HashMap<String, String>();
        String filterXml2 = FilterBuilder.buildHealthAdapterJournalDetailsFilter("PatientEnteredContactLogJournalEntry", recordIdentifier, otherQueryParameters);
        Document readResponseAfterUpdateWithName = readAndAssertDomainData( assigningAuthorityAndFacilityMap2,
                        TemplateIdHelper.HEALTH_ADAPTER_JOURNAL_DETAIL_READ1_TEMPLATE_ID, filterXml2, TemplateIdHelper.HEALTH_ADAPTER_JOURNAL_DETAIL_FILTER,
                        "//genericJournalEntryDetails/patient", 1 );
        List<Element> dataList2 = readResponseAfterUpdateWithName.selectNodes( "//patients/patient/patientJournalEntries" );
        assertTrue( dataList2.size() > 0 );
        List<Node> attachments = readResponseAfterUpdateWithName.selectNodes("//binaryAttachment");
        assertTrue( attachments.size()==1);  /// only one attachment returned with attachment name restriction
        
        /// DETAIL READ after update without name
        String filterXml3 = FilterBuilder.buildHealthAdapterJournalDetailsFilter("PatientEnteredContactLogJournalEntry", recordIdentifier, null);
        Document readResponseAfterUpdateWithoutName = readAndAssertDomainData( assigningAuthorityAndFacilityMap2,
                        TemplateIdHelper.HEALTH_ADAPTER_JOURNAL_DETAIL_READ1_TEMPLATE_ID, filterXml3, TemplateIdHelper.HEALTH_ADAPTER_JOURNAL_DETAIL_FILTER,
                        "//genericJournalEntryDetails/patient", 1 );
        List<Element> dataList3 = readResponseAfterUpdateWithoutName.selectNodes( "//patients/patient/patientJournalEntries" );
        assertTrue( dataList3.size() > 0 );
        List<Node> attachments3 = readResponseAfterUpdateWithoutName.selectNodes("//binaryAttachment");
        assertTrue( attachments3.size()==4);  /// two attachments returned without name restriction

        /// READ after update
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "PatientEnteredContactLogJournalEntry" );
        String readAfterUpdateFilterXml = createHAFilterXml( patientId, null, ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, "PatientEnteredContactLogJournalEntry",
                        TemplateIdHelper.HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );
        Document readResponseAfterUpdate = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.HEALTH_ADAPTER_READ1_TEMPLATE_ID, readAfterUpdateFilterXml,
                        TemplateIdHelper.HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER, DOMAINENTRYPOINT_XPATH );
        dataList = readResponseAfterUpdate.selectNodes( TEST_READ_JOURNAL_ENTRY_XPATH );
        assertTrue( dataList.size() > 0 );
        
        // Physical delete journal entry
        String deleteRequestXML = deleteHACreateXml( patientId, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier, false );
        Document clinicalDataDocumentDelete = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteRequestXML, "CONTACT_LOG_JOURNAL", "CONTACT_LOG_JOURNAL_ID", false);
        assertNotNull( clinicalDataDocumentDelete );
    }

    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testCreateUpdateDeletePatientContactLogJournalEntrySingle( )
        throws Exception
    {
        // Create journal entry
        String createRequestXml = createHACreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, null,
                        "personContacted", 1 );
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );

        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() == 1 );
        String recordIdentifier = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        // Update journal entry
        String updateRequestXml = createHACreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_UPDATE1_TEMPLATE_ID, recordIdentifier,
                        "personContactedUpdated", 1 );
        Document clinicalDataDocumentUpdate = updateAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_UPDATE1_TEMPLATE_ID, updateRequestXml, "CONTACT_LOG_JOURNAL", "CONTACT_LOG_JOURNAL_ID" );
        assertNotNull( clinicalDataDocumentUpdate );

        // Physical delete journal entry
        String deleteRequestXML = deleteHACreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier, false );
        Document clinicalDataDocumentDelete = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteRequestXML, "CONTACT_LOG_JOURNAL", "CONTACT_LOG_JOURNAL_ID", false);
        assertNotNull( clinicalDataDocumentDelete );
    }



    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testCreateLogicalPhysicalDeletePatientContactLogJournalEntrySingle( )
        throws Exception
    {
        // Create journal entry
        String createRequestXml = createHACreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, null,
                        "personContacted", 1 );
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );

        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() == 1 );
        String recordIdentifier = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        // Logical delete journal entry
        String logicalDeleteRequestXML = deleteHACreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID,
                        recordIdentifier, true );
        Document clinicalDataDocumentLogicalDelete = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, logicalDeleteRequestXML, "CONTACT_LOG_JOURNAL", "CONTACT_LOG_JOURNAL_ID", true);
        assertNotNull( clinicalDataDocumentLogicalDelete );

        // Physical delete journal entry
        String physicalDeleteRequestXML = deleteHACreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID,
                        recordIdentifier, false );
        Document clinicalDataDocumentPhysicalDelete = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, physicalDeleteRequestXML, "CONTACT_LOG_JOURNAL", "CONTACT_LOG_JOURNAL_ID", false );
        assertNotNull( clinicalDataDocumentPhysicalDelete );
    }


    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testCreatePatientContactLogJournalEntryInvalid( )
        throws Exception
    {
        // Create journal entry with no patient identity
        String createRequestXml = createHACreateXml( "", "PatientEnteredContactLogJournalEntry", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, null, "personContacted", 1 );

        Document clinicalDataDocument = requestProcessor.createClinicalData( createRequestXml, TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        Element exceptionElement = ( Element )clinicalDataDocument.selectSingleNode( FATAL_ERRORS_EXCEPTIONS_XPATH );
        assertNotNull( exceptionElement );
        assertTrue( exceptionElement.getText().endsWith( "SchemaValidationException" ) );
    }


    protected String createHACreateXml( String patientIdentifier, String entryPoint, String templateId, String recordIdentifier, String personContacted, int count, boolean createTwoAttachmentsWithSameName )
    {
        Map<String, DomainEntryPoint> domainEntryPointsMap = new HashMap<String, DomainEntryPoint>();
        domainEntryPointsMap.put( templateId, DomainEntryPoint.PatientEnteredContactLogJournalEntry );
        ClinicalDataBuilder clinicalDataBuilder = new ClinicalDataBuilder();
        clinicalDataBuilder.setDomainEntryPointsMap( domainEntryPointsMap );

        Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap = new HashMap<String, ClinicalDomainBuilderFactoryInterface>();
        HAPatientJournalEntryContactLogBuilderFactory factory = new HAPatientJournalEntryContactLogBuilderFactory();
        factory.setContactLogBuilder( new HAContactLogBuilder( recordIdentifier, personContacted, createTwoAttachmentsWithSameName ) );
        domainEntryPointsWrappersMap.put( "PatientEnteredContactLogJournalEntry", factory );
        clinicalDataBuilder.setDomainEntryPointsWrappersMap( domainEntryPointsWrappersMap );

        Element patient = null;
        if ( patientIdentifier == null )
        {
            patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "HealthAdapterTest" );
        }
        else
        {
            patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "HealthAdapterTest", patientIdentifier );
        }

        Document vdmClinicalDataInsert = clinicalDataBuilder.createClinicalData( templateId, count, patient );
        return vdmClinicalDataInsert.asXML();
    }

    protected String createHACreateXml( String patientIdentifier, String entryPoint, String templateId, String recordIdentifier, String personContacted, int count )
    {
        return createHACreateXml( patientIdentifier, entryPoint, templateId, recordIdentifier, personContacted, count, false );
    }

    protected String deleteHACreateXml( String patientIdentifier, String entryPoint, String templateId, String recordIdentifier, boolean logicalDelete )
    {
        Map<String, DomainEntryPoint> domainEntryPointsMap = new HashMap<String, DomainEntryPoint>();
        domainEntryPointsMap.put( templateId, DomainEntryPoint.PatientEnteredContactLogJournalEntry );
        ClinicalDataBuilder clinicalDataBuilder = new ClinicalDataBuilder();
        clinicalDataBuilder.setDomainEntryPointsMap( domainEntryPointsMap );

        Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap = new HashMap<String, ClinicalDomainBuilderFactoryInterface>();
        HAPatientJournalEntryContactLogBuilderFactory factory = new HAPatientJournalEntryContactLogBuilderFactory();
        factory.setContactLogBuilder( new HAContactLogBuilder( recordIdentifier ) );
        domainEntryPointsWrappersMap.put( "PatientEnteredContactLogJournalEntry", factory );
        clinicalDataBuilder.setDomainEntryPointsWrappersMap( domainEntryPointsWrappersMap );

        Element patient = null;
        if ( patientIdentifier == null )
        {
            patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "HealthAdapterTest" );
        }
        else
        {
            patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "HealthAdapterTest", patientIdentifier );
        }

        String recordStatus = "0";
        if ( logicalDelete )
            recordStatus = "1";

        Document vdmClinicalDataInsert = clinicalDataBuilder.deleteClinicalData( domainEntryPointsMap.get( templateId ), templateId, patient, recordIdentifier, recordStatus );
        return vdmClinicalDataInsert.asXML();
    }


    @Test
    @Suite( groups = { "deprecatedtest" } )
    @SuppressWarnings( "unchecked" )
    public void testReadPatientContactLog( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "PatientEnteredContactLogJournalEntry" );

        String filterXml = createHAFilterXml( TEST_READ_PATIENTIDENTITY_HDR, null, ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, "PatientEnteredContactLogJournalEntry",
                        TemplateIdHelper.HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.HEALTH_ADAPTER_READ1_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER, DOMAINENTRYPOINT_XPATH );

        List<Element> dataList = clinicalDataDocument.selectNodes( TEST_READ_JOURNAL_ENTRY_XPATH );
        assertTrue( dataList.size() > 0 );
    }


    @Test
    @Suite( groups = { "deprecatedtest" } )
    @SuppressWarnings( "unchecked" )
    public void testReadPatientContactLogWithStartEndDates( )
        throws Exception
    {

        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "PatientEnteredContactLogJournalEntry" );

        String filterXml = createHAFilterXml( TEST_READ_PATIENTIDENTITY_HDR, null, ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, "PatientEnteredContactLogJournalEntry",
                        TemplateIdHelper.HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER, START_DATE, getEndDateToday() );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.HEALTH_ADAPTER_READ1_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER, DOMAINENTRYPOINT_XPATH );

        List<Element> dataList = clinicalDataDocument.selectNodes( TEST_READ_JOURNAL_ENTRY_XPATH );
        assertTrue( dataList.size() > 0 );
    }


    @Test
    @Suite( groups = { "deprecatedtest" } )
    @SuppressWarnings( "unchecked" )
    public void testReadPatientContactLogStartDateNoEndDate( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "PatientEnteredContactLogJournalEntry" );

        String filterXml = createHAFilterXml( TEST_READ_PATIENTIDENTITY_HDR, null, ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, "PatientEnteredContactLogJournalEntry",
                        TemplateIdHelper.HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER, START_DATE, null );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.HEALTH_ADAPTER_READ1_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER, DOMAINENTRYPOINT_XPATH );

        List<Element> dataList = clinicalDataDocument.selectNodes( TEST_READ_JOURNAL_ENTRY_XPATH );
        assertTrue( dataList.size() > 0 );
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( Map<String, String> assigningFacilityAndPatientIdentityMap, String templateId, String filter, String filterId, String entryPointXpath )
        throws Exception
    {
        Document clinicalDataDocument = super.readAndAssertDomainData( filter );
        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( TEST_READ_JOURNAL_ENTRY_XPATH );
        assertTrue( domainElements.size() > 0 );

        return clinicalDataDocument;
    }


    protected String createHAFilterXml( String patientIdentifier, List<Element> excludeIdentifiers, String assigningAuthority, String assigningFacility, String entryPoint, String filterId,
                    String startDate, String endDate )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createClientName( "clientName", "testClientName" ) );
        element.add( FilterBuilder.createClientRequestInitiationTime( "clientRequestInitiationTime", DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) ) );
        element.add( FilterBuilder.createPatientWithEdipi( "patients", patientIdentifier, excludeIdentifiers, assigningAuthority, assigningFacility ) );
        element.add( FilterBuilder.createMHAEntryFilterWithAdditionalParametersNoEndDate( "entryPointFilter", entryPoint, startDate, endDate, "ID_1" ) );
        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    private String getEndDateToday( )
    {
        Date today = new Date();
        SimpleDateFormat format = new SimpleDateFormat( "yyyy-MM-dd" );
        String parsed = null;

        try
        {
            parsed = format.format( today );
        }
        catch ( Exception e )
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return parsed.toString();
    }
}
