

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.Assert;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadVistaUserTest extends AbstractEndToEndTest
{
    
    private static final String ASSIGNING_FACILITY_VISTA = "654";   
    private static final String XPATH_VISTAUSERS = "//vistaUsers";
    private static final String XPATH_VISTAUSER = "//vistaUsers//vistaUser";

    protected TemplateRequestProcessor templateRequestProcessor;

    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadHdrVistaTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testHdrVistaUsersRead1( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.VISTA_USERS_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.FTP_VISTA_USER_FILTER;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VistaUser" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "vistaUserQuery" );
        entryPointFilterMap.put( FilterBuilder.PATIENT_CENTRIC_KEY, "false" );
        entryPointFilterMap.put( FilterBuilder.FACILITY_ID_KEY, ASSIGNING_FACILITY_VISTA );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        
        Map<String,String>optionalParamsMap = new HashMap<String, String>();
        optionalParamsMap.put("authorLastName", "Provider");
        optionalParamsMap.put("authorFirstName", "Five");
          
        //String filterXml = "<filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><filterId>FTP_VISTA_USER_FILTER</filterId><clientName>FtP</clientName><clientRequestInitiationTime>2001-12-17T09:30:47Z</clientRequestInitiationTime><entryPointFilter queryName=\"ID_1\" facilityId=\"654\" isPatientCentric=\"false\"><domainEntryPoint>VistaUser</domainEntryPoint><otherQueryParameters><authorLastName>Provider</authorLastName><authorFirstName>Five</authorFirstName></otherQueryParameters></entryPointFilter></filter:filter>";
        String  filterXml = FilterBuilder.buildSiteCentricFilterWithOptionalParams(filterId, entryPointFilterMaps, DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), "FtP", optionalParamsMap);
     
        readAndAssertDomainData( readTemplateId, filterId, filterXml, requestId, null, null);
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testHdrVistaUsersRead1WithMiddle( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.VISTA_USERS_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.FTP_VISTA_USER_FILTER;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VistaUser" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "vistaUserQuery" );
        entryPointFilterMap.put( FilterBuilder.PATIENT_CENTRIC_KEY, "false" );
        entryPointFilterMap.put( FilterBuilder.FACILITY_ID_KEY, ASSIGNING_FACILITY_VISTA );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        
        Map<String,String>optionalParamsMap = new HashMap<String, String>();
        optionalParamsMap.put("authorLastName", "Provider");
        optionalParamsMap.put("authorFirstName", "Five");
        optionalParamsMap.put("authorMiddleName", "H");
                 
        //String filterXml = "<filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><filterId>FTP_VISTA_USER_FILTER</filterId><clientName>FtP</clientName><clientRequestInitiationTime>2001-12-17T09:30:47Z</clientRequestInitiationTime><entryPointFilter queryName=\"ID_1\" facilityId=\"654\" isPatientCentric=\"false\"><domainEntryPoint>VistaUser</domainEntryPoint><otherQueryParameters><authorLastName>Provider</authorLastName><authorFirstName>Five</authorFirstName><authorMiddleName>H</authorMiddleName></otherQueryParameters></entryPointFilter></filter:filter>";
        String  filterXml = FilterBuilder.buildSiteCentricFilterWithOptionalParams(filterId, entryPointFilterMaps, DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), "FtP", optionalParamsMap);
     
        readAndAssertDomainData( readTemplateId, filterId, filterXml, requestId, null, null);
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testHdrVistaUsersRead1InactiveUser( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.VISTA_USERS_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.FTP_VISTA_USER_FILTER;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VistaUser" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "vistaUserQuery" );
        entryPointFilterMap.put( FilterBuilder.PATIENT_CENTRIC_KEY, "false" );
        entryPointFilterMap.put( FilterBuilder.FACILITY_ID_KEY, ASSIGNING_FACILITY_VISTA );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        
        Map<String,String>optionalParamsMap = new HashMap<String, String>();
        optionalParamsMap.put("authorLastName", "Mail");
        optionalParamsMap.put("authorFirstName", "Test");
          
        //String filterXml = "<filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><filterId>FTP_VISTA_USER_FILTER</filterId><clientName>FtP</clientName><clientRequestInitiationTime>2001-12-17T09:30:47Z</clientRequestInitiationTime><entryPointFilter queryName=\"ID_1\" facilityId=\"654\" isPatientCentric=\"false\"><domainEntryPoint>VistaUser</domainEntryPoint><otherQueryParameters><authorLastName>Provider</authorLastName><authorFirstName>Five</authorFirstName></otherQueryParameters></entryPointFilter></filter:filter>";
        String  filterXml = FilterBuilder.buildSiteCentricFilterWithOptionalParams(filterId, entryPointFilterMaps, DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), "FtP", optionalParamsMap);
     
        //readAndAssertDomainData( readTemplateId, filterId, filterXml, requestId, null, null);
        
        Document vistaUserDataDocument = sendRequest( readTemplateId, filterId, filterXml, requestId, null, null);

        List<Element> vsuElements = vistaUserDataDocument.selectNodes(XPATH_VISTAUSER );
        
        assertTrue( vsuElements.size() == 0 );
           
    }

    protected Document readAndAssertDomainData( String templateId, String filterId, String filterXml, String requestId, List<Map<String, String>> entryPointFilterMaps, Map<String, String>optionalParamsMap )
        throws Exception
    {
        Document vistaUserDataDocument = sendRequest( templateId, filterId, filterXml, requestId, entryPointFilterMaps, optionalParamsMap);

        chkXML( vistaUserDataDocument );

        return vistaUserDataDocument;
    }

    private Document sendRequest( String templateId, String filterId, String filterXml, String requestId, List<Map<String, String>> entryPointFilterMaps,Map<String, String> optionalParamsMap)
    {
        templateRequestProcessor.setValidateReadResponseXML( true );
        Document vistaUserDataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
        assertNotNull( vistaUserDataDocument );
        String vistaUserDataXml = vistaUserDataDocument.asXML();
        Assert.assertXmlValidation( vistaUserDataXml, templateId, "Vistauserdata" );
        return vistaUserDataDocument;
    }


    private void chkXML( Document vistaUserDataDocument )
    {
        List<Element> vsuElements = vistaUserDataDocument.selectNodes(XPATH_VISTAUSERS );
        assertTrue( vsuElements.size() > 0 );
    }

}
