/**
 * 
 */


package gov.va.med.cds.response.strategy;


import org.json.JSONObject;
import org.json.XML;


/**
 * @author DNS   kondas
 * 
 * <p>In some cases, the VistA Generic Stored Procedure responds with multiple records that
 * constitutes a single result from the VistAa system. The result is split between multiple
 * records due to limitation that Cache / MUMPS systems have with regard to string lengths.
 * 
 * <p>This response strategy object assumes that all of the records passed into the format
 * response method are a single record and concatenates the response prior to sending it on. 
 *
 */
public class VistaGenericStoredProcedureXmlResponseStrategy

{

    public String convertToJson( String xmlData )
    {
        JSONObject xmlJSONObj = XML.toJSONObject( xmlData.trim() );
        return xmlJSONObj.toString();
    }

}
