/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import org.hibernate.Session;

/**
 * @author DNS   egberb
 *
 */
public interface HibernateEntityLocatorInterface<T> {

	/**
	 * Finds the Hibernate entity within the current session give the 
	 * information included in the unmanaged entity.
	 * @param session The current session to use to lookup the entity.
	 * @param unmanaged Information used to find the unique entity.
	 * @return The unique entity.
	 */
	T find(Session session, T unmanaged);

}
