

package gov.va.med.cds.persistence;

import java.util.List;

import commonj.work.Work;




public interface QueryWorkInterface
    extends Work
{

    /**
     * Returns the query association object association with this query work.
     * @return The association query work.
     */
    QueryAssociationInterface getQueryAssociation( );


    /**
     * Gets the result or outcome of the query.
     * @return The result.
     */
    Object getResults( );
    
    
    /**
     * Returns the list of any exceptions that occurred while executing the 
     * query work. This method will never return null. 
     * @return The non-null list of exceptions.
     */
    List<Exception> getExceptions( );
    
    
    /**
     * Allows for external classes to add exceptions to the list of exceptions
     * contained by the query work objects.
     * @param ex The exception to add.
     * @param applicationName Name of the application eg. CDS or Pathways
     */
    void addException( Exception ex, String applicationName );

}