

package gov.va.med.cds.ars.request;



/**
 *
 * Performs the Report operations based on the client request. 
 *
 */
public interface RequestProcessorInterface
{

    /**
     * Synchronous version of a clinical aggregate data read
     *
     * @param reportRequest Filter request specified in xml format according to the CDS filter schema
     * @param reportId ID of the named (canned) filter. 
     * @param requestId Client specified unique request Id
     * @return Results of the read returned in XML according to the CDS read results schema
     */
    String readAggregateData( 	String reportRequest, 
    							String reportId, 
    							String clientId,
    							String requestId );

}
