

package gov.va.med.cds.ars.persistence;


import gov.va.med.cds.ars.requestresponse.generated.DMPUniqueICNReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DMPUniqueICNReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.LocationReportDataType;
import gov.va.med.cds.exception.PersistenceException;

import java.sql.Date;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;


public class DMPUniqueICNReportsPersistenceManager
    extends
        AbstractReadableReportsPersistenceManager
    implements
        ReadableReportsPersistenceManagerInterface
{
    protected String countDMPsUniqueICNQuery = "SurveyReports.countDMPsUniqueICN";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
    {
        DMPUniqueICNReportFilterType filter = aReportFilter.getDMPUniqueICNReportFilter();
        DMPUniqueICNReportDataType data = new DMPUniqueICNReportDataType();
        Session session = this.sessionFactory.getCurrentSession();
                
        try
        {
            List<LocationReportDataType> results = null;
            Integer surveyCount = null;
            
            results = dmpUniqueIcnReport( session, filter );
            surveyCount = getSurveyCount( results );

            data.getReportData().addAll( results );
            data.setNumberOfRecordsConsidered( surveyCount );
            data.setReportID( filter.getReportID() );
        }
        finally
        {
            session.close();
        }
        
        responseType.setDMPUniqueICNReportData( data );
        
        return responseType;
    }
    

    @SuppressWarnings( "unchecked" )
    private List<LocationReportDataType> dmpUniqueIcnReport( Session aSession, DMPUniqueICNReportFilterType aDMPReportFilter )
        throws PersistenceException
    {       
        String surveyType = aDMPReportFilter.getSurveyType();
        String location = aDMPReportFilter.getGeographicalArea().getLocation();
        String vendor = aDMPReportFilter.getVendor();
        Date startDate = formatDate( aDMPReportFilter.getStartDate() );
        Date endDate = formatDate( aDMPReportFilter.getEndDate() );
        
        Query query = aSession.getNamedQuery( countDMPsUniqueICNQuery );
        query.setString( "surveyType", surveyType );
        query.setString( "location", location );
        query.setString( "vendor", vendor );
        query.setDate( "startDate", startDate );
        query.setDate( "endDate", endDate );
    
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug("+++++ Calling DMP Unique ICN stored proc: *****(  " + countDMPsUniqueICNQuery + "  )*****" );
            LOGGER.debug( " surveyType: " + surveyType );
            LOGGER.debug( " location: " + location );
            LOGGER.debug( " vendor: " + vendor );
            LOGGER.debug( " startDate: " + startDate );
            LOGGER.debug( " endDate: " + endDate );
        }
        
        List<LocationReportDataType> results = ( List<LocationReportDataType> )queryForReportData( query );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "----- Done with DMP Unique ICN stored proc" );
        }

        return results;
    }


    public void setCountDMPsUniqueICNQuery( String aCountDMPsUniqueICNQuery )
    {
        this.countDMPsUniqueICNQuery = aCountDMPsUniqueICNQuery;
    }

}

