package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusTotalRuralFacilityADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthTotalRuralFacilityADCDataQuery = "SurveyReports.TotalRuralfacilityAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusTotalRuralFacilityADCReportFilterType filter = aReportFilter.getCensusTotalRuralFacilityADCReportFilter();
		CensusTotalRuralFacilityADCReportDataType data = new CensusTotalRuralFacilityADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusTotalRuralFacilityADCLocationReportDataType> results = null;

		try {
			results = getTotalRuralFacilityADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusTotalRuralFacilityADCReportData(data);

		return responseType;
	}    


	@SuppressWarnings("unchecked")
	private List<CensusTotalRuralFacilityADCLocationReportDataType> getTotalRuralFacilityADCData( Session aSession, CensusTotalRuralFacilityADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthTotalRuralFacilityADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthTotalRuralFacilityADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusTotalRuralFacilityADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusTotalRuralFacilityADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getTotalRuralFacilityADCData " + e);
		}

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthTotalRuralFacilityADCDataQuery);
		}

		return results;
	}

    
    public void setHthTotalRuralFacilityADCDataQuery(String hthTotalRuralFacilityADCDataQuery) {
		this.hthTotalRuralFacilityADCDataQuery = hthTotalRuralFacilityADCDataQuery;
	}
}

